/*  REPLACE.C
 *
 *  NEW -- by Scott R. Houck
 */

#include <stdlib.h>
#include <string.h>
#include <direct.h>
#include <ctype.h>
#include "new.h"

char *Replace(char *dest, char *source, char *fullpathname, int dirflag)
{
   char *p = source;
   char *q = dest;
   char *r;
   char drive     [ _MAX_DRIVE ];
   char directory [ _MAX_DIR   ];
   char filename  [ _MAX_FNAME ];
   char extension [ _MAX_EXT   ];
   char name_ext  [ _MAX_FNAME + _MAX_EXT + 1 ];
   char cwdbuf[128];

   _splitpath(fullpathname, drive, directory, filename, extension);
   if (*drive == EOS)
      {
      getcwd(cwdbuf, 127);
      *drive = *cwdbuf;
      }
   drive[1] = EOS;                        // eat the colon
   directory[strlen(directory)-1] = EOS;  // eat the trailing slash
   if (*extension)
      strcpy(extension, extension + 1);   // eat the leading period

   if (dirflag)
      {
      *strrchr(fullpathname, '\\') = EOS;
      *filename  = EOS;
      *extension = EOS;
      }

   if (*extension)
      sprintf(name_ext, "%s.%s", filename, extension);
   else
      strcpy(name_ext, filename);

   while (*p)
      {
      if (*p == '%')
         {
         switch (toupper(*(p+1)))
            {
            case 'N':  r = name_ext;      break;
            case 'P':  r = fullpathname;  break;
            case 'D':  r = drive;         break;
            case 'S':  r = directory;     break;
            case 'F':  r = filename;      break;
            case 'E':  r = extension;     break;
            default:   r = NULL;          break;
            }
         if (r)
            {
            while (*r)
               *q++ = *r++;   // copy the replacement string
            p += 2;           // make p point past the %x
            }
         else     // no match -- just copy the percent sign
            *q++ = *p++;
         }
      else
         *q++ = *p++; // wasn't a percent sign -- just copy the character
      }
   *q = *p;    // copy the final null

   return dest;
}

