/*  PRTHELP.C
 *
 *  NEW -- by Scott R. Houck
 */

#include <io.h>
#include <stdlib.h>
#include "new.h"

char *helpText[] = {
   "The syntax is:  NEW [filespec(s)] [options]",
   "",   
   "If filespec is omitted, *.* is assumed.  Also, a \"day\" in this",
   "program starts at 6:00 am and ends at 5:59 am the following day.",
   "Options and filespecs can be in any order.  Valid options are:",
   "",   
   "   /n           Show files SINCE  the number of \"days\" specified by n",
   "   /-n          Show files BEFORE the number of \"days\" specified by n",
   "   /A           Include ALL files, regardless of timestamp",
   "   /C cmd       Invoke command \"cmd\" for each file found.",
   "   /D           Include directories in listing",
   "   /DO          Include directories ONLY in listing",
   "   /E           Search entire disk",
   "   /Fn          Use format n (default is n = 1)",
   "   /G           Guru mode -- use simple prompt when pausing (/P)",
   "   /H or /?     Show help screen",
   "   /I           Ignore the environment variable NEW if it is defined",
   "   /J           Junk option -- include files with corrupted dates",
   "   /Kn          Use output option n (0-3) if /C or /V is used",
   "   /NP          Force No Pause",
   "   /NQ          Force No Quiet mode on /C or /V",
   "   /O...        Sort order /O{U|N|E|D|S}[-]  (Default = /OD-)",
   "   /P           Pause when screen display is full",
   "   /Q           Quiet mode -- don't ask for confirmation on /C or /V",
   "   /S           Search specified directory and its subdirectories",
   "   /[-]T...     Use a specific timestamp",
   "   /V [batfile] Invoke Polytron VCS PUT for each file found",
   "   /X           Suppress opening",
   "",   
   "Details on /n",
   "-------------",
   "",
   "   Besides just specifying a simple number of \"days\" ago (6 am to",
   "   5:59 am), time periods may also be specified as follows:",
   "",   
   "      /[n1D][n2H][n3M][n4S] means show files as of n1 days, n2 hours,",
   "                            n3 minutes, and/or n4 seconds ago",
   "   Examples:",
   "",
   "     /3h           = as of 3 hours ago",
   "     /3h30m        = as of 3 hours and 30 minutes ago",
   "     /5d5s         = as of 5 days and 5 seconds ago",
   "     /10d10h10m10s = as of 10 days, 10 hrs, 10 mins, and 10 secs ago",
   "",
   "   NOTE:  /3d is NOT equivalent to /3 since /3 takes into account",
   "          the 6:00 am start time for a \"day.\"  /3d means EXACTLY",
   "          3 days ago from the current time.",
   "",
   "Details on /T",
   "-------------",
   "",
   "   Another alternative is to use a specific timestamp:",
   "",
   "      /[-]T{date|time}[,{time|date}]",
   "",
   "   date is of the format mm-dd[-yy]",
   "",
   "   mm-dd-yy = month, day, and year",
   "              If yy is omitted, it defaults to the current year.",
   "",
   "   time is of the format hh:mm[:ss][{a|p}[m]]",
   "",
   "   hh:mm:ss = hours, minutes, and seconds",
   "              If ss is omitted, it defaults to 00.",
   "              24-hour notation may be used, and you may specify",
   "              am or pm (or just a or p).  E.g., /T9:00p, /T9:00pm,",
   "              and /T21:00 are equivalent.  If p[m] or a[m] are",
   "              specified, and mm = 0, you may omit mm.  That is,",
   "              /T9:00pm can be expressed as /T9pm or even /T9p.",
   "              If mm or ss is specified, they must each be two digits",
   "              long.  E.g. /T9:05, not /T9:5.",
   "",
   "   If BOTH mm-dd-yy and hh:mm:ss are given, they must be separated",
   "   by a comma.  For example, /T10-15,9:00.  You may also express this",
   "   as /T9:00,10-15.  Alternatively, they may be expressed as separate",
   "   /T options:  /T10-15 /T9:00.",
   "",
   "   If the minus sign is used (/-T...), it means search for files that",
   "   are BEFORE the specified time (analogous to /-n).",
   "",
   "Details on /C cmd",
   "-----------------",
   "",
   "   If /C is used, then the command \"cmd\" will be executed for each",
   "   file NEW finds.  /C must be the last NEW option, as anything",
   "   after /C is interpreted as the string to pass to COMMAND.COM.",
   "   (This also allows \"cmd\" to have its own options beginning with a",
   "   slash.)  The command may reference the filename or its separate",
   "   parts by using the special symbols defined below.",
   "",
   "   For example, if the filename NEW finds is "
       "\"c:\\sub1\\sub2\\FNAME.DAT\",",
   "   the following symbols will be interpreted as:",
   "",
   "      %P = full pathname       (c:\\sub1\\sub2\\FNAME.DAT)",
   "      %D = drive letter        (c)",
   "      %S = subdirectory path   (\\sub1\\sub2)",
   "      %F = filename            (FNAME)",
   "      %E = extension           (DAT)",
   "      %N = filename.extension  (FNAME.DAT)",
   "",
   "   Note that %D:%S\\%F.%E and %D:%S\\%N are equivalent to %P.",
   "",
   "   For example, to copy new files to drive B:, use",
   "",
   "      NEW /C COPY %P B:",
   "",
   "   NEW will ask for confirmation for each file that is to be",
   "   processed.  You may circumvent this by using the /Q option.",
   "",
   "   NOTE:  If the /C option is used in a batch file, you must double",
   "          the percent signs in the symbols above.  For example, if",
   "          the previous example was in a batch file, it should be typed",
   "          in as:",
   "",
   "      NEW /C COPY %%P B:",
   "",
   "Details on /V [batfile]",
   "-----------------------",
   "",
   "   The /V option will invoke the Polytron Version Control System",
   "   command PUT using the flags -U and -N for each file processed",
   "   by NEW for which a logfile exists.  The environment variable",
   "   VCSCFG must be defined for the VCS configuration file.  In",
   "   addition, the configuration file must contain a valid VCSDIR",
   "   directive so that NEW can find the logfiles.",
   "",
   "   As with the /C option, NEW will ask for confirmation for each",
   "   file to be processed.  Use /Q to bypass the confirmation.",
   "",
   "   If a filename (default extension .BAT) is specified after /V,",
   "   a batch file will be created instead of invoking PUT.",
   "   For example,    NEW /V runput    will create RUNPUT.BAT.",
   "",
   "Details on /Kn",
   "--------------",
   "",
   "   For /Kn, as the /C or /V command is executing for each file found:",
   "",
   "      If n = 0:  suppress NEW output AND do not print command",
   "      If n = 1:  show NEW output AND print command (default)",
   "      If n = 2:  print command only",
   "      If n = 3:  print NEW output only",
   "",
   "   For example, to backup to drive B: while suppressing NEW output:",
   "",
   "      NEW /K2 /C COPY %P B:",
   "",
   "   NOTE:  Even if /K0 is chosen, the command will still be printed",
   "          as NEW asks for confirmation to execute each command.",
   "          This may be avoided by using /Q:",
   "",
   "      NEW /Q /K0 /C COPY %P B:",
   "",
   "Details on /NP and /NQ",
   "----------------------",
   "",
   "   These options can be used to override /P and /Q if the latter are",
   "   defined as options in the NEW environment variable.  /NP and /NQ",
   "   may only be used on the command line.  They may not be specified",
   "   in the NEW environment variable.  Remember that /I will cause NEW",
   "   to ignore ALL options set in the NEW environment variable.",
   "",
   "Details on /O{U|N|E|D|S}[-]",
   "---------------------------",
   "",
   "   The /O option allows you to control how the files are sorted for",
   "   display.  Choose one of the sort options, optionally followed by",
   "   a dash (to reverse the sort order).",
   "",
   "        U = unsorted",
   "        N = sort by name",
   "        E = sort by name within extension",
   "        D = sort by date",
   "        S = sort by size",
   "",
   "   The default sort option is /OD- (by descending date).",
   NULL
};


void PrintHelp()
{
   char **p;

   if (!printedOpening && !xopening)
      PrintOpening();
   pausing = YES;
   for (p = helpText; *p; p++)
      {
      fputs(*p, stdout);
      fputs("\n", stdout);
      ++lines;
      if (isatty(fileno(stdout)) && CheckPause(CHECK_ESC))
         break;
      }
   exit(0);
}

