/*  PARSE.C
 *
 *  NEW -- by Scott R. Houck
 */

#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "new.h"

int specifiedSince   = NO;
int specifiedKoption = NO;
int specifiedFormat  = NO;
int specifiedNoPause = NO;
int specifiedNoQuiet = NO;

#pragma loop_opt(off)

void Parse(char *p, int option, int mode)
{
   char *q;
   FIND_T dummy;
   char ch;
   char *cptr;
   char slashC[3];
   char *mutually_exclusive = " options are mutually exclusive";
   char *invalid_in_env = " option in environment variable NEW is invalid";

   if (option)
      switch (toupper(*p))
         {
         case 'A':
            allfiles = YES;
            if (tstamp)
               Fatal("/T and /A%s", mutually_exclusive);
            if (specifiedSince)
               Fatal("/n and /A%s", mutually_exclusive);
            break;

         case 'C':
            // Abort if /C had already been specified
            if (command)
               Fatal("/C can only be specified once");
            command = YES;
            slashC[0] = '/';
            slashC[1] = *p;
            slashC[2] = EOS;
            if (mode == CMDLINE)
               cptr = strstr(origTail, slashC);
            else
               cptr = strstr(origEnv, slashC);
            rtrim(strcpy(cmdstr, cptr + 2));
            if (!*cmdstr)
               Fatal("/C option must be followed by a command string");
            break;

         case 'D':
            if (toupper(*(p+1)) == 'O')
               dirsonly = YES;
            else
               dirs = YES;
            if (dirs && dirsonly)
               Fatal("/D and /DO%s", mutually_exclusive);
            break;

         case 'E':
            entire = YES;
            break;

         case 'F':
            // Allow user to override /Fn on command line
            if (mode == ENVIRON && specifiedFormat)
               break;
            specifiedFormat = YES;
            if (*(p+1) == '0')
               format = 0;
            else if (*(p+1) == '1')
               format = 1;
            else
               Fatal("Must be either /F0 or /F1");
            break;

         case 'G':
            guru = YES;
            break;

         case 'H':
         case '?':
            help = YES;
            pausing = YES;
            if (mode != CMDLINE)
               Fatal("/H or /?%s", invalid_in_env);
            break;

         case 'I':
            if (mode == CMDLINE)
               ignore = YES;
            else
               Fatal("/I%s", invalid_in_env);
            break;

         case 'J':
            junk = YES;
            break;

         case 'K':
            // Allow user to override /Kn on command line
            if (mode == ENVIRON && specifiedKoption)
               break;
            specifiedKoption = YES;
            koption = *(p+1) - '0';
            if (!*(p+1) || koption < 0 || koption > 3)
               Fatal("/K option must be followed by 0, 1, 2, or 3");
            break;

         case 'N':
            if ((ch = toupper(*(p+1))) == 'P')
               {
               if (mode == ENVIRON)
                  Fatal("/NP%s", invalid_in_env);
               else
                  {
                  specifiedNoPause = YES;
                  pausing = NO;
                  }
               }
            else if (ch == 'Q')
               {
               if (mode == ENVIRON)
                  Fatal("/NQ%s", invalid_in_env);
               else
                  {
                  specifiedNoQuiet = YES;
                  quiet = NO;
                  }
               }
            else
               Fatal("Valid /N options are /NP and /NQ");
            break;

         case 'O':
            order = ASCENDING;
            switch (toupper(*(p+1)))
               {
               case 'U':  compare = NULL;       break;
               case 'N':  compare = compare_n;  break;
               case 'E':  compare = compare_e;  break;
               case 'D':  compare = compare_d;  break;
               case 'S':  compare = compare_s;  break;
               default:
                  Fatal("Valid /O options are /OU, /ON, /OE, /OD, and /OS\n"
                     "Add a minus sign to reverse sort order (e.g. /ON-)");
               }
            if (*(p+2) == '-')
               order = DESCENDING;
            break;

         case 'P':
            if (mode == ENVIRON && specifiedNoPause)
               break;
            pausing = YES;
            break;

         case 'Q':
            if (mode == ENVIRON && specifiedNoQuiet)
               break;
            quiet = YES;
            break;

         case 'S':
            subdirs = YES;
            break;

         case 'T':
            tstamp = YES;
            if (specifiedSince)
               Fatal("/n and /T%s", mutually_exclusive);
            if (allfiles)
               Fatal("/A and /T%s", mutually_exclusive);
            ParseToption(p);
            ValidateToption();
            break;

         case 'V':
            vcsput = YES;
            if (*++p)
               {
               vfile = YES;
               ltrim(strupr(strcpy(vfname, p)));
               if ((q = strchr(vfname, '.')) == NULL)
                  strcat(vfname, ".BAT");
               }
            break;

         case 'X':
            xopening = YES;
            break;

         case '-':
            if (!before)
               {
               before = YES;
               Parse(p+1, 1, mode);
               }
            else
               Fatal("\"-\" can only be specified once");
            break;

         default: //   /n  or  /[n1D][n2H][n3M][n4S]
            if (isdigit(*p) && strpbrk(p, "dDhHmMsS"))
               {
               tstamp = YES;
               ParseAgo(p);
               break;
               }
            if (!specifiedSince)
               {
               for (q = p; *q; q++)
                  if (!isdigit(*q))
                     {
                     fprintf(stderr, "Invalid option \"/%s\"\n\n", p);
                     help = YES;
                     }
               since = atol(p);
               specifiedSince = YES;
               }
            else
               Fatal("The number of days cannot be specified more "
                  "than once");
            if (tstamp)
               Fatal("/T and /n%s", mutually_exclusive);
            break;
         }

   else  // if not an option
      AddList(dummy, StrAlloc(p), &specList, &specTail);
}

#pragma loop_opt(on)

