/*  INIT.C
 *
 *  NEW -- by Scott R. Houck
 */

#include <stdlib.h>
#include <memory.h>
#include "new.h"

void Initialize()
{
   char _far *farTail = origTail;
   char _far *length  = MK_FP(_psp, 0x80);
   int rows;

   // Get the current date and time and convert date to julian
   _dos_getdate(&curdate);
   _dos_gettime(&curtime);
   tjul = gtoj(curdate.month, curdate.day, curdate.year);

   // Defaults for /T variables
   t_month = curdate.month;
   t_day   = curdate.day;
   t_year  = curdate.year % 100;
   t_hour  = t_minute = t_second = 0;  /* 12:00:00 midnight */

   // Get the unformatted command tail
   movedata(_psp, 0x81, FP_SEG(farTail), FP_OFF(farTail), *length);
   origTail[*length] = EOS;

   /* Determine the number of text rows.  Note that I move the value
    * of DX into an automatic variable (rows) instead of into numrows
    * directly.  If I use "mov numrows,dx", the assembly listing shows
    * that MSC is not loading ES with the segment of numrows before the
    * move.
    *
    * Calling the BIOS routine is the most portable way to determine the
    * number of text rows.  However, the following code, which reads the
    * the value from low memory, should also work:
    *
    *      numrows = *(char _far *) MK_FP(0x40, 0x84);
    */

   _asm
      {
      mov   ax,1130h
      xor   bh,bh
      push  bp
      int   10h
      pop   bp
      xor   dh,dh
      mov   rows,dx
      }

   numrows = (rows == 0 ? 24 : rows);
}

