/*  CURSOR.C
 *
 *  NEW -- by Scott R. Houck
 */

#include "new.h"

#define MONOCHROME   7

static int  GetVideoMode(void);
static void SetCursor(int);

void ResetCursor()
{
   if (GetVideoMode() == MONOCHROME)
      SetCursor(0x0C0D);
   else if (numrows == 42)
      SetCursor(0x0405);
   else
      SetCursor(0x0607);
}


void HideCursor()
{
   SetCursor(0x2000);
}


static int GetVideoMode()
{
   _asm
      {
      mov   ah,0Fh
      int   10h      ; mode is in AL
      xor   ah,ah    ; clear AH since result is returned in AX
      }
}


static void SetCursor(int attr)
{
   _asm
      {
      mov   ah,1
      mov   cx,attr
      int   10h
      }
}

