
// --------------------------------------------------------------------
//
//   Construct a CDialog template
//

#ifndef __TEMPLATE_H

#include "classes.h"

#include "cresrce.h"
    
#include <limits.h>

class CDialogTemplate;

class CDialogItem : public CObject
	{
public:
	__export CDialogItem(CDialogTemplate *pTemplate, LPCSTR szClass, long lStyle);
	__export CDialogItem(CDialogTemplate *pTemplate, unsigned char cClass, long lStyle = LONG_MIN);
	__export CDialogItem(CDialogTemplate *pTemplate, const char *pData, int *piBytesUsed);
	__export CDialogItem(CDialogTemplate *pTemplate, const CDialogItem *pSrcItem);

	// Setting focus : if no priority is specified, defaults to 1.  Positive
	// priorities are ranked in reverse order (priority 1 wins over priority
	// 2) and always win over negative or zero priorities.  If multiple items
	// have the winning positive priority value, the first item defined (not
	// necessarily the first item to have set_focus() called) will win.
	// Nonpositive (zero and negative) priorities are compared using their
	// absolute values : priority 0 wins over priority -1 which wins over
	// priority -2.  If no positive priority values are found, and multiple
	// items have the winning nonpositive priority value, the last item
	// defined (not necessarily the last item to have set_focus() called) will
	// win.  The function get_focus() in CDialogTemplate must be called
	// to determine the winner.
	CDialogItem * __export set_focus(int iPriority = 1)
		{ m_iFocusPriority = iPriority; return this; }
	
	CDialogItem *set_position(int iLeft, int iTop)
		{ set_left(iLeft); return set_top(iTop); }
	CDialogItem *set_position(CPoint &pt)
		{ set_left(pt.x); return set_top(pt.y); }
	CDialogItem *set_left(int iLeft)
		{
		if (m_rect.right >= 0)
			m_rect.right += iLeft - m_rect.left;
		m_rect.left = iLeft;
		return this;
		}
	CDialogItem *set_top(int iTop)
		{
		if (m_rect.bottom >= 0)
			m_rect.bottom += iTop - m_rect.top;
		m_rect.top = iTop;
		return this;
		}
	CPoint __export get_position(void);

	CDialogItem * __export set_size(int iWidth, int iHeight);
	CDialogItem *set_size(const CSize &size)
		{ return set_size(size.cx, size.cy); }
	CDialogItem *set_width(int iWidth)
		{ m_rect.right = m_rect.left + iWidth; return this; }
	CDialogItem *set_height(int iHeight)
		{ m_rect.bottom = m_rect.top + iHeight; return this; }
	CDialogItem *set_right(int iRight)
		{ m_rect.right = iRight; return this; }
	CDialogItem *set_bottom(int iBottom)
		{ m_rect.bottom = iBottom; return this; }

	// Vertically center this item around the center of the specified item.
	CDialogItem *vert_center_to(const CDialogItem *pOther, BOOL bClosed = TRUE)
		{ set_top(pOther->top() + (pOther->height(bClosed) - height(bClosed)) / 2); return this; }

	CRect get_rect(void) const
		{ return m_rect; }
	void set_rect(const RECT &rect)
		{ m_rect = rect; }

	long get_style(void) const
		{ return m_lStyle; }
	void set_style(long lStyle)
		{ m_lStyle = lStyle; return; }

	// set_text() will set the size (if not already set)
	CDialogItem * __export set_text(LPCSTR szText);
	CDialogItem *set_text(UINT uResourceID)
		{ CString szText; szText.LoadString(uResourceID); return set_text((LPCSTR)szText); }
	LPCSTR get_text(void) const
		{ return (LPCSTR)m_szText; }
	
	CDialogItem *set_id(unsigned int uID)
		{ m_uID = uID; return this; }
	unsigned int get_id(void) const
		{ return m_uID; }

	CString get_class(void) const
		{ return m_szClass; }

	// Both should return the same value
	unsigned int __export bytes_to_generate(void) const;
	unsigned int __export generate(char *pBuffer) const;

	int right(void) const	{ return m_rect.right; }
	int left(void) const	{ return m_rect.left; }
	int top(void) const		{ return m_rect.top; }
	int bottom(void) const	{ return m_rect.bottom; }
	int width(void) const	{ return m_rect.Width(); }
	// If bClosed is FALSE and the item is a dropdown (or dropdown list)
	// combobox, the height returned is the open height.  If bClosed is TRUE
	// (the default) or if the item is not a dropdown (or dropdown list)
	// combobox, the open (or actual) height is returned.
	int __export height(BOOL bClosed = TRUE) const;

	// Create the window specified in this object
	HWND Create(HWND hWndParent, HINSTANCE hInstance);

protected:
	CRect m_rect;			// In dialog box units!
	unsigned int m_uID;
	long m_lStyle;
	int m_iFocusPriority;
	CString m_szClass;
	CString m_szText;
	CDialogTemplate *m_pTemplate;
	};
	

class CDialogTemplate : public CObject
	{
public:
	__export CDialogTemplate(CWnd *pParent);
	__export ~CDialogTemplate();
	
	BOOL __export load(LPCSTR szTemplateName);
	BOOL __export load(int iTemplateID);
	BOOL __export load(CResource &hResource);
	
	CDialogTemplate &set_menu(LPCSTR szMenuName)
		{ m_szMenuName = szMenuName; return *this;}
	CDialogTemplate &set_class(LPCSTR szClassName)
		{ m_szClassName = szClassName; return *this; }
	CDialogTemplate &set_style(long lStyle)
		{ m_lStyle = lStyle; return *this; }
	BOOL __export set_font(LPCSTR szFaceName, WORD wPointSize);

	CDialogTemplate &set_caption(LPCSTR szCaption)
		{ m_szCaption = szCaption; return *this; }
	CDialogTemplate &set_caption(UINT nID)
		{ m_szCaption.LoadString(nID); return *this; }
	LPCSTR get_caption(void) const
		{ return (LPCSTR)m_szCaption; }

	// Call set_position() _before_ set_size()
	CDialogTemplate &set_position(int iLeft, int iTop)
		{ m_rect.left = iLeft; m_rect.top = iTop; return *this; }
	CDialogTemplate & __export set_size(int iWidth, int iHeight);
	CSize __export get_size(void);
	
	CDialogItem * __export add_item(LPCSTR szClass, long lStyle);
	CDialogItem * __export add_item(unsigned char cClass, long lStyle = LONG_MIN);
	// Notice that this next function makes a copy of the given item and
	// keeps hold of that.  If iIndex is specified, inserts the new
	// item in the array at the specified index, moving all other items
	// up a slot.
	CDialogItem * __export add_item(const CDialogItem *pItemToCopy, int iIndex = -1);

	HGLOBAL __export generate(void);

	CSize __export GetTextExtent(LPCSTR szText);

	// Dialog values are in dialog units; pixel values are in client window units
	static int __export pixel_x_to_dialog(int iPixelX);
	static int __export pixel_y_to_dialog(int iPixelY);
	static CSize __export pixel_to_dialog(const CSize &size);
	static CRect __export pixel_to_dialog(const CRect &rect);
	int __export dialog_x_to_pixel(int iDialogX);
	int __export dialog_y_to_pixel(int iDialogY);
	CSize __export dialog_to_pixel(const CSize &size);
	CRect __export dialog_to_pixel(const CRect &rect);

	CDC *get_dc(void)
		{ return m_pDC; }

	int num_items(void) const
		{ return m_aItems.GetSize(); }
	CDialogItem *get_item(int iIndex)
		{ return (CDialogItem *)m_aItems[iIndex]; }
	const CDialogItem *get_item(int iIndex) const
		{ return (const CDialogItem *)m_aItems[iIndex]; }
	CDialogItem * __export find_item(UINT uID);
	int __export find_item_index(UINT uID) const;

	BOOL __export remove_item(UINT uID);

	// Returns an ID which does not currently exist in the template
	UINT __export unused_id(void) const;

protected:	
	long m_lStyle;
	CRect m_rect;
	CString m_szMenuName;
	CString m_szClassName;
	CString m_szCaption;
	CObArray m_aItems;
	WORD m_wPointSize;
	CString m_szFaceName;
	static long m_lDialogUnits;
	long m_lXFontConvert, m_lYFontConvert;
	CWnd *m_pParent;
	CClientDC *m_pDC;
	};
	
#define __TEMPLATE_H
#endif
