// ------------------------------------------------------------------------
//
//   Create a class that creates a mapping from a pointer to a long
//
//   For explanation, see CMapPtrToPtr in the Microsoft documentation
//
// ------------------------------------------------------------------------

#ifndef __MAP_PL_H


#define MAP_PL_BEFORE_START_POSITION ((void*)-1L)

class CMapPtrToLong : public CMapPtrToPtr
	{
	DECLARE_DYNAMIC(CMapPtrToLong)
public:
// Construction
	CMapPtrToLong(int nBlockSize=10)
		: CMapPtrToPtr(nBlockSize) {}

	// Lookup
	BOOL Lookup(const void *key, long &rValue) const
		{ return CMapPtrToPtr::Lookup((void *)key, (void *&)rValue); }

	// Lookup and add if not there
	long & operator[](const void *key)
		{ return (long &)CMapPtrToPtr::operator[]((void *)key); }

	// add a new (key, value) pair
	void SetAt(const void *key, long newValue)
		{ CMapPtrToPtr::SetAt((void *)key, (void *)newValue); return; }

	POSITION GetStartPosition() const
		{ return (GetCount() == 0) ? NULL : MAP_PL_BEFORE_START_POSITION; }
	void __export GetNextAssoc(POSITION& pos, void *& rKey, long &rValue) const;
	};


#define __MAP_PL_H
#endif


