// testmult.cpp : implementation file
//

#include "stdafx.h"
#include "mdsamp.h"
#include "testmult.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTestMultiDlg dialog

CTestMultiDlg::CTestMultiDlg(CWnd* pParent /*=NULL*/)
	: CMultiDialog(CTestMultiDlg::IDD, IDC_GROUPBOX, MDN_GROUP_AUTO, pParent)
{
	AddSelection(IDD_SUB_RADIO, "Radio", "Radio Selection");
	AddSelection(IDD_SUB_EDIT, "Edit");

	m_hGrid = LoadLibrary("GRID.VBX");
	if (m_hGrid > HINSTANCE_ERROR)
		AddSelection(IDD_SUB_GRID, "VBX Grid");
	else
		m_hGrid = 0;

	m_iAfterIndex = -1;

	//{{AFX_DATA_INIT(CTestMultiDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


CTestMultiDlg::~CTestMultiDlg(void)
{
	if (m_hGrid)
		FreeLibrary(m_hGrid);
}


void CTestMultiDlg::DoDataExchange(CDataExchange* pDX)
{
	CMultiDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTestMultiDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTestMultiDlg, CMultiDialog)
	//{{AFX_MSG_MAP(CTestMultiDlg)
	ON_LBN_SELCHANGE(IDC_LIST1, OnSelChangeList1)
	ON_VBXEVENT(VBN_GOTFOCUS, IDC_GRID1, OnGotFocusGrid1)
	ON_BN_CLICKED(IDC_ADD_AFTER, OnClickedAddAfter)
	//}}AFX_MSG_MAP
	ON_MESSAGE(MDN_SELECTCHANGE, OnSubSelectChange)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestMultiDlg message handlers

BOOL CTestMultiDlg::OnInitDialog()
{
	CenterWindow(NULL);	// Center meself

	CMultiDialog::OnInitDialog();

    FillListBox((CListBox *)GetDlgItem(IDC_LIST1), 0);

	SetSelection(0);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTestMultiDlg::OnSelChangeList1()
{
	SetSelection(((CListBox *)GetDlgItem(IDC_LIST1))->GetCurSel());
}


LRESULT CTestMultiDlg::OnSubSelectChange(WPARAM wParam, LPARAM lParam)
{
	CListBox *pListBox = (CListBox *)GetDlgItem(IDC_LIST1);

	ASSERT(pListBox != NULL);

	if (LOWORD(lParam) != MDN_USER_SETSEL)
		{
		// We didn't pick this subtemplate - update the listbox accordingly
		pListBox->SetCurSel(wParam);
		}

	return 0;
}


void CTestMultiDlg::OnGotFocusGrid1(UINT, int, CWnd*, LPVOID)
{
#ifdef DEBUG
	TRACE0("CTestMultiDlg::OnGotFocusGrid1() entered\n");
#endif
}


void CTestMultiDlg::OnClickedAddAfter()
{
	if (m_iAfterIndex == -1)
		{
		GetDlgItem(IDC_ADD_AFTER)->SetWindowText("Push to remove new subdialog");
		AddSelection(IDD_SUB_AFTER);
		m_iAfterIndex = ((CListBox *)GetDlgItem(IDC_LIST1))->AddString("After");
		}
	else
		{
		DeleteSelection(IDD_SUB_AFTER);
		((CListBox *)GetDlgItem(IDC_LIST1))->DeleteString(m_iAfterIndex);
		GetDlgItem(IDC_ADD_AFTER)->SetWindowText("Push to add new subdialog");
		m_iAfterIndex = -1;
		}

	return;
}
