// --------------------------------------------------------------------------
//
//  Copyright (c) 1993-1994, Chris Shearer Cooper  CompuServe 76666,3026
//
//  Revision History
//  ----------------
//  Date        Description
//  ----------  --------------------------------------------
//	03/01/1994	Original release
//  04/29/1994	Support VBX and combobox initialization data
//				Redraw groupbox title when MDN_GROUP_AUTO set and selection changes
//				Allow dynamic adding and deleting of subdialogs
//
//  This file may be copied and distributed free of charge as long as
//  this copyright notice remains intact and any changes by other
//  authors are clearly indicated.
//
//  This code may be used in your application without any monetary
//  royalty, however payment is required in the form of feedback and
//  bug reports to the author.  Although every effort has been made
//  to make this code bug-free, if you use this code in your application
//  the author of this code takes no responsibility for any damages
//  which may occur from the operation of this code.
//
// --------------------------------------------------------------------------

#include "stdafx.h"

#include "minmax.h"
#include "multidlg.h"

#include <afxpriv.h>
#include <afxres.h>
#include <ctype.h>
#include <malloc.h>

IMPLEMENT_DYNAMIC(CMultiDialog, CDialog);

#ifdef _DEBUG
	// Define this to get debugging trace output
	// #define DEBUG
	// Memory allocation debugging stuff
	#undef THIS_FILE
	static char BASED_CODE THIS_FILE[] = __FILE__;
	#define new DEBUG_NEW
#else
	// Define this to get debugging trace output in a release version
	// #define RELEASE_DEBUG
#endif

// Define this to lock windows so screen update happens all at once
// Originally, I did this to make the screen update look nicer; it turns out
// you need this in case the main program has enabled CTL3D stuff.
#define LOCK_WINDOWS


// ---------- CSubTemplateMap ----------
//	
// Mapping between text and subtemplate controls


class CSubTemplateMap : public CObject
	{
public:
	CSubTemplateMap(LPCSTR szTemplate, LPCSTR szLabel, LPCSTR szDescription, int iFirstItem, int nItems);

	BOOL ContainsItem(int iItemIndex)
		{ return (BOOL)((iItemIndex >= m_iFirstItem) && (iItemIndex < m_iFirstItem + m_nItems)); }
	BOOL TemplateMatch(LPCSTR szTemplate);

	CString m_szTemplateName;
	unsigned short m_uTemplateID;
	CString m_szLabel;		// includes char * and 2 ints = 8 bytes
	CString m_szDescription;
	short m_iFirstItem;		// 2 bytes
	short m_nItems;			// Includes special control I add
	CMemFile m_memInit;		// Initialization data
	};


CSubTemplateMap::CSubTemplateMap(LPCSTR szTemplate, LPCSTR szLabel, LPCSTR szDescription, int iFirstItem, int nItems)
{
#ifdef DEBUG
	TRACE("CSubTemplateMap::CSubTemplateMap(%08lX, \"%s\", \"%s\", %d, %d) entered [this=%08lX]\n",
		szTemplate, szLabel, szDescription, iFirstItem, nItems, this);
#endif

	if (SELECTOROF(szTemplate))
		{
		m_szTemplateName = szTemplate;
		m_uTemplateID = 0;
		}
	else
		m_uTemplateID = OFFSETOF(szTemplate);
	m_szLabel = szLabel;
	m_szDescription = szDescription;
	m_iFirstItem = iFirstItem;
	m_nItems = nItems;
}


BOOL CSubTemplateMap::TemplateMatch(LPCSTR szTemplate)
{
	if (SELECTOROF(szTemplate))
		return (BOOL)(m_szTemplateName == szTemplate);
	else
		return (BOOL)(m_uTemplateID == OFFSETOF(szTemplate));
}


// ---------- CMultiDialog ----------


CMultiDialog::CMultiDialog(LPCSTR szBaseTemplate, UINT uIDGroupBox, WORD wFlags, CWnd *pParent)
	: CDialog(), m_sTemplate(pParent)
{
	init(szBaseTemplate, uIDGroupBox, wFlags, pParent);
	//{{AFX_DATA_INIT(CMultiDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


CMultiDialog::CMultiDialog(UINT nIDBaseTemplate, UINT uIDGroupBox, WORD wFlags, CWnd *pParent)
	: CDialog(), m_sTemplate(pParent)
{
	init(MAKEINTRESOURCE(nIDBaseTemplate), uIDGroupBox, wFlags, pParent);
}


CMultiDialog::~CMultiDialog(void)
{
	CSubTemplateMap *pMap;
	int i;
	CString szLibName;
	CWinApp *pApp = AfxGetApp();
#ifdef RELEASE_DEBUG
	char szDebug[80];
#endif

#ifdef DEBUG
	TRACE0("CMultiDialog::~CMultiDialog() entered\n");
#endif

	ASSERT(this != NULL);

	while (m_aMaps.GetSize())
		{
		pMap = (CSubTemplateMap *)m_aMaps[0];
		m_aMaps.RemoveAt(0);
		delete pMap;
		}

	m_aStatus.RemoveAll();

	if (m_hDialogTemplate)
		GlobalFree(m_hDialogTemplate);

	// Free any VBX control DLLs we loaded
	ASSERT(pApp != NULL);
	for (i = 0 ; i < m_libList.GetSize() ; i++)
		{
		szLibName = m_libList.GetAt(i);
		ASSERT(!szLibName.IsEmpty());
#ifdef RELEASE_DEBUG
		sprintf(szDebug, "   Unloading VBX control DLL \"%s\"\n", (LPCSTR)szLibName);
		OutputDebugString(szDebug);
#endif
		VERIFY(pApp->UnloadVBXFile(szLibName));
		}
}


BEGIN_MESSAGE_MAP(CMultiDialog, CDialog)
	//{{AFX_MSG_MAP(CMultiDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL CMultiDialog::init(LPCSTR szBaseTemplate, UINT uIDGroupBox, WORD wFlags, CWnd *pParent)
{
	CDialogItem *pGroupBox;
	int iGroupIndex;
	char szErrorBuf[100];

#ifdef DEBUG
	TRACE("CMultiDialog::init(%08lX, %04X, %04X:%04X) entered at %08ld\n",
		szBaseTemplate, uIDGroupBox, SELECTOROF(pParent), OFFSETOF(pParent), GetTickCount());
#endif

	ASSERT(this != NULL);

	m_wFlags = wFlags;
	m_pParentWnd = pParent;		// In CDialog class
	m_uGroupID = uIDGroupBox;

	m_pOldControlWndProc = NULL;

	// Load base template definition
	if (!m_sTemplate.load(szBaseTemplate))
		{
		if (_AFX_FP_SEG(szBaseTemplate) == 0)
			wsprintf(szErrorBuf, "CMultiDialog failure : unable to load template %04X\n", _AFX_FP_OFF(szBaseTemplate));
		else
			wsprintf(szErrorBuf, "CMultiDialog failure : unable to load template \"%s\"\n", szBaseTemplate);
		AfxMessageBox(szErrorBuf);
		return FALSE;
		}

	// Into what rectangle shall we load the subdialogs?
	iGroupIndex = m_sTemplate.find_item_index(uIDGroupBox);
	if (iGroupIndex < 0)
		{
		wsprintf(szErrorBuf, "CMultiDialog failure : group box with ID %04X not found\n", uIDGroupBox);
		AfxMessageBox(szErrorBuf);
		return FALSE;
		}
	pGroupBox = m_sTemplate.get_item(iGroupIndex);
	ASSERT(pGroupBox != NULL);
	m_rectSub = pGroupBox->get_rect();		// In dialog units
#ifdef DEBUG
	TRACE("   Group box rectangle is (%d,%d),(%d,%d)\n",
		m_rectSub.left, m_rectSub.top, m_rectSub.right, m_rectSub.bottom);
#endif

	// Now that we have the rectangle, remove the group box from the template (unless the
	// user said not to)
	if (m_wFlags & MDN_GROUP_KEEP)
		{
		// Put the subdialogs _before_ the group box because otherwise VBX
		// controls (or at least GRID.VBX) never get drawn!
		m_iInsertIndex = iGroupIndex;
		}
	else
		{
		m_sTemplate.remove_item(uIDGroupBox);
		// The index where the group box control was is now the index of the first
		// control which should come after the subtemplates (if any).
		m_iInsertIndex = iGroupIndex;
		}

	m_nMainTemplateItems = m_sTemplate.num_items();

	m_iFirstSubItem = -1;
#ifdef DEBUG
	TRACE("   m_nMainTemplateItems = %d ; m_iInsertIndex = %d\n", m_nMainTemplateItems, m_iInsertIndex);
#endif

	// No subtemplate enabled yet
	m_iFirstEnabledItem = -1;
	m_nEnabledItems = 0;
	m_iActiveSub = -1;

	// If there is initialization data for the main dialog, add it now
	AppendInitData(szBaseTemplate, m_memInit);

	return TRUE;
}


BOOL CMultiDialog::AddSelection(LPCSTR szSubTemplate, LPCSTR szText, LPCSTR szDescription)
{
	CDialogTemplate subTemplate(m_pParentWnd);
	CSize subSize;
	CRect rect;
	CSubTemplateMap *pMap;
	char szErrorBuf[100];
	CString szItemText, szLibName;
#if defined(RELEASE_DEBUG) || defined(DEBUG)
	char szDebug[100];
	char szID[20];
#endif

#if defined(RELEASE_DEBUG) || defined(DEBUG)
	sprintf(szID, "%u", OFFSETOF(szSubTemplate));
	sprintf(szDebug, "CMultiDialog::AddSelection(%s, \"%s\", \"%s\") entered at %08ld\n",
		(SELECTOROF(szSubTemplate) == 0 ? szID : szSubTemplate),
		(szText == NULL ? "NULL" : szText),
		(szDescription == NULL ? "NULL" : szDescription),
		GetTickCount());
#ifdef DEBUG
	TRACE(szDebug);
#endif
#ifdef RELEASE_DEBUG
	OutputDebugString(szDebug);
#endif
#endif

	if (!subTemplate.load(szSubTemplate))
		{
		if (_AFX_FP_SEG(szSubTemplate) == 0)
			wsprintf(szErrorBuf, "CMultiDialog::AddSelection() failure : unable to load sub template %04X\n", _AFX_FP_OFF(szSubTemplate));
		else
			wsprintf(szErrorBuf, "CMultiDialog::AddSelection() failure : unable to load sub template \"%s\"\n", szSubTemplate);
		AfxMessageBox(szErrorBuf);
		return FALSE;
		}

	// Is this template too big?
	subSize = subTemplate.get_size();
	if ( (subSize.cx > m_rectSub.Width()) || (subSize.cy > m_rectSub.Height()) )
		{
		wsprintf(szErrorBuf, "CMultiDialog::AddSelection() failure : sub dialog [%d X %d] too large for area [%d X %d]!\n",
			subSize.cx, subSize.cy, m_rectSub.Width(), m_rectSub.Height() );
		AfxMessageBox(szErrorBuf);
		return FALSE;
		}

	// Do we know the name of this subtemplate?
	if (!szText)
		szText = subTemplate.get_caption();
	if (!szDescription)
		szDescription = subTemplate.get_caption();

	// Remember text, array index, and # of items for use during OnInitDialog()
	pMap = new CSubTemplateMap(szSubTemplate, szText, szDescription, m_iInsertIndex, subTemplate.num_items() + 1);
	m_aMaps.Add(pMap);
#ifdef DEBUG
	TRACE("   Sub dialog \"%s\" : start item %d, number of items %d [map at %04X:%04X]\n",
		szText, m_iInsertIndex, subTemplate.num_items(),
		SELECTOROF(pMap), OFFSETOF(pMap));
#endif

	// If this is the first subdialog, keep track of where his first
	// control gets stored in the array.
	if (m_iFirstSubItem < 0)
		m_iFirstSubItem = m_iInsertIndex;

	// Copy controls from subtemplate into main template
	if (!CopyToMainTemplate(subTemplate))
		return FALSE;

	// Add special separator control
	AddSeparator();

	// Is there initialization data for this subtemplate?
	AppendInitData(szSubTemplate, pMap->m_memInit);

	// Is the dialog already running?
	if (m_hWnd)
		return CreateSelection(pMap);

	return TRUE;
}


BOOL CMultiDialog::CreateSelection(CSubTemplateMap *pMap)
{
	HWND hWndAfter, hChild;
	int i, iBeforeItem;
	CDialogItem *pItem;
	long lStyle;
	WNDPROC pOldControlWndProc;
	HINSTANCE hInst;
	HFONT hFont;

#ifdef DEBUG
	TRACE("CMultiDialog::CreateSelection(%08lX) entered\n", pMap);
	TRACE("   pMap->m_iFirstItem = %d; ->m_nItems = %d\n",
		pMap->m_iFirstItem, pMap->m_nItems);
	TRACE("   GetDialogBaseUnits() returns %08lX\n", GetDialogBaseUnits());
#endif

	ASSERT(m_hWnd != 0);

	// Say, what font is the dialog using?
	hFont = (HFONT)::SendMessage(m_hWnd, WM_GETFONT, 0, 0);
#ifdef DEBUG
	TRACE("   Dialog is using font %04X\n", (WORD)hFont);
	LOGFONT logFont;
	::GetObject(hFont, sizeof(LOGFONT), &logFont);
	TRACE("   logFont.lfHeight = %d; .lfWidth = %d; .lfFaceName = \"%s\"\n",
		logFont.lfHeight, logFont.lfWidth, logFont.lfFaceName);
#endif

	// What control comes before the first control in the new subdialog?
	hWndAfter = HWND_TOP;
	for (iBeforeItem = pMap->m_iFirstItem - 1 ; iBeforeItem >= 0 ; iBeforeItem--)
		{
		pItem = m_sTemplate.get_item(iBeforeItem);
		ASSERT(pItem != NULL);
		if (VerifyWindow(pItem))
			{
			// Get status value (including WS_VISIBLE and HWND) for this control
			VERIFY(m_aStatus.Lookup(pItem, lStyle));
			hWndAfter = (HWND)LOWORD(lStyle);
#ifdef DEBUG
			TRACE("   New controls come after control [%d] = window %04X\n",
				iBeforeItem, (HWND)hWndAfter);
#endif
			ASSERT(hWndAfter != 0);
			break;
			}
		}

	hInst = AfxGetInstanceHandle();
	for (i = pMap->m_iFirstItem ; i < pMap->m_iFirstItem + pMap->m_nItems ; i++)
		{
		pItem = m_sTemplate.get_item(i);
		// Item position has been corrected, and WS_VISIBLE has been cleared.
		hChild = pItem->Create(m_hWnd, hInst);
#ifdef DEBUG
		TRACE("   pItem(%08lX)->Create(%04X, %04X) returned %04X\n",
			pItem, (WORD)m_hWnd, (WORD)hInst, (WORD)hChild);
#endif
		if (!hChild)
			return FALSE;
		// Put this child in the right tab order
		if (!::SetWindowPos(hChild, hWndAfter, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE))
			return FALSE;
#ifdef DEBUG
		TRACE("   New window is using font %04X\n",
			(WORD)::SendMessage(hChild, WM_GETFONT, 0, 0));
#endif
		::SendMessage(hChild, WM_SETFONT, (WPARAM)hFont, 0);
		// Next control should come after this one in the tab order
		hWndAfter = hChild;
		// Update array with actual window handle
		VERIFY(m_aStatus.Lookup(pItem, lStyle));
		ASSERT(LOWORD(lStyle) == 0);
		lStyle |= (WORD)hChild;
#ifdef DEBUG
		TRACE("   Window handle for item [%d] (ID %04X) is %04X; style set to %08lX\n",
			i, pItem->get_id(), (WORD)hChild, lStyle);
#endif
		m_aStatus.SetAt(pItem, lStyle);
		if (HIWORD(lStyle) == 0xFFFF)
			{
			// Subclass this control (it's one of my special separator controls)
			pOldControlWndProc = (WNDPROC)GetWindowLong(hChild, GWL_WNDPROC);
			ASSERT(pOldControlWndProc != NULL);
			if (!m_pOldControlWndProc)
				m_pOldControlWndProc = pOldControlWndProc;
			else
				ASSERT(m_pOldControlWndProc == pOldControlWndProc);
			SetWindowLong(hChild, GWL_WNDPROC, (LONG)CMultiDialogControlWndProc);
#ifdef DEBUG
			TRACE0("      Control subclassed\n");
#endif
			}
		}

	// Do initialization stuff
	if (!ExecuteInitData(pMap->m_memInit))
		return FALSE;

	// Tell controls to do their own initial update stuff
	for (i = pMap->m_iFirstItem ; i < pMap->m_iFirstItem + pMap->m_nItems ; i++)
		{
		pItem = m_sTemplate.get_item(i);
		ASSERT(pItem != NULL);
		VERIFY(m_aStatus.Lookup(pItem, lStyle));
		hChild = (HWND)LOWORD(lStyle);
		ASSERT(hChild != 0);
		::SendMessage(hChild, WM_INITIALUPDATE, 0, 0);
		}

	// During SendMessageToDescendants(), VBX controls (and others, possibly)
	// create a new window and destroy the one that Windows created originally.
	// Let's update our list now.
	for (i = pMap->m_iFirstItem ; i < pMap->m_iFirstItem + pMap->m_nItems ; i++)
		{
		pItem = m_sTemplate.get_item(i);
		ASSERT(pItem != NULL);
		if (!VerifyWindow(pItem))
			{
#ifdef DEBUG
			TRACE("   VerifyWindow(item [%d] = %08lX, ID %04X) returned FALSE\n",
				i, pItem, pItem->get_id());
#endif
			return FALSE;
			}
		// What is the window for this control?
		VERIFY(m_aStatus.Lookup(pItem, lStyle));
		hChild = (HWND)LOWORD(lStyle);
		ASSERT(hChild != 0);
		// VBX controls (or at least GRID.VBX) need to be set invisible again
		::ShowWindow(hChild, SW_HIDE);
#ifdef DEBUG
		TRACE("   Hiding window [%d], ID %04X = %04X\n", i, pItem->get_id(), (WORD)hChild);
#endif
		}

	return TRUE;
}


BOOL CMultiDialog::DeleteSelection(LPCSTR szSubTemplate)
{
	int i, iMapIndex;
	CSubTemplateMap *pMap;
	CDialogItem *pItem;
	long lStyle;
	HWND hWnd;

#ifdef DEBUG
	TRACE("CMultiDialog::DeleteSelection(%08lX) entered\n", szSubTemplate);
#endif

	for (iMapIndex = 0 ; iMapIndex < m_aMaps.GetSize() ; iMapIndex++)
		{
		// Don't consider deleting the currently active subdialog
		if (iMapIndex == m_iActiveSub)
			continue;
		pMap = (CSubTemplateMap *)m_aMaps[iMapIndex];
		if (pMap->TemplateMatch(szSubTemplate))
			break;
		}
	if (iMapIndex >= m_aMaps.GetSize())
		{
#ifdef DEBUG
		TRACE0("   Unable to find map for this template!\n");
#endif
		return FALSE;
		}

#ifdef DEBUG
	TRACE("   Deleting controls in map [%d] = %08lX\n", iMapIndex, pMap);
#endif
	for (i = pMap->m_iFirstItem ; i < pMap->m_iFirstItem + pMap->m_nItems ; i++)
		{
		pItem = m_sTemplate.get_item(i);
#ifdef DEBUG
		TRACE("   Item [%d] at %08lX\n", i, pItem);
#endif
		ASSERT(pItem != NULL);
		if (VerifyWindow(pItem))
			{
			// Get status value (including WS_VISIBLE and HWND) for this control
			VERIFY(m_aStatus.Lookup(pItem, lStyle));
			hWnd = (HWND)LOWORD(lStyle);
			ASSERT(hWnd != 0);
#ifdef DEBUG
			TRACE("   Destroying window %04X\n", (WORD)hWnd);
#endif
			::DestroyWindow(hWnd);
			// Remove entry from status array
			m_aStatus.RemoveKey(pItem);
			}
		m_iInsertIndex--;
		}

	// Delete map and remove from array
	delete pMap;
	m_aMaps.RemoveAt(iMapIndex);

	// Since we won't delete the currently active subdialog, there must be at least one
	// other subdialog, so m_iFirstSubItem, m_iFirstEnabledItem, m_nEnabledItems, and
	// m_iActiveSub will remain valid

	return TRUE;
}


BOOL CMultiDialog::CopyToMainTemplate(CDialogTemplate &subTemplate)
{
	int i;
	CDialogItem *pItem, *pItemCopy;
	long lStyle;
	CRect rect;
	int iXOff, iYOff;
#ifdef RELEASE_DEBUG
	char szDebug[100];
#endif

#ifdef RELEASE_DEBUG
	OutputDebugString("CMultiDialog::CopyToMainTemplate() entered\n");
#endif

	// Where should the items be moved to?
	if (m_wFlags & MDN_CENTER_SUBS)
		{
		CSize subSize = subTemplate.get_size();
		ASSERT(subSize.cy <= m_rectSub.Height());
		ASSERT(subSize.cx <= m_rectSub.Width());
		iXOff = m_rectSub.left + (m_rectSub.Width() - subSize.cx) / 2;
		iYOff = m_rectSub.top + (m_rectSub.Height() - subSize.cy) / 2;
		}
	else
		{
		iXOff = m_rectSub.left;
		iYOff = m_rectSub.top;
		}

	// Copy items to main dialog template, making them invisible and
	// moving them to the proper location as we go.
	for (i = 0 ; i < subTemplate.num_items() ; i++)
		{
		pItem = subTemplate.get_item(i);
		ASSERT(pItem != NULL);
		lStyle = pItem->get_style();
		rect = pItem->get_rect();
#ifdef DEBUG
		TRACE("   Subtemplate item [%d] = main template item [%d]\n",
			i, m_iInsertIndex);
		TRACE("      ID %04X, style %08lX, position (%d,%d),(%d,%d)\n",
			pItem->get_id(), lStyle, rect.left, rect.top, rect.right, rect.bottom);
#endif
#ifdef RELEASE_DEBUG
		sprintf(szDebug, "   Subtemplate item [%d] = main template item [%d]\n",
			i, m_iInsertIndex);
		OutputDebugString(szDebug);
		sprintf(szDebug, "      ID %04X, style %08lX, position (%d,%d),(%d,%d)\n",
			pItem->get_id(), lStyle, rect.left, rect.top, rect.right, rect.bottom);
		OutputDebugString(szDebug);
#endif
		// Is it a VBX control?
		if (pItem->get_class() == "VBControl")
			{
			if (!LoadVBX(pItem))
				return FALSE;
			}
		rect.OffsetRect(iXOff, iYOff);
#ifdef DEBUG
		TRACE("      Setting to style %08lX, position (%d,%d),(%d,%d)\n",
			lStyle & ~WS_VISIBLE, rect.left, rect.top, rect.right, rect.bottom);
#endif
		pItem->set_rect(rect);
		pItem->set_style(lStyle & ~WS_VISIBLE);
		// Add copy of this item to the main dialog box and get a pointer to the item
		// in the main template (not in subTemplate)!
		pItemCopy = m_sTemplate.add_item(pItem, m_iInsertIndex++);
		// Store this item's visible status bit in our array.  At this point, we don't
		// know the window handle so leave it zero.
		m_aStatus.SetAt(pItemCopy, lStyle & WS_VISIBLE);
		}

	return TRUE;
}


// Special child class just so we can define IsVBXEnabled()
class CMultiDialogWinApp : public CWinApp
	{
public:
	BOOL IsVBXEnabled(void)
		{ return (BOOL)(m_lpfnCleanupVBXFiles != NULL); }
	};

BOOL CMultiDialog::LoadVBX(CDialogItem *pItem)
{
	int iIndex, iLib;
	CString szItemText, szLibName;
	CMultiDialogWinApp *pApp;
	char szError[100];
#ifdef RELEASE_DEBUG
	char szDebug[80];
#endif

#ifdef DEBUG
	TRACE("CMultiDialog::LoadVBX(%08lX) entered\n", pItem);
#endif

	pApp = (CMultiDialogWinApp *)AfxGetApp();
	ASSERT(pApp != NULL);

	// Make sure application has enabled VBX support
	if (!pApp->IsVBXEnabled())
		{
		AfxMessageBox("VBX support not enabled for this application");
		return FALSE;
		}

	// Extract VBX DLL name
	szItemText = pItem->get_text();
	iIndex = szItemText.Find(';');
	if (iIndex < 0)
		{
		// No semicolon found; we don't know how to handle this, so we don't know if there
		// is a problem or not.  Assume it's OK for now and let Windows/MFC complain if
		// there is indeed a problem ...
		return TRUE;
		}

	szItemText = szItemText.Left(iIndex);
#ifdef DEBUG
	TRACE("   VBX control requires \"%s\"\n", (LPCSTR)szItemText);
#endif

	// Is this DLL already loaded?
	for (iLib = 0 ; iLib < m_libList.GetSize() ; iLib++)
		{
		szLibName = m_libList.GetAt(iLib);
		ASSERT(!szLibName.IsEmpty());
		if (!szLibName.CompareNoCase(szItemText))
			return TRUE;		// Already loaded
		}

	// DLL not loaded yet
	if (!pApp->LoadVBXFile(szItemText))
		{
		wsprintf(szError, "Unable to load VBX control \"%s\"", (LPCSTR)szItemText);
		AfxMessageBox(szError);
		return FALSE;
		}

	// Add to our list so we know to Unload() it at the end
	m_libList.Add(szItemText);

	return TRUE;
}


// Interesting problem : if the user presses the mnemonic key for a control
// which is in an inactive subdialog, Windows finds that control and then
// searches forward through the list of child windows until it finds one that
// is active, visible, and has WS_TABSTOP style.  This means that if the
// required (inactive) subdialog comes _after_ the active subdialog,
// Windows will find the first control after all subdialogs - in most cases,
// the OK button.  If the required (inactive) subdialog comes _before_ the
// active subdialog, Windows will find the first control in the active
// subdialog and put the focus there.

// My solution : add a special control to the end of every subdialog that is
// invisible due to being BS_OWNERDRAW (and I won't draw anything), WS_VISIBLE, enabled
// and WS_TABSTOP.  This control will not be made invisible when the rest
// of the subdialog is.  This way, when he gets focus I know it's either
// because the user TABbed there (and I can take appropriate action) or
// because of the mnemonic key thing.  I can then do something clever.
void CMultiDialog::AddSeparator(void)
{
	CDialogItem *pItem, *pItemCopy;

#ifdef DEBUG
	TRACE("   Special control = main template item [%d]\n", m_iInsertIndex);
#endif

	pItem = new CDialogItem(&m_sTemplate, CLASS_BUTTON, WS_TABSTOP | BS_OWNERDRAW);
	pItem->set_position(0, 0);
	pItem->set_size(3, 3);
	pItem->set_id(IDC_MULTIDLG_SEPARATOR);

	pItemCopy = m_sTemplate.add_item(pItem, m_iInsertIndex++);
	m_aStatus.SetAt(pItemCopy, 0xFFFF0000);

	delete pItem;

	return;
}


void CMultiDialog::AppendInitData(LPCSTR szSubTemplate, CMemFile &memFile)
{
	CResource resInitData;
	void *pInitData;

#ifdef DEBUG
	TRACE("CMultiDialog::AppendInitData(%08lX, memFile) entered\n", szSubTemplate);
#endif

	if (!resInitData.find(szSubTemplate, RT_DLGINIT))
		{
#ifdef DEBUG
		TRACE0("   No RT_DLGINIT data found\n");
#endif
		return;
		}

	if (!resInitData.load())
		return;

	// By the way, a CResource object knows enough to unlock and unload himself
	// when he is destructed ...

	pInitData = resInitData.lock();
	if (!pInitData)
		return;

#ifdef DEBUG
	TRACE("   Initialization data locked at %08lX\n", pInitData);
#endif

	ASSERT(resInitData.size() <= (DWORD)UINT_MAX);
	memFile.Write(pInitData, (UINT)resInitData.size());

	return;
}


BOOL CMultiDialog::ExecuteInitData(CMemFile &memFile)
{
	BOOL bSuccess;
	UINT uID, uMessage;
	DWORD lLen;
	unsigned char *pData;

#ifdef DEBUG
	TRACE0("CMultiDialog::ExecuteInitData(memFile) entered\n");
	TRACE("   memFile is %ld bytes long\n", memFile.GetLength());
#endif

	if (memFile.GetLength() == 0)
		return TRUE;		// No init data

	// Data is of the form : ID (2 bytes), message (2 bytes),
	// data length (4 bytes), data, [ID, message, len, data], 0 (1 byte)
	memFile.SeekToBegin();
	bSuccess = TRUE;

	for (;;)
		{
		// Resource size is rounded up, so we don't necessarily run into the
		// end of the memfile just because we hit the end of the actual resource
		// data.  It does appear, though, that the padding after the end of
		// the actual resource data is zeroes.  For this reason, don't worry
		// too much about hitting EOF while reading uID, uMessage, or lLen, just
		// assume we're reading padding anyway.
		if ( (memFile.Read(&uID, sizeof(UINT)) != sizeof(UINT))
		  || (memFile.Read(&uMessage, sizeof(UINT)) != sizeof(UINT))
		  || (memFile.Read(&lLen, sizeof(DWORD)) != sizeof(DWORD)) )
			{
#ifdef DEBUG
			TRACE("   Error reading ID, message, or length\n");
#endif
			break;
			}
		if (!uID)
			{
#ifdef DEBUG
			TRACE("   ID=0 encountered\n");
#endif
			break;
			}
		if ( (!lLen) || (lLen >= UINT_MAX) )
			{
#ifdef DEBUG
			TRACE("  Invalid length (%ld) encountered\n", lLen);
#endif
			bSuccess = FALSE;
			break;
			}

		// Allocate space and copy init data over
		pData = new unsigned char[lLen];
		if (memFile.Read(pData, (UINT)lLen) != (UINT)lLen)
			{
			bSuccess = FALSE;
			delete [] pData;
			break;
			}

#ifdef DEBUG
		TRACE("   Sending %04X to ID %04X (%ld bytes)\n", uMessage, uID, lLen);
		TRACE("      Data at %08lX (%ld decimal) = %02X %02X %02X %02X ... %02X %02X\n",
			pData, pData, pData[0], pData[1], pData[2], pData[3],
			pData[lLen - 2], pData[lLen - 1]);
#endif
#ifdef _DEBUG
		// For AddStrings, the count must exactly delimit the
		// string, including the NULL termination.  This check
		// will not catch all mal-formed ADDSTRINGs, but will
		// catch some.
		if ( (uMessage == LB_ADDSTRING) || (uMessage == CB_ADDSTRING) )
			ASSERT(pData[lLen - 1] == 0);
#endif

		// List/Combobox returns -1 for error, as does
		// the VBX Form File initialization

		if (SendDlgItemMessage(uID, uMessage, 0, (LONG)pData) == -1)
			{
#ifdef DEBUG
			TRACE0("   SendDlgItemMessage() returned -1!\n");
#endif
			bSuccess = FALSE;
			}
		delete [] pData;
		}

	return bSuccess;
}


BOOL CMultiDialog::AddDlgItem(HWND hWnd, int iWhichSubTemplate)
{
	CSubTemplateMap *pMap;
	int iIndex, i;
	CDialogItem *pItem;
#ifdef RELEASE_DEBUG
	char szDebug[80];
#endif

#ifdef DEBUG
	TRACE("CMultiDialog::AddDlgItem(%04X, %d) entered\n", (WORD)hWnd, iWhichSubTemplate);
#endif
#ifdef RELEASE_DEBUG
	sprintf(szDebug, "CMultiDialog::AddDlgItem(%04X, %d) entered\n", (WORD)hWnd, iWhichSubTemplate);
	OutputDebugString(szDebug);
#endif

	ASSERT(hWnd != 0);

	// If the user has an HWND to give us, this means the CMultiDialog must be up and running!
	ASSERT(m_hWnd != 0);

	if ( (iWhichSubTemplate < 0) || (iWhichSubTemplate >= m_aMaps.GetSize()) )
		return FALSE;

	// Create a temporary CDialogItem object for the new item
	long lStyle = ::GetWindowLong(hWnd, GWL_STYLE);
	UINT uID = ::GetWindowWord(hWnd, GWW_ID);
	char szClass[80];
	::GetClassName(hWnd, szClass, sizeof(szClass));
	CDialogItem sItem(&m_sTemplate, szClass, lStyle);

	// Where shall we insert this new item?  At end of the template, but
	// before the special control that I add
	pMap = (CSubTemplateMap *)m_aMaps[iWhichSubTemplate];
	ASSERT(pMap != NULL);
	iIndex = pMap->m_iFirstItem + pMap->m_nItems - 1;
	ASSERT(iIndex >= m_nMainTemplateItems);
	ASSERT(iIndex <= m_iInsertIndex);

	// Insert item into template
#ifdef DEBUG
	TRACE("   Inserting new item (ID %04X) into template at index [%d]\n", uID, iIndex);
#endif
#ifdef RELEASE_DEBUG
	sprintf(szDebug, "   Inserting new item (ID %04X) into template at index [%d]\n", uID, iIndex);
	OutputDebugString(szDebug);
#endif
	sItem.set_id(uID);
	pItem = m_sTemplate.add_item(&sItem, iIndex);
	pMap->m_nItems++;
	m_aStatus.SetAt(pItem, (lStyle & WS_VISIBLE) | (WORD)hWnd);

	// Update all index pointers as needed
	if (pMap->m_iFirstItem == m_iFirstEnabledItem)
		m_nEnabledItems++;
	else
		{
		// Item should be invisible, it's not in the active subtemplate!
		::ShowWindow(hWnd, SW_HIDE);
		}
	for (i = 0 ; i < m_aMaps.GetSize() ; i++)
		{
		pMap = (CSubTemplateMap *)m_aMaps[i];
		if (pMap->m_iFirstItem >= iIndex)
			pMap->m_iFirstItem++;
		}
	m_iInsertIndex++;
	if (m_iFirstEnabledItem >= iIndex)		// New item is before the enabled sub
		m_iFirstEnabledItem++;

	return TRUE;
}


int CMultiDialog::DoModal()
{
#ifdef DEBUG
	TRACE0("CMultiDialog::DoModal() entered\n");
#endif

	// Have we not yet constructed the template?
	if ( (!m_hDialogTemplate) && (!ConstructTemplate()) )
		return -1;
#ifdef DEBUG
	TRACE0("   Template constructed successfully!\n");
#endif

	m_iFirstEnabledItem = -1;
	m_nEnabledItems = 0;
	m_iActiveSub = -1;

	return CDialog::DoModal();
}


BOOL CMultiDialog::UpdateData(BOOL bSaveAndValidate)
{
	BOOL bRet;

#ifdef DEBUG
	TRACE("CMultiDialog::UpdateData(%d) entered\n", bSaveAndValidate);
#endif

	bRet = CDialog::UpdateData(bSaveAndValidate);
#ifdef DEBUG
	TRACE("   CDialog::UpdateData(%d) returned %d\n", bSaveAndValidate, bRet);
#endif

	VerifyFocus();

	return bRet;
}


BOOL CMultiDialog::VerifyFocus(void)
{
	HWND hFocus;
	unsigned int uID;
	int iIndex;
	int i;
#ifdef DEBUG
	char szTitle[80];
	HWND hChild, hParent;
#endif

#ifdef DEBUG
	TRACE0("CMultiDialog::VerifyFocus() entered\n");
#endif

	// Where is the focus now?
	hFocus = ::GetFocus();
	uID = ::GetWindowWord(hFocus, GWW_ID);
#ifdef DEBUG
	TRACE("   ::GetFocus() returns handle %04X, ID %04X\n", (WORD)hFocus, uID);
#endif

	// Look through the template for this item
	iIndex = m_sTemplate.find_item_index(uID);
#ifdef DEBUG
	TRACE("   m_sTemplate.find_item_index(%04X) returned %d\n", uID, iIndex);
#endif

	// Decide where in the template it is - do we have to switch subtemplates?
	if (iIndex < 0)
		{
#ifdef DEBUG
		TRACE0("   Item is not in this template at all!\n");
		TRACE("   ::GetWindow(%04X, GW_CHILD) returned %04X\n",
			(WORD)hFocus, (WORD)::GetWindow(hFocus, GW_CHILD));
		TRACE("   ::GetWindow(%04X, GW_OWNER) returned %04X\n",
			(WORD)hFocus, (WORD)::GetWindow(hFocus, GW_OWNER));
		hChild = hFocus;
		while (hChild)
			{
			::GetWindowText(hChild, szTitle, sizeof(szTitle));
			TRACE("   GetWindowText(%04X) returned \"%s\"\n", (WORD)hChild, szTitle);
			hParent = ::GetParent(hChild);
			TRACE("   ::GetParent(%04X) returned %04X\n", (WORD)hChild, (WORD)hParent);
			hChild = hParent;
			}
#endif
		}
	else if (IsInMainDialog(iIndex))
		{
#ifdef DEBUG
		TRACE0("   Item is in main template\n");
#endif
		}
	else if (IsInActiveSubDialog(iIndex))
		{
#ifdef DEBUG
		TRACE("   Item is in enabled subtemplate [%d,%d]\n",
			m_iFirstEnabledItem, m_iFirstEnabledItem + m_nEnabledItems - 1);
#endif
		}
	else
		{
		// Must enable this subtemplate, but which one is it?
		i = MapIndex(iIndex);
		if (i >= 0)
			return SetSelection(i, MDN_UPDATEDATA_FAIL);
		}

	return TRUE;
}


BOOL CMultiDialog::ConstructTemplate(void)
{
	HGLOBAL hData;

#ifdef DEBUG
	TRACE("CMultiDialog::ConstructTemplate() entered at %08ld\n", GetTickCount());
#endif

	hData = m_sTemplate.generate();
	if (!hData)
		{
		AfxMessageBox("CMultiDialog error : unable to generate template!\n");
		return FALSE;
		}

	// CDialog::InitModalIndirect() always returns TRUE
	VERIFY(CDialog::InitModalIndirect(hData));

	return TRUE;
}


BOOL CMultiDialog::FillListBox(CListBox *pListBox, int iSelectIndex)
{
	CString szText;
	int i, iAddIndex;
	CSubTemplateMap *pMap;

#ifdef DEBUG
	TRACE("CMultiDialog::FillListBox(%04X:%04X, %d) entered at %08ld\n",
		SELECTOROF(pListBox), OFFSETOF(pListBox), iSelectIndex, GetTickCount());
#endif

	ASSERT(pListBox != NULL);

	// Add items to listbox
	for (i = 0 ; i < m_aMaps.GetSize() ; i++)
		{
		pMap = (CSubTemplateMap *)m_aMaps[i];
		iAddIndex = pListBox->AddString((LPCSTR)pMap->m_szLabel);
		pListBox->SetItemData(iAddIndex, (DWORD)i);
		}

	if (iSelectIndex >= 0)
		pListBox->SetCurSel(iSelectIndex);

	return TRUE;
}


BOOL CMultiDialog::ShowDlgItem(int nID, int nCmdShow)
{
	int iIndex;
	HWND hControl;
	long lStyle;
	const CDialogItem *pItem;

#ifdef DEBUG
	TRACE("CMultiDialog::ShowDlgItem(%d, %d) entered\n", nID, nCmdShow);
#endif

	// Look through the template for this item
	iIndex = m_sTemplate.find_item_index(nID);
#ifdef DEBUG
	TRACE("   m_sTemplate.find_item_index(%04X) returned %d\n", nID, iIndex);
#endif

	// Decide where in the template it is
	if (iIndex < 0)
		{
#ifdef DEBUG
		TRACE0("   Item is not in this template at all!\n");
#endif
		return FALSE;
		}

	if (IsInMainDialog(iIndex))
		{
		hControl = ::GetDlgItem(m_hWnd, nID);
		ASSERT(hControl != 0);
#ifdef DEBUG
		TRACE("   Item is in main template (hWnd=%04X)\n", hControl);
#endif
		return ::ShowWindow(hControl, nCmdShow);
		}

	// If the item isn't in the main dialog, it must be in a subdialog!
	pItem = m_sTemplate.get_item(iIndex);
	ASSERT(pItem != NULL);

	// Update the WS_VISIBLE flag in the map without modifying the window handle
	// in the low word
	VERIFY(m_aStatus.Lookup(pItem, lStyle));
	if (nCmdShow == SW_HIDE)
		lStyle &= ~WS_VISIBLE;
	else
		lStyle |= WS_VISIBLE;
	m_aStatus.SetAt(pItem, lStyle);

	if (IsInActiveSubDialog(iIndex))
		{
		hControl = (HWND)LOWORD(lStyle);
#ifdef DEBUG
		TRACE("   Item is in enabled subtemplate [%d,%d]\n",
			m_iFirstEnabledItem, m_iFirstEnabledItem + m_nEnabledItems - 1);
#endif
		return ::ShowWindow(hControl, nCmdShow);
		}

#ifdef DEBUG
	TRACE0("   Item is in disabled subtemplate\n");
#endif

	return TRUE;
}


BOOL CMultiDialog::SetSelection(LPCSTR szText)
{
	int i;
	CSubTemplateMap *pMap;

#ifdef DEBUG
	TRACE("CMultiDialog::SetSelection(\"%s\") entered\n", szText);
#endif

	for (i = 0 ; i < m_aMaps.GetSize() ; i++)
		{
		pMap = (CSubTemplateMap *)m_aMaps[i];
		if (pMap->m_szLabel == szText)
			return SetSelection(i);
		}

	return FALSE;
}


BOOL CMultiDialog::SetSelection(int iWhich, int iReason)
{
	CSubTemplateMap *pMap;
	int i;
	CDialogItem *pItem;
	CRect rect, rInvalid;
	long lStyle;
	HWND hWnd;
#ifdef RELEASE_DEBUG
	char szDebug[100];
#endif

#ifdef DEBUG
	TRACE("CMultiDialog::SetSelection(%d, %04X) entered\n",
		iWhich, iReason);
#endif

	// Can't call SetSelection until the dialog box is running
	if (!m_hWnd)
		{
		AfxMessageBox("CMultiDialog::SetSelection() failure : dialog not executing yet!\n");
		return FALSE;
		}

	if ( (iWhich < 0) || (iWhich >= m_aMaps.GetSize()) )
		return FALSE;

	pMap = (CSubTemplateMap *)m_aMaps[iWhich];
	ASSERT(pMap != NULL);

	if ( (pMap->m_iFirstItem == m_iFirstEnabledItem) && (pMap->m_nItems == m_nEnabledItems) )
		return TRUE;

#ifdef LOCK_WINDOWS
	// Wait and do all window updates at once
	VERIFY(LockWindowUpdate());
	// Calculate rectangle to invalidate
	rInvalid.SetRect(INT_MAX, INT_MAX, INT_MIN, INT_MIN);
#endif

	// Hide the current subdialog
	if (m_nEnabledItems > 0)
		{
		// The last control in any map is my special control which should not be hidden
		for (i = m_iFirstEnabledItem ; i < m_iFirstEnabledItem + m_nEnabledItems - 1 ; i++)
			{
			pItem = m_sTemplate.get_item(i);
#ifdef DEBUG
			TRACE("   Item [%d] = %04X:%04X\n", i, SELECTOROF(pItem), OFFSETOF(pItem));
#endif
			ASSERT(pItem != NULL);
			if (VerifyWindow(pItem))
				{
				// Get status value (including WS_VISIBLE and HWND) for this control
				VERIFY(m_aStatus.Lookup(pItem, lStyle));
				hWnd = (HWND)LOWORD(lStyle);
				ASSERT(hWnd != 0);
#ifdef LOCK_WINDOWS
				// Get control's location in dialog client coords
				::GetWindowRect(hWnd, &rect);
				ScreenToClient(&rect);
#ifdef DEBUG
				TRACE("   Hiding control %04X (hWnd=%04X) at (%d,%d),(%d,%d)\n",
					pItem->get_id(), (WORD)hWnd,
					rect.left, rect.top, rect.right, rect.bottom);
#endif
#ifdef RELEASE_DEBUG
				sprintf(szDebug, "   Hiding control %04X (hWnd=%04X) at (%d,%d),(%d,%d)\n",
					pItem->get_id(), hWnd,
					rect.left, rect.top, rect.right, rect.bottom);
				OutputDebugString(szDebug);
#endif
				if (rInvalid.left == INT_MAX)
					rInvalid = rect;
				else
					rInvalid |= rect;
#endif
				::ShowWindow(hWnd, SW_HIDE);
				// I called GetWindowLong(hWnd, GWL_STYLE) here and the WS_VISIBLE bit has
				// been cleared by Windows
				}
			}
		}

	// The last control in any map is my special control which is never hidden
	// so we don't need to worry about making it visible.
	for (i = pMap->m_iFirstItem ; i < pMap->m_iFirstItem + pMap->m_nItems - 1 ; i++)
		{
		pItem = m_sTemplate.get_item(i);
#ifdef DEBUG
		TRACE("   Item [%d] = %04X:%04X\n", i, SELECTOROF(pItem), OFFSETOF(pItem));
#endif
		ASSERT(pItem != NULL);
		if (VerifyWindow(pItem))
			{
			// Get status value (including WS_VISIBLE and HWND) for this control
			VERIFY(m_aStatus.Lookup(pItem, lStyle));
			hWnd = (HWND)LOWORD(lStyle);
			ASSERT(hWnd != 0);
			// Get control rectangle in dialog client units
			::GetWindowRect(hWnd, &rect);
			ScreenToClient(&rect);
#ifdef DEBUG
			TRACE("   Setting control ID=%04X (hWnd=%04X) at (%d,%d),(%d,%d) to %08lX\n",
				pItem->get_id(), (WORD)hWnd, rect.left, rect.top, rect.right, rect.bottom, lStyle);
#endif
#ifdef RELEASE_DEBUG
			sprintf(szDebug, "   Setting control ID=%04X (hWnd=%04X) at (%d,%d),(%d,%d) to %08lX\n",
				pItem->get_id(), (WORD)hWnd, rect.left, rect.top, rect.right, rect.bottom, lStyle);
			OutputDebugString(szDebug);
#endif
			if (lStyle & WS_VISIBLE)
				{
				::ShowWindow(hWnd, SW_SHOW);
#ifdef LOCK_WINDOWS
				if (rInvalid.left == INT_MAX)
					rInvalid = rect;
				else
					rInvalid |= rect;
#endif
				// I called GetWindowLong(hWnd, GWL_STYLE) here and the WS_VISIBLE bit
				// has been set by Windows
				}
			}
		}

	m_iFirstEnabledItem = pMap->m_iFirstItem;
	m_nEnabledItems = pMap->m_nItems;
	m_iActiveSub = iWhich;

	if (m_wFlags & (MDN_GROUP_AUTO & ~MDN_GROUP_KEEP))
		{
		CWnd *pGroup = GetDlgItem(m_uGroupID);
		ASSERT(pGroup != NULL);
		ASSERT(pMap != NULL);
#ifdef DEBUG
		TRACE("   Setting group box (ID %04X, @%08lX) text to pMap(%08lX) description \"%s\"\n",
			m_uGroupID, pGroup, pMap, (LPCSTR)pMap->m_szDescription);
#endif
		pGroup->SetWindowText(pMap->m_szDescription);
		// Get control rectangle in dialog client units
		pGroup->GetWindowRect(&rect);
		ScreenToClient(&rect);
#ifdef LOCK_WINDOWS
		if (rInvalid.left == INT_MAX)
			rInvalid = rect;
		else
			rInvalid |= rect;
#endif
		}

#ifdef LOCK_WINDOWS
	// OK, update everything!
	VERIFY(::LockWindowUpdate(NULL));
#ifdef DEBUG
	GetClientRect(&rect);
	TRACE("   Dialog client rectangle : (%d,%d),(%d,%d)\n",
		rect.left, rect.top, rect.right, rect.bottom);
#endif
#ifdef RELEASE_DEBUG
	GetClientRect(&rect);
	sprintf(szDebug, "   Dialog client rectangle : (%d,%d),(%d,%d)\n",
		rect.left, rect.top, rect.right, rect.bottom);
	OutputDebugString(szDebug);
#endif
	if (rInvalid.left != INT_MAX)
		{
		// Just in case CTL3D makes controls larger...
		rInvalid.InflateRect(2, 2);
		InvalidateRect(&rInvalid, TRUE);
#ifdef DEBUG
		TRACE("   Invalidated rectangle : (%d,%d),(%d,%d)\n",
			rInvalid.left, rInvalid.top, rInvalid.right, rInvalid.bottom);
#endif
#ifdef RELEASE_DEBUG
		sprintf(szDebug, "   Invalidated rectangle : (%d,%d),(%d,%d)\n",
			rInvalid.left, rInvalid.top, rInvalid.right, rInvalid.bottom);
		OutputDebugString(szDebug);
#endif
		}
#endif	// LOCK_WINDOWS

	// Send message to dialog to tell him what happened
	SendMessage(MDN_SELECTCHANGE, iWhich, MAKELPARAM(iReason, 0));

#ifdef DEBUG
	TRACE("   Message MDN_SELECTCHANGE (%04X, %08lX) sent; SetSelection() complete\n",
		iWhich, MAKELPARAM(iReason, 0));
#endif

	return TRUE;
}


// This function is (unfortunately) necessary because apparently some VBX controls
// (GRID.VBX is one example) like to delete the window originally given to them
// and create a new one - so the window handle we stored during OnInitDialog
// is no longer valid.
BOOL CMultiDialog::VerifyWindow(CDialogItem *pItem)
{
	long lStyle;
	HWND hWnd, hParent;
	WORD wID;
#ifdef RELEASE_DEBUG
	char szDebug[80];
#endif

#ifdef DEBUG
	TRACE("CMultiDialog::VerifyWindow(%08lX) entered\n", pItem);
#endif

	VERIFY(m_aStatus.Lookup(pItem, lStyle));
	hWnd = (HWND)LOWORD(lStyle);
	ASSERT(hWnd != 0);

	// Is the HWND even valid?
	if (IsWindow(hWnd))
		{
		// Yes, HWND is valid.  Is the parent of this HWND the dialog box?
		hParent = ::GetParent(hWnd);
		if (hParent == m_hWnd)
			{
			// Yes, parent of this HWND is the dialog box.  What is his ID?
			wID = ::GetWindowWord(hWnd, GWW_ID);
			if (wID == pItem->get_id())
				return TRUE;
#ifdef DEBUG
			else
				TRACE("   Window %04X ID (%04X) != pItem->get_id() (%04X)!\n",
					(WORD)hWnd, wID, pItem->get_id());
#endif
			}
#ifdef DEBUG
		else
			TRACE("   Parent (%04X) of hWnd (%04X) != m_hWnd (%04X)!\n",
				hParent, hWnd, m_hWnd);
#endif
		}
#ifdef DEBUG
	else
		TRACE("   hWnd (%04X) is not valid!\n", (WORD)hWnd);
#endif

	// OK, so now we know the window is not right anymore.  Can we find the right one?
	hWnd = ::GetDlgItem(m_hWnd, pItem->get_id());
#ifdef DEBUG
	TRACE("   GetDlgItem(%04X, %04X) returned %04X\n",
		(WORD)m_hWnd, pItem->get_id(), (WORD)hWnd);
#endif
#ifdef RELEASE_DEBUG
	sprintf(szDebug,"VerifyWindow() : GetDlgItem(%04X, %04X) returned %04X\n",
		(WORD)m_hWnd, pItem->get_id(), (WORD)hWnd);
	OutputDebugString(szDebug);
#endif

	if (hWnd)
		{
		lStyle = (lStyle & 0xFFFF0000L) | (WORD)hWnd;
#ifdef DEBUG
		TRACE("   Item status updated to %08lX\n", lStyle);
#endif
		m_aStatus.SetAt(pItem, lStyle);
		return TRUE;
		}

#ifdef RELEASE_DEBUG
	sprintf(szDebug, "VerifyWindow : GetDlgItem(%04X, %04X) returned 0!\n",
		(WORD)m_hWnd, pItem->get_id());
	OutputDebugString(szDebug);
#endif

	return FALSE;
}


int CMultiDialog::MapIndex(int iItemIndex)
{
	int i;
	CSubTemplateMap *pMap;

#ifdef DEBUG
	TRACE("CMultiDialog::MapIndex(%d) entered\n", iItemIndex);
#endif

	for (i = 0 ; i < m_aMaps.GetSize() ; i++)
		{
		pMap = (CSubTemplateMap *)m_aMaps[i];
#ifdef DEBUG
		TRACE("   Subtemplate [%d] \"%s\" = items [%d,%d]\n",
			i, (LPCSTR)pMap->m_szLabel, pMap->m_iFirstItem, pMap->m_iFirstItem + pMap->m_nItems - 1);
#endif
		if (pMap->ContainsItem(iItemIndex))
			return i;
		}

	return -1;
}


int CMultiDialog::HWndToItemIndex(HWND hWnd)
{
	int i;
	const CDialogItem *pItem;
	long lStyle;

#ifdef DEBUG
	TRACE("CMultiDialog::HWndToItemIndex(%04X) entered\n", (WORD)hWnd);
#endif

	for (i = m_iFirstSubItem ; i < m_iInsertIndex ; i++)
		{
		pItem = m_sTemplate.get_item(i);
		ASSERT(pItem != NULL);
		VERIFY(m_aStatus.Lookup(pItem, lStyle));
		if (LOWORD(lStyle) == (WORD)hWnd)
			return i;
		}

	return -1;
}


void CMultiDialog::DDX_Radio(CDataExchange *pDX, int nIDC, int &value)
{
	HWND hWndCtrl;
	int iButton;
	CDialogItem *pItem;
	CString szClass;
	long lStyle;
	int iItemIndex, iMapIndex;
	CSubTemplateMap *pMap;

	// Find this item in the template definition and if it's not in a subdialog,
	// let the standard function have it.
	iItemIndex = m_sTemplate.find_item_index(nIDC);
	if ( (iItemIndex < 0) || (IsInMainDialog(iItemIndex)) )
		{
		::DDX_Radio(pDX, nIDC, value);
		return;
		}

	// Which subtemplate is the item in?
	iMapIndex = MapIndex(iItemIndex);
	ASSERT(iMapIndex >= 0);
	pMap = (CSubTemplateMap *)m_aMaps[iMapIndex];
	ASSERT(pMap != NULL);

	hWndCtrl = pDX->PrepareCtrl(nIDC);

	ASSERT(::GetWindowLong(hWndCtrl, GWL_STYLE) & WS_GROUP);
	ASSERT((::GetWindowLong(hWndCtrl, GWL_STYLE) & 0xf)
			== BS_AUTORADIOBUTTON);

	if (pDX->m_bSaveAndValidate)
		value = -1;         // value if none found

	// walk all children in group
	iButton = 0;
	for (;;)
		{
		if (::SendMessage(hWndCtrl, WM_GETDLGCODE, 0, 0L) & DLGC_RADIOBUTTON)
			{
			// control in group is a radio button
			if (pDX->m_bSaveAndValidate)
				{
				if (::SendMessage(hWndCtrl, BM_GETCHECK, 0, 0L) != 0)
					{
					ASSERT(value == -1);    // only set once
					value = iButton;
					}
				}
			else
				{
				// select button
				::SendMessage(hWndCtrl, BM_SETCHECK, (iButton == value), 0L);
				}
			iButton++;
			}
		else
			{
			TRACE0("Warning: skipping non-radio button in group\n");
			}
		// Get next control in this subdialog (if any)
		if (++iItemIndex >= pMap->m_iFirstItem + pMap->m_nItems)
			break;
		pItem = m_sTemplate.get_item(iItemIndex);
		ASSERT(pItem != NULL);
		// Find handle of this item
		VERIFY(m_aStatus.Lookup(pItem, lStyle));
		hWndCtrl = (HWND)LOWORD(lStyle);
		ASSERT(hWndCtrl != 0);
		// If the control has WS_GROUP set, we're done!
		lStyle = ::GetWindowLong(hWndCtrl, GWL_STYLE);
		if (lStyle & WS_GROUP)
			break;
		}

	return;
}


// Get text or description of the given subdialog.  If iWhich is -1 (the
// default) returns information for the currently active subdialog.
LPCSTR CMultiDialog::GetSelectionText(int iWhich) const
{
	CSubTemplateMap *pMap;

	if ( (iWhich < 0) || (iWhich >= m_aMaps.GetSize()) )
		iWhich = m_iActiveSub;

	pMap = (CSubTemplateMap *)m_aMaps[iWhich];
	ASSERT(pMap != NULL);
	return (LPCSTR)pMap->m_szLabel;
}


LPCSTR CMultiDialog::GetSelectionDescription(int iWhich) const
{
	CSubTemplateMap *pMap;

	if ( (iWhich < 0) || (iWhich >= m_aMaps.GetSize()) )
		iWhich = m_iActiveSub;

	pMap = (CSubTemplateMap *)m_aMaps[iWhich];
	ASSERT(pMap != NULL);
	return (LPCSTR)pMap->m_szDescription;
}


BOOL CMultiDialog::OnInitDialog()
{
	HWND hChild;
	int i;
	CDialogItem *pItem;
	long lStyle;
	WNDPROC pOldControlWndProc;
#ifdef RELEASE_DEBUG
	char szDebug[100];
#endif

#ifdef DEBUG
	TRACE("CMultiDialog::OnInitDialog() entered [m_hWnd=%04X]\n", (WORD)m_hWnd);
#endif

	// Loop over all child windows.  Using GetWindow() to step through the child windows
	// gives them back in the same order in which we specified them in the template.
	// However, check just in case the user somehow managed to create an extra window
	// or two before we get here ...
	hChild = ::GetWindow(m_hWnd, GW_CHILD);
	i = 0;
	while (hChild)
		{
		pItem = m_sTemplate.get_item(i);
		if (!pItem)
			break;
		while ( (hChild) && (pItem->get_id() != ::GetWindowWord(hChild, GWW_ID)) )
			hChild = ::GetWindow(hChild, GW_HWNDNEXT);
		if (!hChild)
			break;
		// At this point, hChild is the handle for the current pItem.
		if (!IsInMainDialog(i))
			{
			// Only controls in subdialogs (not in the main dialog) have entries
			// in the status array.
			// Store window handle in the status array
			VERIFY(m_aStatus.Lookup(pItem, lStyle));
			ASSERT(LOWORD(lStyle) == 0);
			lStyle |= (WORD)hChild;
#ifdef DEBUG
			TRACE("   Window handle for item [%d] (ID %04X) is %04X; style set to %08lX\n",
				i, pItem->get_id(), (WORD)hChild, lStyle);
#endif
#ifdef RELEASE_DEBUG
			sprintf(szDebug, "   Window handle for item [%d] (ID %04X) is %04X; style set to %08lX\n",
				i, pItem->get_id(), (WORD)hChild, lStyle);
			OutputDebugString(szDebug);
#endif
			m_aStatus.SetAt(pItem, lStyle);
			if (HIWORD(lStyle) == 0xFFFF)
				{
				// Subclass this control (it's one of my special separator controls)
				pOldControlWndProc = (WNDPROC)GetWindowLong(hChild, GWL_WNDPROC);
				ASSERT(pOldControlWndProc != NULL);
				if (!m_pOldControlWndProc)
					m_pOldControlWndProc = pOldControlWndProc;
				else
					ASSERT(m_pOldControlWndProc == pOldControlWndProc);
				SetWindowLong(hChild, GWL_WNDPROC, (LONG)CMultiDialogControlWndProc);
#ifdef DEBUG
				TRACE0("      Control subclassed\n");
#endif
				}
			}
		// Move to the next child window and the next pItem
		hChild = ::GetWindow(hChild, GW_HWNDNEXT);
		i++;
		}

	// Code here copied from CDialog::OnInitDialog()

	// initialize VBX controls etc
	if (!ExecuteDlgInit())
		{
#ifdef RELEASE_DEBUG
		OutputDebugString("   ExecuteDlgInit() failed!\n");
#endif
		return FALSE;
		}

	if (!UpdateData(FALSE))
		{
		TRACE0("Warning: UpdateData failed during dialog init\n");
		EndDialog(IDABORT);
		return FALSE;
		}

	CWnd* pHelpButton = GetDlgItem(ID_HELP);
	if (pHelpButton != NULL)
		{
		// help is enabled if the app has a handler for ID_HELP
		AFX_CMDHANDLERINFO info;
		BOOL bHelp;
		bHelp = AfxGetApp()->OnCmdMsg(ID_HELP, CN_COMMAND, NULL, &info);
		pHelpButton->ShowWindow(bHelp ? SW_SHOW : SW_HIDE);
		}

	return TRUE;  // return TRUE  unless you set the focus to a control
}


BOOL CMultiDialog::ExecuteDlgInit(void)
{
	int i;
	CDialogItem *pItem;
	long lStyle;
	HWND hWnd;
	CSubTemplateMap *pMap;

#ifdef DEBUG
	TRACE0("CMultiDialog::ExecuteDlgInit() entered\n");
#endif

	// Execute any initialization data we've got floating around
	if (!ExecuteInitData(m_memInit))	// Main dialog first
		return FALSE;
	for (i = 0 ; i < m_aMaps.GetSize() ; i++)
		{
		pMap = (CSubTemplateMap *)m_aMaps[i];
		ASSERT(pMap != NULL);
#ifdef DEBUG
		TRACE("   Executing init data for pMap=%08lX\n", pMap);
#endif
		if (!ExecuteInitData(pMap->m_memInit))
			return FALSE;
		}

	// Send update message to all controls after all other siblings loaded
	SendMessageToDescendants(WM_INITIALUPDATE, 0, 0, FALSE);
#ifdef DEBUG
	TRACE0("   WM_INITIALUPDATE sent to all descendants\n");
#endif

	// During SendMessageToDescendants(), VBX controls (and others, possibly)
	// create a new window and destroy the one that Windows created originally.
	// Let's update our list now.
	if (m_iFirstSubItem < 0)
		return TRUE;		// No subtemplates
	for (i = m_iFirstSubItem ; i < m_iInsertIndex ; i++)
		{
		pItem = m_sTemplate.get_item(i);
		ASSERT(pItem != NULL);
		if (!VerifyWindow(pItem))
			{
#ifdef DEBUG
			TRACE("   VerifyWindow(item [%d] = %08lX, ID %04X) returned FALSE\n",
				i, pItem, pItem->get_id());
#endif
			return FALSE;
			}
		// What is the window for this control?
		VERIFY(m_aStatus.Lookup(pItem, lStyle));
		hWnd = (HWND)LOWORD(lStyle);
		ASSERT(hWnd != 0);
		// VBX controls (or at least GRID.VBX) need to be set invisible again
		::ShowWindow(hWnd, SW_HIDE);
#ifdef DEBUG
		TRACE("   Hiding window [%d], ID %04X = %04X\n", i, pItem->get_id(), (WORD)hWnd);
#endif
		}

	return TRUE;
}


void CMultiDialog::OnOK()
{
	if (!UpdateData(TRUE))
		{
		TRACE0("UpdateData failed during dialog termination\n");
		// the UpdateData routine will set focus to correct item
		return;
		}

	EndDialog(IDOK);

	return;
}


LRESULT CMultiDialog::SpecialControlMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	BOOL bShifted;
	int iItemIndex, iMapIndex;
	int i;
	CSubTemplateMap *pMap;
	const CDialogItem *pItem;
	long lStyle;
	LRESULT lResult;
	enum { eTabPressed, eShiftTabPressed, eAltPressed,
			eTabPressedSequential, eShiftTabPressedSequential, eOther } eReason;
	HWND hControl = 0;

	if ( (uMsg == WM_DRAWITEM) || (uMsg == WM_ERASEBKGND) )
		return TRUE;

	// All other messages just get sent straight on through
	ASSERT(m_pOldControlWndProc != NULL);
	lResult = m_pOldControlWndProc(hWnd, uMsg, wParam, lParam);

	if (uMsg != WM_SETFOCUS)
		return lResult;

#ifdef DEBUG
	TRACE("CMultiDialog::SpecialControlMessage(%04X, WM_SETFOCUS, %04X, %08lX) entered\n",
		(WORD)hWnd, wParam, lParam);
#endif

	// Which item in the template is this?  Must be a separator control in a subdialog,
	// otherwise we wouldn't be here ...
	iItemIndex = HWndToItemIndex(hWnd);
	ASSERT(iItemIndex >= 0);
	iMapIndex = MapIndex(iItemIndex);
	ASSERT(iMapIndex >= 0);
	pMap = (CSubTemplateMap *)m_aMaps[iMapIndex];
	ASSERT(pMap != NULL);
#ifdef DEBUG
	TRACE("   Item [%d] in subdialog [%d] (map @%08lX)\n", iItemIndex, iMapIndex, pMap);
#endif

	// Why do we have the focus?
	if (GetKeyState(VK_TAB) & 0x8000)
		{
		bShifted = (BOOL)(GetKeyState(VK_SHIFT) & 0x8000);
#ifdef DEBUG
		TRACE("   Tab key pressed (bShifted=%d)\n", bShifted);
#endif
		if (bShifted)
			eReason = (m_wFlags & MDN_SEQUENTIAL_SUBS) ? eShiftTabPressedSequential : eShiftTabPressed;
		else
			eReason = (m_wFlags & MDN_SEQUENTIAL_SUBS) ? eTabPressedSequential : eTabPressed;
		}
	else if (GetKeyState(VK_MENU) & 0x8000)
		eReason = eAltPressed;
	else
		eReason = eOther;

	// Now that we know why we're here, what should we do about it?
	switch (eReason)
		{
		case eTabPressed :
			// If user pressed Tab and ended up here, he must have been
			// in subdialog [iMapIndex] or in the main dialog, before
			// all subdialogs..
			// Which control should get the focus?
			if (IsInActiveSubDialog(iItemIndex))
				{
				// We were in the active subdialog and the user pressed TAB
				// and no more controls were found in this subdialog which
				// are tabbable.
				ASSERT(iMapIndex == m_iActiveSub);
				hControl = FindTabbablePostWindow(TRUE);
				if (!hControl)
					hControl = FindTabbablePreWindow(TRUE);
				if (!hControl)
					hControl = FindTabbableWindow(iMapIndex, TRUE);
				}
			else
				{
				// We were in the main dialog, before all subdialogs.
				hControl = FindTabbableWindow(m_iActiveSub, TRUE);
				if (!hControl)
					hControl = FindTabbablePostWindow(TRUE);
				if (!hControl)
					hControl = FindTabbablePreWindow(TRUE);
				}
			break;
		case eShiftTabPressed :
			// If user pressed shift-Tab and ended up here, he must have been
			// either in a subdialog following [iMapIndex] or else [iMapIndex]
			// is the last subdialog and he had been in the main dialog after
			// all subdialogs.
			// Which control should get the focus?
			if (iMapIndex >= m_iActiveSub)
				{
				// The focus is currently in an inactive subdialog which
				// comes after the active subdialog, or at the very end of
				// the active subdalog.  This means that we
				// came here from a control in the main dialog after all
				// subdialogs.
				hControl = FindTabbableWindow(m_iActiveSub, FALSE);
				if (!hControl)
					hControl = FindTabbablePreWindow(FALSE);
				if (!hControl)
					hControl = FindTabbablePostWindow(FALSE);
				}
			else
				{
				// The focus is currently in an inactive subdialog which
				// comes before the active subdialog.  This means we came
				// here from the active subdialog.
				hControl = FindTabbablePreWindow(FALSE);
				if (!hControl)
					hControl = FindTabbablePostWindow(FALSE);
				if (!hControl)
					hControl = FindTabbableWindow(m_iActiveSub, FALSE);
				}
			break;
		case eTabPressedSequential :
			// If user pressed Tab and ended up here, he must have been
			// in subdialog [iMapIndex] or in the main dialog, before
			// all subdialogs..
			// Which control should get the focus?
			// Since the caller specified MDN_SEQUENTIAL_SUBS, we should activate
			// subdialog [iMapIndex + 1] if one exists.
			for (i = iMapIndex + 1 ; i < m_aMaps.GetSize() ; i++)
				{
				hControl = FindTabbableWindow(i, TRUE);
				if (hControl)
					{
					// SetSelection() detects the case where subdialog [i]
					// is active and does nothing
					SetSelection(i, MDN_TAB_ACTIVATE);
					break;
					}
				}
			if (!hControl)
				hControl = FindTabbablePostWindow(TRUE);
			if (!hControl)
				hControl = FindTabbablePreWindow(TRUE);
			if (!hControl)
				{
				for (i = 0 ; i <= iMapIndex ; i++)
					{
					hControl = FindTabbableWindow(i, TRUE);
					if (hControl)
						{
						// SetSelection() detects the case where subdialog [i]
						// is active and does nothing
						SetSelection(i, MDN_TAB_ACTIVATE);
						break;
						}
					}
				}
			break;
		case eShiftTabPressedSequential :
			// If user pressed shift-Tab and ended up here, he must have been
			// either in a subdialog following [iMapIndex] or else [iMapIndex]
			// is the last subdialog and he had been in the main dialog after
			// all subdialogs.
			// Which control should get the focus?
			// Since the caller specified MDN_SEQUENTIAL_SUBS, we should
			// activate subdialog [iMapIndex] so we can pick a control in it to
			// get the focus.
			for (i = iMapIndex ; i >= 0 ; i--)
				{
				hControl = FindTabbableWindow(i, FALSE);
				if (hControl)
					{
					// SetSelection() detects the case where subdialog [i]
					// is active and does nothing
					SetSelection(i, MDN_TAB_ACTIVATE);
					break;
					}
				}
			if (!hControl)
				hControl = FindTabbablePreWindow(FALSE);
			if (!hControl)
				hControl = FindTabbablePostWindow(FALSE);
			if (!hControl)
				{
				for (i = m_aMaps.GetSize() - 1 ; i > iMapIndex ; i--)
					{
					hControl = FindTabbableWindow(i, FALSE);
					if (hControl)
						{
						// SetSelection() detects the case where subdialog [i]
						// is active and does nothing
						SetSelection(i, MDN_TAB_ACTIVATE);
						break;
						}
					}
				}
			break;
		case eAltPressed :
			// Alt key being pressed!  Figure out if one of the controls in subdialog
			// [iMapIndex] has a matching mnemonic.
			for (i = pMap->m_iFirstItem ; i < pMap->m_iFirstItem + pMap->m_nItems ; i++)
				{
				pItem = m_sTemplate.get_item(i);
				ASSERT(pItem != NULL);
				VERIFY(m_aStatus.Lookup(pItem, lStyle));
				if (IsMnemonicPressed((HWND)LOWORD(lStyle)))
					{
#ifdef DEBUG
					TRACE("   Mnemonic for item [%d] (hWnd %04X) being pressed!\n",
						i, (HWND)LOWORD(lStyle));
#endif
					SetSelection(iMapIndex, MDN_MNEMONIC_SWITCH);
					hControl = FindTabbableWindow(iMapIndex, TRUE, i);
					break;
					}
				}
			break;
		case eOther :
			// So ... the Tab key isn't being pressed (shifted or un) and neither is the Alt
			// key.  I have no idea how we got here, so let's just give the focus back to whomever
			// we got it from.
#ifdef DEBUG
			TRACE("   Neither Tab nor Alt pressed; returning focus to window %04X\n", wParam);
#endif
			break;
		}

	if (!hControl)
		hControl = (HWND)wParam;
#ifdef DEBUG
	TRACE("   Setting focus to %04X\n", hControl);
#endif
	::SetFocus(hControl);

	return lResult;
}


// Notice that this function will return successful (a window handle) if the
// specified control is not currently visible but will be when its container
// subdialog is activated.
HWND CMultiDialog::IsItemTabbable(int iItemIndex)
{
	CDialogItem *pItem;
	HWND hControl;
	long lStyle, lStatus;

#ifdef DEBUG
	TRACE("CMultiDialog::IsItemTabbable(%d) entered\n", iItemIndex);
#endif

	pItem = m_sTemplate.get_item(iItemIndex);
	if (IsInMainDialog(iItemIndex))
		{
		hControl = ::GetDlgItem(m_hWnd, pItem->get_id());
		ASSERT(hControl != 0);
		lStyle = ::GetWindowLong(hControl, GWL_STYLE);
		lStatus = lStyle;
		}
	else
		{
		VerifyWindow(pItem);
		VERIFY(m_aStatus.Lookup(pItem, lStatus));
		hControl = (HWND)LOWORD(lStatus);
		ASSERT(hControl != 0);
		lStyle = ::GetWindowLong(hControl, GWL_STYLE);
		}

#ifdef DEBUG
	TRACE("   Window style %08lX; status %08lX\n", lStyle, lStatus);
#endif

	if ( (!(lStyle & WS_DISABLED)) && (lStatus & WS_VISIBLE) && (lStyle & WS_TABSTOP) )
		return hControl;
	return 0;
}


HWND CMultiDialog::FindTabbableWindow(int iMapIndex, BOOL bFirst, int iStartIndex)
{
	CSubTemplateMap *pMap;
	int i;
	HWND hControl = 0;

#ifdef DEBUG
	TRACE("CMultiDialog::FindTabbableWindow(%d, %d, %d) entered\n",
		iMapIndex, bFirst, iStartIndex);
#endif

	pMap = (CSubTemplateMap *)m_aMaps[iMapIndex];
	ASSERT(pMap != NULL);

	if (bFirst)
		{
		if (iStartIndex < 0)
			iStartIndex = pMap->m_iFirstItem;
		for (i = iStartIndex ; i < pMap->m_iFirstItem + pMap->m_nItems - 1 ; i++)
			{
			if ( (hControl = IsItemTabbable(i)) != 0)
				break;
			}
		}
	else
		{
		if (iStartIndex < 0)
			iStartIndex = pMap->m_iFirstItem + pMap->m_nItems - 2;
		for (i = iStartIndex ; i >= pMap->m_iFirstItem ; i--)
			{
			if ( (hControl = IsItemTabbable(i)) != 0)
				break;
			}
		}

	return hControl;
}


HWND CMultiDialog::FindTabbablePreWindow(BOOL bFirst)
{
	int i;
	HWND hControl = 0;

	if (bFirst)
		{
		for (i = 0 ; i < m_iFirstSubItem ; i++)
			{
			if ( (hControl = IsItemTabbable(i)) != 0)
				break;
			}
		}
	else
		{
		for (i = m_iFirstSubItem - 1 ; i >= 0 ; i--)
			{
			if ( (hControl = IsItemTabbable(i)) != 0)
				break;
			}
		}

	return hControl;
}


HWND CMultiDialog::FindTabbablePostWindow(BOOL bFirst)
{
	int i;
	HWND hControl = 0;

	if (bFirst)
		{
		for (i = m_iInsertIndex ; i < m_sTemplate.num_items() ; i++)
			{
			if ( (hControl = IsItemTabbable(i)) != 0)
				break;
			}
		}
	else
		{
		for (i = m_sTemplate.num_items() - 1 ; i >= m_iInsertIndex ; i--)
			{
			if ( (hControl = IsItemTabbable(i)) != 0)
				break;
			}
		}

	return hControl;
}


LRESULT CALLBACK __export CMultiDialogControlWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	CMultiDialog *pDialog;
	HWND hParent;

	// The parent of this control must be a CMultiDialog.  Get him.
	hParent = GetParent(hWnd);
	ASSERT(hParent != 0);
	pDialog = (CMultiDialog *)CWnd::FromHandle(hParent);
	ASSERT(pDialog != NULL);
	ASSERT(pDialog->IsKindOf(RUNTIME_CLASS(CMultiDialog)));

	return pDialog->SpecialControlMessage(hWnd, uMsg, wParam, lParam);
}


BOOL CMultiDialog::IsMnemonicPressed(HWND hWnd)
{
	char szBuf[80];
	char *pAnd;
	char cMnemonic;
	UINT uKeyCode, uKeyState;

#ifdef DEBUG
	TRACE("CMultiDialog::IsMnemonicPressed(%04X) entered\n", (WORD)hWnd);
#endif

	ASSERT(hWnd != 0);

	// Get the mnemonic for this window
	::GetWindowText(hWnd, szBuf, sizeof(szBuf));
	pAnd = strchr(szBuf, '&');
	if (!pAnd)
		return FALSE;
	cMnemonic = *(pAnd + 1);
	if (!cMnemonic)
		return FALSE;

#ifdef DEBUG
	TRACE("   Mnemonic is \'%c\'\n", cMnemonic);
#endif

	uKeyCode = VkKeyScan(cMnemonic);		// Low-order byte contains virtual key code
	uKeyState = GetKeyState(LOBYTE(uKeyCode));
#ifdef DEBUG
	TRACE("   GetKeyState(%02X) returned %04X\n", LOBYTE(uKeyCode), uKeyState);
#endif

	return (BOOL)(uKeyState & 0x8000);
}



