// ------------------------------------------------------------------------
//
//  Collection of min() and max() functions for use in C++ files.  Doesn't
//  hurt if included in C files.
//
// ------------------------------------------------------------------------

#ifndef __MINMAX_H


#ifndef __cplusplus

#include <stdlib.h>

#else // __cplusplus

#ifdef __BORLANDC__

#ifdef min(a,b)
  #undef min(a,b)
#endif

#ifdef max(a,b)
  #undef max(a,b)
#endif

template <class T> inline T min(T t1, T t2)
{
  return (t1 < t2) ? t1 : t2;
}


template <class T> inline T max(T t1, T t2)
{
  return (t1 > t2) ? t1 : t2;
}


template <class T> inline void swap(T t1, T t2)
{
  T tt;

  tt = t1;
  t1 = t2;
  t2 = tt;

  return;
}


#else  // __BORLANDC__

#ifdef min
  #undef min
#endif

#ifdef max
  #undef max
#endif

inline int max(int a, int b) { if (a > b) return a; else return b; }
inline unsigned int max(unsigned int a, unsigned int b) { if (a > b) return a; else return b; }
inline long max(long a, long b) { if (a > b) return a; else return b; }
inline DWORD max(DWORD a, DWORD b) { if (a > b) return a; else return b; }
inline double max(double a, double b) { if (a > b) return a; else return b; }

inline int min(int a, int b) { if (a < b) return a; else return b; }
inline unsigned int min(unsigned int a, unsigned int b) { if (a < b) return a; else return b; }
inline WORD min(WORD a, WORD b) { if (a < b) return a; else return b; }
inline unsigned long min(unsigned long a, unsigned long b) { if (a < b) return a; else return b; }
inline long min(long a, long b) { if (a < b) return a; else return b; }
inline double min(double a, double b) { if (a < b) return a; else return b; }

inline void swap(int &a, int &b) { int t; t = a; a = b; b = t; return; }

#endif   // __BORLANDC__

#endif  // __cplusplus


#define __MINMAX_H
#endif

