#include "stdafx.h"

#include "map_pl.h"

IMPLEMENT_DYNAMIC(CMapPtrToLong, CMapPtrToPtr)

#ifdef _DEBUG
	// Define this to get debugging trace output
	// #define DEBUG
	#undef THIS_FILE
	static char BASED_CODE THIS_FILE[] = __FILE__;
	#define new DEBUG_NEW
#endif


void CMapPtrToLong::GetNextAssoc(POSITION& pos, void *& rKey, long &rValue) const
{
	// Copy code from CMapPtrToPtr::GetNextAssoc()
	ASSERT_VALID(this);
	ASSERT(m_pHashTable != NULL);  // never call on empty map

	CAssoc *pAssocRet = (CAssoc*)pos;
	ASSERT(pAssocRet != NULL);

	if (pAssocRet == (CAssoc *)MAP_PL_BEFORE_START_POSITION)
		{
		// find the first association
		for (UINT nBucket = 0; nBucket < m_nHashTableSize; nBucket++)
			if ((pAssocRet = m_pHashTable[nBucket]) != NULL)
				break;
		ASSERT(pAssocRet != NULL);  // must find something
		}

	// find next association
	ASSERT(AfxIsValidAddress(pAssocRet, sizeof(CAssoc)));
	CAssoc *pAssocNext;
	if ((pAssocNext = pAssocRet->pNext) == NULL)
		{
		// go to next bucket
		for (UINT nBucket = pAssocRet->nHashValue + 1;
		  nBucket < m_nHashTableSize; nBucket++)
			if ((pAssocNext = m_pHashTable[nBucket]) != NULL)
				break;
		}

	pos = (POSITION)pAssocNext;

	// fill in return data
	rKey = pAssocRet->key;
	rValue = (long)pAssocRet->value;

	return;
}
