// ------------------------------------------------------------------------
//
//   Create a class that handles resources
//
// ------------------------------------------------------------------------

#ifndef __CRESRCE_H

#include <limits.h>


class CResource
	{
public:

	// ---------- Creation and deletion ----------

	__export CResource(void);
	__export ~CResource(void);

	// If bUnlock and bFree are TRUE (the default), the resource is unlock()ed and free()ed
	// as necessary.  If bUnlock is FALSE, the resource is not unlock()ed.  If bFree is
	// FALSE, the resource is not free()ed.  This is mainly useful when possesion of the
	// global handle has passed to another process (as when calling SetMetaFileBits() on
	// a METAFILE resource).
	void __export clear(BOOL bUnlock = TRUE, BOOL bFree = TRUE);

	// To get access to a resource, perform these three operations in
	// sequence.  Unlike the corresponding Windows functions, find(), load(),
	// and lock() work as expected for stringtable resources.  I don't know
	// what they do for icon and cursor resources - the documentation for the
	// FindResource() function makes it sound like you have to have special
	// cases for string, icon, and cursor resources - and I _have_ a special
	// case for string resources but not the other two (yet).

	BOOL __export find(HINSTANCE xhInstance, LPCSTR szName, LPCSTR szType);
	BOOL find(HINSTANCE xhInstance, int iNumber, LPCSTR szType)
		{ return find(xhInstance, MAKEINTRESOURCE(iNumber), szType); }
	BOOL __export find(LPCSTR szName, LPCSTR szType);
	BOOL find(int iNumber, LPCSTR szType)
		{ return find(MAKEINTRESOURCE(iNumber), szType); }
	BOOL __export load(void);
	void * __export lock(void);

	// When done with a resource, perform these operations in sequence
	// (or just call the destructor)
	BOOL __export unlock(int nMaxUnlocks = 1);
	BOOL __export free(void);
	BOOL unload(void) { return free(); }    // Synonym for free()

	// find() must be called before size(), access(), or alloc().
	DWORD __export size(void);
	int __export access(void);
	HGLOBAL __export alloc(DWORD lSize = 0);

	BOOL is_found(void)
		{ return (BOOL)hResource; }
	BOOL is_loaded(void)
		{ return (BOOL)m_hData; }
	int num_locks(void)
		{ return m_nLocks; }
	WORD type_of(void)
		{ return wType; }
	HGLOBAL handle(void)
		{ return m_hData; }

	// Return a handle to the global data and detach the CResource object from it without
	// freeing or unlocking!
	HGLOBAL __export Detach(void);

	static RSRCHDLRPROC __export set_handler(HINSTANCE hInstance, LPCSTR szType, RSRCHDLRPROC lpProc);

protected:

	HINSTANCE hInstance;
	HRSRC hResource;
	HGLOBAL m_hData;

	WORD wType;       // If a predefined type; otherwise 0
	UINT uStringNum;  // If RT_STRING, number of string resource

	int m_nLocks;
	};


#define __CRESRCE_H
#endif

