#include "stdafx.h"

#include "cresrce.h"

#ifdef _DEBUG
	// Define this to get debugging trace output
	// #define DEBUG
	#undef THIS_FILE
	static char BASED_CODE THIS_FILE[] = __FILE__;
	#define new DEBUG_NEW
#endif
                               

CResource::CResource(void)
{
	clear(FALSE, FALSE);
}


CResource::~CResource(void)
{
	clear(TRUE, TRUE);
}


void CResource::clear(BOOL bUnlock, BOOL bFree)
{
#ifdef DEBUG
	TRACE("CResource::clear(%d, %d) entered\n", bUnlock, bFree);
#endif

	if (bUnlock)
		unlock(SHRT_MAX);

	if (bFree)
		free();

	hResource = 0;
	hInstance = 0;
	m_hData = 0;
	wType = 0;
	uStringNum = 0;
	m_nLocks = 0;

	return;
}


BOOL CResource::find(LPCSTR szName, LPCSTR szType)
{
	HINSTANCE xhInstance;

#ifndef _AFXDLL
	xhInstance = AfxGetResourceHandle();
#else
	xhInstance = AfxFindResourceHandle(szName, szType);
#endif

	return find(xhInstance, szName, szType);
}


BOOL CResource::find(HINSTANCE xhInstance, LPCSTR szName, LPCSTR szType)
{
	clear(TRUE, TRUE);

	hInstance = xhInstance;

	if (SELECTOROF(szType))
		wType = 0;
	else
		wType = OFFSETOF(szType);

	if (szType == RT_STRING)
		{
		// Strings in STRINGTABLEs are always stored by number only, and are
		// stored in groups of 16 with the number of the group being equal to
		// the base number of the group divided by 16, plus 1.
		if (SELECTOROF(szName))
			return FALSE;
		uStringNum = OFFSETOF(szName);
		hResource = FindResource(hInstance, MAKEINTRESOURCE((uStringNum >> 4) + 1), RT_STRING);
		}
	else
		{
		hResource = FindResource(hInstance, szName, szType);
		}

	return (BOOL)hResource;
}


BOOL CResource::load(void)
{
#ifdef DEBUG
	TRACE0("CResource:load()\n");
#endif

	if ( (!hInstance) || (!hResource) )
		return FALSE;

	if (m_hData)
		return TRUE;

	m_hData = LoadResource(hInstance, hResource);
#ifdef DEBUG
	TRACE("   LoadResource(%04X, %04X) returned %04X\n",
		(WORD)hInstance, (WORD)hResource, (WORD)m_hData);
#endif

	return (BOOL)m_hData;
}


void *CResource::lock(void)
{
	void *pData;
	int nOffset;

#ifdef DEBUG
	TRACE0("CResource::lock() entered\n");
#endif

	if (!m_hData)
		return NULL;

	pData = LockResource(m_hData);
#ifdef DEBUG
	TRACE("   LockResource(%04X) returned %04X:%04X\n",
		(WORD)m_hData, SELECTOROF(pData), OFFSETOF(pData));
#endif
	if (pData)
		m_nLocks++;


	if (wType == OFFSETOF(RT_STRING))
		{
		// Move through string segment to the one we want
		nOffset = uStringNum & 0x000F;
		while (nOffset--)
			pData = (char *)pData + (unsigned int)(*((unsigned char *)pData)) + 1;
		// If string has length, move to first byte
		if (*(char *)pData)
			pData = (char *)pData + 1;
		}

	return pData;
}


BOOL CResource::unlock(int nMaxUnlocks)
{
#ifdef DEBUG
	TRACE("CResource::unlock(%d) entered [m_hData=%04X, m_nLocks=%d]\n",
		nMaxUnlocks, (WORD)m_hData, m_nLocks);
#endif

	if (!m_hData)
		return FALSE;

// Interesting thing : in WINDOWS.H one sees the following line :
// #define UnlockResource(h) GlobalUnlock(h)
// but GlobalFlags(m_hData) for a resource always returns 0!

	while ( (m_nLocks > 0) && (nMaxUnlocks > 0) )
		{
		UnlockResource(m_hData);
		m_nLocks--;
		nMaxUnlocks--;
		}

	return TRUE;
}


BOOL CResource::free(void)
{
#ifdef DEBUG
	TRACE("CResource::free() entered [m_hData=%04X]\n", (WORD)m_hData);
#endif

	if ( (!m_hData) || (m_nLocks) )
		return FALSE;

	FreeResource(m_hData);
	m_hData = 0;

	return TRUE;
}


DWORD CResource::size(void)
{
  DWORD lSize;
  unsigned char *pData;
  int nOffset;

#ifdef DEBUG
  TRACE("CResource::size() entered\n");
#endif

  lSize = 0;

  if ( (hInstance) && (hResource) )
    {
    if (wType != OFFSETOF(RT_STRING))
      {
      lSize = SizeofResource(hInstance, hResource);
#ifdef DEBUG
      TRACE("   Size = %ld\n", lSize);
#endif
      }
    else
      {
      // It's a string resource!
      if (load())
        {
        pData = (unsigned char *)LockResource(m_hData);
        if (pData)
          {
          // Move through string segment to the one we want
          nOffset = uStringNum & 0x000F;
          while (nOffset--)
            pData += (unsigned int)*pData + 1;
          lSize = (DWORD)*pData;
#ifdef DEBUG
          TRACE("   String size = %ld\n", lSize);
#endif
          UnlockResource(m_hData);
          }
        unload();
        }
      }
    }

  return lSize;
}


int CResource::access(void)
{
	if ( (!hInstance) || (!hResource) )
		return 0;

	return AccessResource(hInstance, hResource);
}


HGLOBAL CResource::alloc(DWORD lSize)
{
	if ( (!hInstance) || (!hResource) )
		return 0;

	return AllocResource(hInstance, hResource, lSize);
}


RSRCHDLRPROC CResource::set_handler(HINSTANCE hInstance, LPCSTR szType, RSRCHDLRPROC lpProc)
{
	return SetResourceHandler(hInstance, szType, lpProc);
}


HGLOBAL CResource::Detach(void)
{
	HGLOBAL hData = m_hData;

#ifdef DEBUG
	TRACE("CResource::Detach() entered [m_hData=%04X]\n", (WORD)m_hData);
#endif

	clear(FALSE, FALSE);

	return hData;
}

