/*                  
     Use Linear Shooting Algorithm (Algorithm 11.1, p.562) to solve the
     boundary value problem (Exercise Set 11.1, p.565, #3(c)):
     
     y" = -3 * y' + 2 * y + 2 * x + 3, 0 <= x <= 1, 
                                   where y(0) = 2, y(1) = 1, h = 0.1 

 */

#include <stdio.h>       //has prototypes for standard i/o functions
#include <stdlib.h>      //has prototype  for exit() function.
#include <math.h>        //has prototypes for exp() and sqrt()

//declare a pointer to function as a type
typedef double (*funtype)(double);

double P(double), Q(double), R(double);  //prototypes
double y(double);

const long n = 1000;     //The maximum number of intervals allowed

class UserEquation {
     protected:
          double    a, b, h;
          double    alpha, beta;
          funtype   p, q, r;  //functions
          long      N;
     public:
          UserEquation();
};

class LinearShootingMethod : UserEquation {
     public:
          LinearShootingMethod();
};

/* constructor initializes the initializes the initial values */
UserEquation::UserEquation()
{
     a = 0.0;
     b = 1.0;
     h = 0.1;
     N = (b - a) / h + 1;
     if(n < N) {
          printf("Number of intervals is too big for the program!\n");
          exit(0);
     }
     alpha = 2.0;
     beta = 1.0;
     p = P;    //p(x)
     q = Q;    //q(x)
     r = R;    //r(x)
}

main()
{
     LinearShootingMethod lsm;
}

LinearShootingMethod::LinearShootingMethod()
{
     double u1[n], u2[n], v1[n], v2[n];
     double k11, k12, k21, k22, k31, k32, k41, k42;
     double kp11, kp12, kp21, kp22, kp31, kp32, kp41, kp42;
     double x;

     u1[0] = alpha;                               //Step 1.
     u2[0] = 0.;    //allocate memory
     v1[0] = 0.;    //and initialize
     v2[0] = 1.;    //these pointers

     for(int i = 0; i < N; i++) {                 //Step 2.
          x = a + h * i;                               //Step 3.
          k11 = h * u2[i];                             //Step 4.
          k12 = h * (p(x) * u2[i] + q(x) * u1[i] + r(x));
          k21 = h * (u2[i] + 0.5 * k12);
          k22 = h * (p(x + h / 2) * (u2[i] + k12 / 2) +
                     q(x + h / 2) * (u1[i] + k11 / 2) + r(x + h / 2));
          k31 = h * (u2[i] + k22 / 2.);
          k32 = h * (p(x + h / 2) * (u2[i] + k22 / 2) +
                     q(x + h / 2) * (u1[i] + k21 / 2) + r(x + h / 2));
          k41 = h * (u2[i] + k32);
          k42 = h * (p(x + h) * (u2[i] + k32) +
                     q(x + h) * (u1[i] + k31) + r(x + h));

          u1[i+1] = u1[i] + (k11 + k21 * 2.+ k31 * 2.+ k41) / 6.;
          u2[i+1] = u2[i] + (k12 + k22 * 2.+ k32 * 2.+ k42) / 6.;

          kp11 = h * v2[i];  //k'1,1
          kp12 = h * (p(x) * v2[i] + q(x) * v1[i]);
          kp21 = h * (v2[i] + kp12 / 2.);
          kp22 = h * (p(x + h / 2.) * (v2[i] + kp12 / 2.) +
                      q(x + h / 2.) * (v1[i] + kp11 / 2.));
          kp31 = h * (v2[i] + kp22 / 2);
          kp32 = h * (p(x + h / 2.) * (v2[i] + kp22 / 2.) +
                      q(x + h / 2.) * (v1[i] + kp21 / 2.));
          kp41 = h * (v2[i] + kp32);
          kp42 = h * (p(x + h) * (v2[i] + kp32) +
                      q(x + h) * (v1[i] + kp31));

          v1[i+1] = v1[i] + (kp11 + kp21 * 2.+ kp31 * 2.+ kp41) / 6.;
          v2[i+1] = v2[i] + (kp12 + kp22 * 2.+ kp32 * 2.+ kp42) / 6.;
     }
     double w10 = alpha;
     double w20 = (beta - u1[N]) / v1[N]; //Step 5.
     printf("\na = %lf, w1,0 = %lf, w2,0 = %lf\n\n", a, w10, w20);

     double W1, W2, soln;

     for(i = 1; i < N + 1; i++) {                 //Step 6.
          W1 = u1[i] + w20 * v1[i];
          W2 = u2[i] + w20 * v2[i];
          x = a + h * i;
          printf("x = %lf, W1 = %lf, W2 = %lf\n", x, W1, W2);
          printf("real solution = %lf\t", soln = y(x));
          printf("%%error = %lf%%\n", fabs((W1 - soln) * 100./ soln));
     }
     exit(0);                                     //Step 7.
}

double P(double x)
{
     return -3.0;
}

double Q(double x)
{
     return 2.0;
}

double R(double x)
{
     return 2.0 * x + 3.0;
}

//returns the true solution for comparison
double y(double x)
{
     double sqrt17 = sqrt(17.0);
     double c2 = 5. * (exp((-3. + sqrt17) / 2.) - 1.) /
                 (exp((-3.+ sqrt17) / 2.) - exp((-3.-sqrt17) / 2.));
     double c1 = 5. - c2;

     return      c1 * exp((-3. + sqrt17) / 2. * x)
               + c2 * exp((-3. - sqrt17) / 2. * x) - x - 3;
}
