/*
     Use Adams-Bashforth method (Algorithm 5.4, p.266) to solve:
     
     Exercise Set 5.6 #3(c)
     
          y' = (2/t)*y + pow(t,2) * exp(t),  0 <= t <= 1, y(0) = 1/3, h = 0.1
*/


#include <stdio.h>
#include <stdlib.h>
#include <math.h>

class UserEquation {
     protected:   //all members are declared as protected for inheritance
          double a, b, h, alpha;
          long N;
          //function f is the differential equation, g is its solution
          double f(double, double), g(double);
     public:
          UserEquation();     //constructor
          void output(double, double);
};

//Constructor of UserEquation initialize all its members
UserEquation::UserEquation()
{
     a = 1.;                       //starting value
     b = 2.;                       //stoping value
     h = 0.1;                      //step size is 0.1
     N = (long)(b - a) / h + 1;    //add 1 to make the genuine value
     alpha = 0.;                   //initial value for the solution
}

class AdamsPC : public UserEquation {
     //All the members of AdamsPC are the same as UserEquation.
  public:
     AdamsPC();
};

main()
{
     printf("Solution for y'= 2/t * y + t * t * exp(t) using the\n");
     printf("Adams fourth-order predictor-corrector algorithm:\n\n");

     AdamsPC x;     //This is all we need in the main function
}

//The constructor of AdamsPC has all the logic for solving the equation.
AdamsPC::AdamsPC()
{
     double t, w, k1, k2, k3, k4;
     double ta[4], wa[4];     //means array of t and array of w

     if(h == 0.)                                       //Step 1.
          if(N != 0)                                   
               h = (b - a) / N;
          else
               exit(0);
     ta[0] = a;          //initialize ta[0] to a
     wa[0] = alpha;      //initialize wa[0] to alpha
     output(ta[0], wa[0]);

     for(int i = 1; i < 4; i++) {                      //Step 2.

          k1 = h * f(ta[i-1], wa[i-1]);                     //Step 3.
          k2 = h * f(ta[i-1] + h / 2., wa[i-1] + k1 / 2.);
          k3 = h * f(ta[i-1] + h / 2., wa[i-1] + k2 / 2.);
          k4 = h * f(ta[i-1] + h, wa[i-1] + k3);

          wa[i] = wa[i-1] + (k1 + k2 * 2 + k3 * 2 + k4) / 6;//Step 4.
          ta[i] = a + h * i;

          output(ta[i], wa[i]);                             //Step 5.
     }
     for(i = 4; i <= N; i++) {                         //Step 6.

          t = a + h * i;                                    //Step 7.

          w = wa[3] + h * (55.* f(ta[3], wa[3]) - 59.* f(ta[2],wa[2])
               + 37. * f(ta[1], wa[1]) - 9.* f(ta[0], wa[0])) / 24.;

          w = wa[3] + h * (9. * f(t, w) + 19.* f(ta[3], wa[3])
               - 5.* f(ta[2], wa[2]) + f(ta[1], wa[1])) / 24.;

          output(t, w);                                     //Step 8.

          for(int j = 0; j < 3; j++) {                      //Step 9.
               ta[j] = ta[j+1];    //new ta[j]
               wa[j] = wa[j+1];    //new wa[j]
          }
          ta[3] = t;                                        //Step 10.
          wa[3] = w;
     }
}

//Output the t, w, real values and %error
void UserEquation::output(double t, double w)
{
     double x = g(t);

     printf("t = %9lf, w = %9lf, g(t) = %9lf, %%error = %9lf\n",
          t, w, x, (fabs(x) < 1.e-20 ? fabs(x) : fabs((x - w) * 100./ x)));
     return;
}

//This is the equation to be solved.
double UserEquation::f(double t, double w)
{
     return 2./ t * w + t * t * exp(t);
}

//This is the real solution for the problem
double UserEquation::g(double t)
{
     return t * t * (exp(t) - exp(1.));
}
