/* include: MOUSEFUN.H */

#ifndef MOUSEFUN_DEFINED

#define LBUTTON 0
#define RBUTTON 1

#define SOFT_TEXT_CURSOR 0
#define HARD_TEXT_CURSOR 1

#define ENGLISH      0
#define FRENCH       1
#define DUTCH        2
#define GERMAN       3
#define SWEDISH      4
#define FINNISH      5
#define SPANISH      6
#define PORTUGUESE   7
#define ITALIAN      8

#define MOUSE_BUS    1
#define MOUSE_SERIAL 2
#define MOUSE_INPORT 3
#define MOUSE_PS2    4
#define MOUSE_HP     5

#define IRQ_PS2  0

struct graphics_cursor
   {
   int screen_mask[16];
   int cursor_mask[16];
   int hot_spot_x;
   int hot_spot_y;
   };

void mouse_RESET(int *, int*);
void mouse_show();
void mouse_hide();
void mouse_status(int *, int *, int *, int *);
void mouse_setpos(int,int);
void mouse_press( int, int *, int *, int *, int *);
void mouse_release( int, int *, int *, int *, int *);
void mouse_sethorz( int, int);
void mouse_setvert( int, int);
void mouse_setgcurs( struct graphics_cursor far *);
void mouse_settcurs( int, int, int);
void mouse_motion( int *, int *);
void mouse_setratios( int, int);
void mouse_condoff( int, int, int, int);
void mouse_setdouble( int);
void mouse_storage( int *);
void mouse_save( char far *);
void mouse_restore( char far *);
void mouse_setsensitivity( int, int, int);
void mouse_getsensitivity(int *, int *, int *);
void mouse_setmaxrate( int);
void mouse_setpage( int);
void mouse_getpage( int *);
void mouse_setlang( int);
void mouse_getlang( int *);
void mouse_getversion( double *, int *, int *);

static struct graphics_cursor far gcursor_default =
   {
	   /* screen mask */
   0xCFFF,
   0xC7FF,
   0xC3FF,
   0xC1FF,
   0xC0FF,
   0xC07F,
   0xC03F,
   0xC01F,
   0xC00F,
   0xC007,
   0xC07F,
   0xC43F,
   0xCC3F,
   0xFE1F,
   0xFE1F,
   0xFF1F,
	   /* cursor mask */
   0x0000,
   0x1000,
   0x1800,
   0x1C00,
   0x1E00,
   0x1F00,
   0x1F80,
   0x1FC0,
   0x1FE0,
   0x1F00,
   0x1B00,
   0x1180,
   0x0180,
   0x00C0,
   0x00C0,
   0x0000,
	   /* hot spot x,y */
   02, 00
   };

#define MOUSEFUN_DEFINED
#endif

