/* toolbox module: MOUSEFUN.C */

#include<dos.h>
#include"mousefun.h"

/* mouse_reset(...) : Resets mouse and verifies
		    : its existence.
*/

void mouse_reset(int *status, int *buttons)
{
   int m1, m2;

   _asm
      {
      xor ax, ax
      int 33h
      mov m1, ax
      mov m2, bx
      }

   *status = m1;
   *buttons = m2;
}

/* mouse_show() : Makes the mouse cursor visible.
*/

void mouse_show(void)
{
   _asm
      {
      mov ax, 1
      int 33h
      }
}
/* mouse_hide() : Hides mouse cursor.
*/

void mouse_hide(void)
{
   _asm
      {
      mov ax, 2
      int 33h
      }
}

/* mouse_status(...) : Gets status and position of mouse.
*/

void mouse_status(int *left_button, int *right_button,
		  int *horz_pos, int *vert_pos)
{
   int m2, m3, m4;

   _asm
      {
      mov ax, 3
      int 33h
      mov m2, bx
      mov m3, cx
      mov m4, dx
      }

   *left_button = m2 & 1;
   *right_button = ( m2 >> 1 ) & 1;
   *horz_pos = m3;
   *vert_pos = m4;
}

/* mouse_setpos(...) : Sets mouse cursor position.
*/

void mouse_setpos(int horizontal, int vertical)
{
   _asm
      {
      mov ax, 4
      mov cx, horizontal
      mov dx, vertical
      int 33h
      }
}

/* mouse_press(...) : Gets button press information.
*/

void mouse_press(int button, int *status, int *presses,
		 int *horz_pos, int *vert_pos)
{
   int m1, m2, m3, m4;

   _asm
      {
      mov ax, 5
      mov bx, button
      int 33h
      mov m1, ax
      mov m2, bx
      mov m3, cx
      mov m4, dx
      }

   if( button == LBUTTON)
      *status = m1 & 1;
   else
      *status = (m1 >> 1) & 1;
   *presses = m2;
   *horz_pos = m3;
   *vert_pos = m4;
}

/* mouse_release(...) : Gets button release information.
*/

void mouse_release(int button, int *status, int *releases,
		   int *horz_pos, int *vert_pos)
{
   int m1, m2, m3, m4;

   _asm
      {
      mov ax, 6
      mov bx, button
      int 33h
      mov m1, ax
      mov m2, bx
      mov m3, cx
      mov m4, dx
      }

   if(button == LBUTTON)
      *status = m1 & 1;
   else
      *status = ( m1 >> 1 ) & 1;

   *releases = m2;
   *horz_pos = m3;
   *vert_pos = m4;
}

/* mouse_sethorz(...) : Sets maximum and minimum cursor
		      : horizontal position.
*/

void mouse_sethorz( int horz_min, int horz_max)
{
   _asm
      {
      mov ax, 7
      mov cx, horz_min
      mov dx, horz_max
      int 33h
      }
}

/* mouse_setvert : Sets max. and min vertical position.
*/

void mouse_setvert( int vert_min, int vert_max)
{
   _asm
      {
      mov ax, 8
      mov cx, vert_min
      mov dx, vert_max
      int 33h
      }
}
/* mouse_setgcurs(...) : Sets shape of mouse graphic cursor.
*/

void mouse_setgcurs( struct graphics_cursor far *cursor)
{
   unsigned cursor_seg = FP_SEG( cursor );
   unsigned cursor_off = FP_OFF( cursor );
   int hotx = cursor->hot_spot_x;
   int hoty = cursor->hot_spot_y;
   _asm
      {
      mov ax, 9
      mov bx, hotx
      mov cx, hoty
      mov es, cursor_seg
      mov dx, cursor_off
      int 33h
      }
}

/* mouse_settcurs(...) : Sets text mode hard- or software cursor.
*/

void mouse_settcurs( int cursor_select, int screen_mask, int cursor_mask)
{
   _asm
      {
      mov ax, 10
      mov bx, cursor_select
      mov cx, screen_mask
      mov dx, cursor_mask
      int 33h
      }
}

/* mouse_motion(...) : Gets accumulated 'mickeys' since
		     : last call.
*/

void mouse_motion(int *horz_mickeys, int *vert_mickeys)
{
   int m3, m4;

   _asm
      {
      mov ax, 11
      int 33h
      mov m3, cx
      mov m4, dx
      }

   *horz_mickeys = m3;
   *vert_mickeys = m4;
}

/* mouse_setratios(...) : Sets the mickey/pixel ratio.
*/

void mouse_setratios( int horizontal, int vertical)
{
   _asm
      {
      mov ax, 15
      mov cx, horizontal
      mov dx, vertical
      int 33h
      }
}

/* mouse_condoff(...) : Sets region where cursor is hidden.
*/

void mouse_condoff(int x1, int y1, int x2, int y2)
{
   _asm
      {
      mov ax, 16
      mov cx, x1
      mov dx, y1
      mov si, x2
      mov di, y2
      int 33h
      }
}

/* mouse_setdouble(...) : Sets mouse double speed threshold.
*/

void mouse_setdouble( int mickeys_per_second)
{
   _asm
      {
      mov ax, 19
      mov dx, mickeys_per_second
      int 33h
      }
}

/* mouse_storage(...) : Gets number of bytes needed to save
		      : current state of mouse.
*/

void mouse_storage( int *buffer_size)
{
   int m2;

   _asm
      {
      mov ax, 21
      int 33h
      mov m2, bx
      }

   *buffer_size = m2;
}

/* mouse_save(...) : Saves current state of mouse.
*/

void mouse_save(char far *buffer)
{
   unsigned buffer_seg = FP_SEG(buffer);
   unsigned buffer_off = FP_OFF(buffer);

   _asm
      {
      mov ax, 23
      mov es, buffer_seg
      mov dx, buffer_off
      int 33h
      }
}

/* mouse_setsensitivity(...) : Sets mouse sensitivity AND double threshold.
*/

void mouse_setsensitivity( int horz, int vert, int threshold)
{
   _asm
      {
      mov ax, 26
      mov bx, horz
      mov cx, vert
      mov dx, threshold
      int 33h
      }
}

/* mouse_getsensitivity(...) : Gets mouse sensitivity and double threshold.
*/

void mouse_getsensitivity( int *horz, int *vert, int *threshold)
{
   int m2, m3, m4;

   _asm
      {
      mov ax, 27
      int 33h
      mov m2, bx
      mov m3, cx
      mov m4, dx
      }

   *horz = m2;
   *vert = m3;
   *threshold = m4;
}

/* mouse_setmaxrate(...) : WORKS WITH InPort MOUSE ONLY !!
			 : >>OMMITTED<<
*/


/* mouse_setpage(...) : Sets page where cursor appears.
*/

void mouse_setpage( int crt_page)
{
   _asm
      {
      mov ax, 29
      mov bx, crt_page
      int 33h
      }
}

/* mouse_getpage(...) : Gets page where cursor appears.
*/

void mouse_getpage( int *crt_page)
{
   int m2;

   _asm
      {
      mov ax, 30
      int 33h
      mov m2, bx
      }

   *crt_page = m2;
}

/* mouse_setlang(...) : Sets language for mouse
		      : driver messages.
*/

void mouse_setlang( int language)
{
   _asm
      {
      mov ax, 34
      mov bx, language
      int 33h
      }
}

/* mouse_getlang(...) : Gets language for mouse
		      : driver messages.
*/

void mouse_getlang( int *language)
{
   int m2;

   _asm
      {
      mov ax, 35
      int 33h
      mov m2, bx
      }

   *language = m2;
}

/* mouse_getversion(...) : Gets driver version, mouse
			 : type and interrupt request type.
*/

void mouse_getversion( double *version, int *mouse_type, int *irq_num)
{
   int m2, m3;
   int maj, min;

   _asm
      {
      mov ax, 36
      int 33h
      mov m2, bx
      mov m3, cx
      }

   maj = (m2 >> 12) * 10 + ((m2 >> 8) & 0xf);
   min = ((m2 >> 4) & 0xf) * 10 + (m2 & 0xf);
   *version = maj + min / 100.0;
   *mouse_type = m3 >> 8;
   *irq_num = m3 & 0xff;
}



