//*************************************************************
//  File name: TEXTDOC.CPP
//
//  Description:  
//      AppWizard generated implementation file for CTextDoc
//      
//      
//
//  History:    Date       Author     Comment
//              2/24/94    FJB        Created
//
// Written by Microsoft Product Support Services, Windows Developer Support
// Copyright (c) 1992 Microsoft Corporation. All rights reserved.
//*************************************************************
#include "stdafx.h"
#include "text.h"

#include "textdoc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTextDoc

IMPLEMENT_DYNCREATE(CTextDoc, CDocument)

BEGIN_MESSAGE_MAP(CTextDoc, CDocument)
    //{{AFX_MSG_MAP(CTextDoc)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTextDoc construction/destruction

CTextDoc::CTextDoc()
{

}

CTextDoc::~CTextDoc()
{
}
//*************************************************************
//
//  Class
//      CTextDoc
//
//  Member Function:
//      DeleteContents   : Deletes contents of document
//      OnOpenDocument() : Loads a text file into the document
//
//  Comments:  
//      This class offers read only access to text files.  Text 
//      data is stored in a CStringArray.  Files of up to 1000
//      lines can be viewed completely.  The serialization 
//      mechanism is not used, see OnOpenDocument for details.
//
//  History:    Date       Author     Comment
//              2/24/94    FJB        Created
//
//*************************************************************

void CTextDoc::DeleteContents()
{
    m_ary.RemoveAll();
}
            

//*************************************************************
//
//  Member function:
//      CTextDoc::OnOpenDocument
//
//  Parameters: 
//      pszPathName - points to the path of the document to be
//                    opened.
//
//  Return: (BOOL)
//      TRUE:  Document was successfully loaded.
//      FALSE: Document was successfully loaded.. NOT!
//
//  Comments:  
//      This document offers read only access to text files.  Since
//      this class doesn't deal with archives, it is necessary to
//      override OnOpenDocument instead of the usual Serialize.
//
//  History:    Date       Author     Comment
//              2/24/94    FJB        Created
//
//*************************************************************


BOOL CTextDoc::OnOpenDocument(const char* pszPathName)
{   
   const int c_cBufferSize = 200; 
   const int c_cMaxString  = 1000;  // avoid logical doc size problem
   char szBuffer[c_cBufferSize];
     
   CStdioFile f;
   CFileException fe;
   if(!f.Open(pszPathName, CFile::modeRead | CFile::typeText))
   {
      ReportSaveLoadException(pszPathName, &fe,
         FALSE, AFX_IDP_FAILED_TO_OPEN_DOC);
      return FALSE;
   }
    
   DeleteContents();
    
   TRY
   {
      BeginWaitCursor(); 
      int cString = 0;
           
      while(f.ReadString(szBuffer,c_cBufferSize)) 
      {
         int l;
         
         // CScrollView on Win16 has a logical size limit of
         // +/- 32767 units
         // Since the user will be allowed to select the font, make
         // sure the the view won't exceed this length.  To do this,
         // limit the font size to 32 logical units, and limit the
         // document to 1000 lines in length:
         // 
         // 32 * 1000 < 32767
        
         if (cString++ == c_cMaxString)
         {
            // document is too long.
            // display warning message and don't load the remainder   
            CString str;
            char szTemp[10];
            wsprintf(szTemp,"%d",c_cMaxString);             
            AfxFormatString1(str,IDS_WARN_DOC_TOOLONG,szTemp);
            AfxMessageBox (str,MB_OK | MB_ICONEXCLAMATION);                       
            break;
         }
        
         // if the line ends with a newline character, replace with
         // null terminator.  This is to prevent TabbedTextOut from
         // displaying the newline character as an ANSI symbol            
         if (szBuffer[l=lstrlen(szBuffer)-1] == '\n')
             szBuffer[l--] = '\0';  
             
         // trim off trailing blanks
         while (szBuffer[l] == ' ')
            szBuffer[l--] = '\0';
       
         // Finally, add the line to the CStringArray  
         m_ary.Add(szBuffer);
      
      } // while(f.ReadString(szBuffer,c_cBufferSize)) 
      
      f.Close();
      
   } // TRY
   CATCH_ALL(e)
   {
      f.Abort();
      DeleteContents();      
      EndWaitCursor(); 
      
      TRY
         ReportSaveLoadException(pszPathName, e,
            FALSE, AFX_IDP_FAILED_TO_OPEN_DOC);
      END_TRY
      return FALSE;
   }
   END_CATCH_ALL 
   
   EndWaitCursor();
   SetPathName(pszPathName);
   return TRUE;
}
        
        
    

/////////////////////////////////////////////////////////////////////////////
// CTextDoc serialization

void CTextDoc::Serialize(CArchive& ar)
{
    if (ar.IsStoring())
    {
    }
    else
    {
    }
}


/////////////////////////////////////////////////////////////////////////////
// CTextDoc diagnostics

#ifdef _DEBUG
void CTextDoc::AssertValid() const
{
    CDocument::AssertValid();
}

void CTextDoc::Dump(CDumpContext& dc) const
{
    CDocument::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CTextDoc commands
