//*************************************************************
//  File name: mainfrm.cpp
//
//  Description: Standard AppWizard CMDIFrameWnd implementation,
//               modified to include an OnWinIniChanged handler.
//               
//
//  History:    Date       Author     Comment
//              2/25/94    FJB        Created
//              2/25/94    FJB        Added OnWinIniChanged handler      
//
// Written by Microsoft Product Support Services, Windows Developer Support
// Copyright (c) 1994 Microsoft Corporation. All rights reserved.
//*************************************************************


#include "stdafx.h"
#include "text.h"

#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
   //{{AFX_MSG_MAP(CMainFrame)
   ON_WM_CREATE()
   ON_WM_WININICHANGE()
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize control bars

// toolbar buttons - IDs are command buttons
static UINT BASED_CODE buttons[] =
{
   // same order as in the bitmap 'toolbar.bmp'
   ID_FILE_OPEN,
      ID_SEPARATOR,
   ID_FILE_PRINT,
   ID_APP_ABOUT,
};

static UINT BASED_CODE indicators[] =
{
   ID_SEPARATOR,           // status line indicator
   ID_INDICATOR_CAPS,
   ID_INDICATOR_NUM,
   ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
   // TODO: add member initialization code here
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
   if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
      return -1;

   if (!m_wndToolBar.Create(this) ||
      !m_wndToolBar.LoadBitmap(IDR_MAINFRAME) ||
      !m_wndToolBar.SetButtons(buttons,
        sizeof(buttons)/sizeof(UINT)))
   {
      TRACE("Failed to create toolbar\n");
      return -1;      // fail to create
   }

   if (!m_wndStatusBar.Create(this) ||
      !m_wndStatusBar.SetIndicators(indicators,
        sizeof(indicators)/sizeof(UINT)))
   {
      TRACE("Failed to create status bar\n");
      return -1;      // fail to create
   }

   return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
   CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
   CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

//*************************************************************
//
//  Class
//      CMainFrame
//
//  Member Function:
//      OnWinIniChange
//
//  Purpose:   
//      This function is called after a change has been made to
//      the WIN.INI file.  SendMessageToDescendants is used to 
//      forward this notification to each of the views.  The views
//      use this information to update printer metric information
//      after the default printer changes.
//
//  Parameters:  
//      lpszSection - the section of the WIN.INI file that changed.
//
//
//  Comments:
//
//  History:    Date       Author     Comment
//              2/25/94    FJB        Created
//
//*************************************************************
void CMainFrame::OnWinIniChange(LPCSTR lpszSection)
{
   CMDIFrameWnd::OnWinIniChange(lpszSection);
   
   SendMessageToDescendants( WM_WININICHANGE, 0, (LPARAM) lpszSection, 
                             TRUE, TRUE); 
}

