//*************************************************************
//  File name: TEXTVIEW.H
//
//  Description: 
//      Definition of the CTextView class
// 
//
//  History:    Date       Author     Comment
//              2/24/94    FJB        Created, via AppWizard
//              2/24/94    FJB        Modified to work with CTextDoc
//
// Written by Microsoft Product Support Services, Windows Developer Support
// Copyright (c) 1994 Microsoft Corporation. All rights reserved.
//*************************************************************
                 
                 
//*************************************************************
//
//  Class
//      CTextView
//
//  Member Function:  
//    Construction/Destruction:
//      CTextView -            c-tor
//     ~CTextView -            d-tor
//      
//    Drawing:
//      OnIntialUpdate -       Called when view first displayed.                             
//      OnUpdate -             Called each time view is updated.
//
//      ComputeVisibleLines -  computes range of visible lines
//                             for display
//      ComputePrintableLines  computes range of visible lines
//                             on a page during printing
//
//      OnDraw -               1st OnDraw override, displays document
//      OnDraw -               2cnd OnDraw override, renders a given
//                             range of lines
//      DrawPageBreak -        Draws a page break on the display
//
//    Printing:
//      OnPreparePrinting -    See documentation for descriptions of
//      OnBeginPrinting -      Currently unimplemented
//      OnPrint                Called to print or preview a page of the
//                             document.
//      OnEndPrinting -        Currently unimplemented
//
//  Message Map:
//      OnCreate -             Called during view creation 
//      OnWinIniChange() -     Called when WIN.INI is changed. 
//
//
//  History:    Date       Author     Comment
//              2/24/94    FJB        Created
//
//*************************************************************


class CTextView : public CScrollView
{
protected: // create from serialization only
   CTextView();
   DECLARE_DYNCREATE(CTextView)

// Attributes
public:
   CTextDoc*     GetDocument();

   CViewMetrics* m_pVMetrics;
   CPageMetrics* m_pPMetrics; 
   CMargins*     m_pMargins;

// Implementation
public:
   virtual ~CTextView();   
   virtual void OnDraw(CDC* pDC);
   virtual void OnDraw(CDC* pDC, int nyPos, int nFirstLn, int nLastLn);   
   virtual void OnPrint(CDC* pDC, CPrintInfo* pPI);
   virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
   virtual void OnInitialUpdate(); // first time after construct 
   virtual void DrawPageBreak(CDC* pDC, int yPosition);
   virtual void ComputeVisibleLines(CDC const * const pDC, 
                                    int& nFirst, 
                                    int& nLast);
   virtual void ComputePrintableLines(CDC*        pDC, 
                                      CPrintInfo* pPI, 
                                      int&        nFirst, 
                                      int&        nLast);
 
#ifdef _DEBUG
   virtual void AssertValid() const;
   virtual void Dump(CDumpContext& dc) const;
#endif

protected:

   // Printing support
   virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
   virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
   virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
   
   CFont      m_fnt;
   LOGFONT    m_lf;  
   CWordArray m_aryPageBreaks;

// Generated message map functions
protected:
   //{{AFX_MSG(CTextView)
   afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
   afx_msg void OnWinIniChange(LPCSTR lpszSection);
   //}}AFX_MSG
   DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in textview.cpp
inline CTextDoc* CTextView::GetDocument()
   { return (CTextDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
