class CMainWindow : public CFrameWnd
{
public:
	CMainWindow();

	afx_msg void OnAbout();
	
	afx_msg void OnTRACE();
	afx_msg void OnDump();
	afx_msg void OnASSERT();
	afx_msg void OnVERIFY();
	afx_msg void OnIgnoreASSERT();
	afx_msg void OnGuard();
	afx_msg void OnCheckpoint();
	afx_msg void OnLeak();
	afx_msg void OnHookAlloc();
	afx_msg void OnDynDump();
	afx_msg void OnDumpClass();
	afx_msg void OnBadCast();
	afx_msg void OnIterate();

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

// CTheApp:
// See hello.cpp for the code to the InitInstance member function.
//
class CTheApp : public CWinApp
{
public:
	BOOL InitInstance();
	BOOL ExitInstance();
	CMemoryState m_FirstMemCheck;
};

/////////////////////////////////////////////////////////////////////////////

class CNoDump : public CObject
{ };

class CDump : public CNoDump
{
public:
	CDump( int i )
		{ x = i; }
	int x;
#ifdef _DEBUG
	void Dump(CDumpContext& dc) const
		{	CNoDump::Dump(dc);
			dc << "The value of x = " << x; }
#endif
};

//////////////////////////////////////////////////////////////////////////////

class CDynDump : public CObject
{
public:
	CDynDump( int i )
		{ x = i; }
	int x;
#ifdef _DEBUG
	void Dump(CDumpContext& dc) const
		{	CObject::Dump(dc);
			dc << "The value of x = " << x; }
#endif
	DECLARE_DYNAMIC(CDynDump)
};

//////////////////////////////////////////////////////////////////////////////

class CLevel1Object : public CObject
{
	DECLARE_DYNAMIC(CLevel1Object)
};

class CLevel2Object : public CLevel1Object
{
	DECLARE_DYNAMIC(CLevel2Object)
};

//////////////////////////////////////////////////////////////////////////////
	
class CFoo : public CObject
{
	DECLARE_DYNAMIC(CFoo)
};

class CBar : public CObject
{
	DECLARE_DYNAMIC(CBar)
};

//////////////////////////////////////////////////////////////////////////////

class CValidOb : public CObject
{
public:
	virtual void Print(void) { TRACE( "I'm a CValidOb\n" ); }
	DECLARE_DYNAMIC(CValidOb)
};

class CDerivedValidOb : public CValidOb
{
public:
	virtual void Print(void) { TRACE( "I'm acting like a CValidOb\n" ); }
	DECLARE_DYNAMIC(CDerivedValidOb)
};

class CNotValidOb : public CObject
{
public:
	virtual void Destory(void)
			{ TRACE( "I'm calling some dangerous code by mistake\n" ); }
	DECLARE_DYNAMIC(CNotValidOb)
};

//////////////////////////////////////////////////////////////////////////////
