// diag.cpp
#include <afxcoll.h>
#include <afxwin.h>
#include "resource.h"

#include "diag.h"

#define new DEBUG_NEW
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;

/////////////////////////////////////////////////////////////////////////////
CTheApp theApp;

/////////////////////////////////////////////////////////////////////////////

BEGIN_MESSAGE_MAP( CMainWindow, CFrameWnd )
	ON_WM_PAINT()
	ON_COMMAND( IDM_TRACE, OnTRACE )
	ON_COMMAND( IDM_DUMP, OnDump )
	ON_COMMAND( IDM_ASSERT, OnASSERT )
	ON_COMMAND( IDM_VERIFY, OnVERIFY )
	ON_COMMAND( IDM_IGNOREASSERT, OnIgnoreASSERT )
	ON_COMMAND( IDM_GUARD, OnGuard )
	ON_COMMAND( IDM_CHECKPOINT, OnCheckpoint )
	ON_COMMAND( IDM_LEAK, OnLeak )
	ON_COMMAND( IDM_HOOKALLOC, OnHookAlloc )
	ON_COMMAND( IDM_DYNDUMP, OnDynDump )
	ON_COMMAND( IDM_DUMPCLASS, OnDumpClass )
	ON_COMMAND( IDM_BADCAST, OnBadCast )
	ON_COMMAND( IDM_ITERATE, OnIterate )
	ON_COMMAND( IDM_ABOUT, OnAbout )
END_MESSAGE_MAP()


CMainWindow::CMainWindow()
{
	LoadAccelTable( "MainAccelTable" );
	Create( NULL, "Diagnostic Example Program",
		WS_OVERLAPPEDWINDOW, rectDefault, NULL, "MainMenu" );
}

void CMainWindow::OnAbout()
{
	CModalDialog about( "AboutBox", this );
	about.DoModal();
}

void CMainWindow::OnTRACE()
{
	TRACE( "Sample TRACE output with formating:  %d == 0x%x\n", 34, 34);
}
void CMainWindow::OnDump()
{
	CNoDump aNoDump;
	CDump aDump(39);
	TRACE( "Dumping a CNoDump which does not override Dump\n");
	afxDump << aNoDump;
	TRACE( "\nDumping a CDump which does override Dump\n");
	afxDump << aDump;
	TRACE( "\n" );
}

void CMainWindow::OnASSERT()
{
	ASSERT(FALSE);
}

void CMainWindow::OnVERIFY()
{
	VERIFY(FALSE);
}

extern int afxIgnoreAssertCount;
void CMainWindow::OnIgnoreASSERT()
{
	afxIgnoreAssertCount = 1;
	ASSERT(FALSE);							// Will be ignored
	ASSERT( afxIgnoreAssertCount == 0 );  	// Will be TRUE
}

//////////////////////////////////////////////////////////////////////////////

void CMainWindow::OnGuard()
{
	TRACE( "Testing the guard blocks\n" );
	BYTE* p = new BYTE[10];
	p[10]=0xC;

	if ( !AfxCheckMemory() )
		TRACE("\tError Memory corrupt ( from program's TRACE )\n");

	afxMemDF |= checkAlwaysMemDF;

	delete p;
}

//////////////////////////////////////////////////////////////////////////////

void CMainWindow::OnCheckpoint()
{
	CMemoryState first, second, diff;

	CString str = "Hello";
	
	first.Checkpoint();
	CFile* pFile = new CFile();
	BYTE* pBits = new BYTE[10];
	second.Checkpoint();
	if ( diff.Difference(first, second) )
	{
		TRACE("Dumping Difference stats between CheckPoints\n");
		diff.DumpStatistics();
		TRACE("\nDumping all objects from now back to first Checkpoint\n");
		first.DumpAllObjectsSince();
	}
	TRACE("\nStats for all allocations from start to second Checkpoint.\n");
	second.DumpStatistics();
}

//////////////////////////////////////////////////////////////////////////////

void CMainWindow::OnLeak()
{
	TRACE( "Testing Memory Leak Detection\n" );

	afxMemDF |= delayFreeMemDF;
	
	CMemoryState first, second, diff;
	char* ptr[10];
	char * a = new char[20];
	char * b = new char[20];
	first.Checkpoint();
	for (int i = 0; i<10; i++)
		ptr[i] = new char[10];

	i=9;
	while ( i > 0 )
		delete ptr[i--];
	
	second.Checkpoint();
	delete b;
	if ( diff.Difference(first, second) )
	{
		TRACE("Dumping Difference stats between CheckPoints\n");
		diff.DumpStatistics();
		TRACE("\nDumping all objects from now back to first Checkpoint\n");
		first.DumpAllObjectsSince();
	}
}

//////////////////////////////////////////////////////////////////////////////

AFX_ALLOC_HOOK pfnOldHook;

BOOL FAR PASCAL LogAllocs( size_t nSize, BOOL bObject, LONG lRequestNumber )
{
	TRACE( "Allocating a %s that is 0x%x - request #%ld\n",
			bObject ? "Object" : "non-Object", nSize, lRequestNumber );
	return (*pfnOldHook)(nSize, bObject, lRequestNumber);
}
												

void CMainWindow::OnHookAlloc(void)
{
	pfnOldHook = AfxSetAllocHook( LogAllocs );
	char* ptr = new char[10];
	CString* str = new CString( "This string will cause an allocation too" );
	CFile* pFile = new CFile();
}

//////////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNAMIC( CDynDump, CObject )

void CMainWindow::OnDynDump()
{
	CDynDump aDump(39);
	TRACE( "\nDumping a CDynDump which does override Dump\n");
	afxDump << aDump;
	TRACE( "\n" );
}

//////////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNAMIC( CLevel1Object, CObject )
IMPLEMENT_DYNAMIC( CLevel2Object, CLevel1Object )

void DumpTree(const CObject* pObject)
{
	CRuntimeClass* pClass = pObject->GetRuntimeClass();
	TRACE( "a %s object\n", pClass->m_pszClassName );
	pClass = pClass->m_pBaseClass;
	while ( pClass != NULL )
	{
		TRACE("\tderived from %s\n",pClass->m_pszClassName);
		pClass = pClass->m_pBaseClass;
	}
}

void CMainWindow::OnDumpClass(void)
{
	CObject* p1 = new CLevel1Object();
	CObject* p2 = new CLevel2Object();

	DumpTree(p1);
	DumpTree(p2);
	DumpTree(this);
}

//////////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNAMIC( CFoo, CObject )
IMPLEMENT_DYNAMIC( CBar, CObject )

void CFooCounter(CFoo*)
{
	TRACE("Got a CFoo\n");
}
void CBarCounter(CBar*)
{
	TRACE("Got a CBar\n");
}

void DoForFooOrBar( CObList* pList, void (*pfnCFooFunction)(CFoo*),
		void (*pfnCBarFunction)(CBar*))
{
	POSITION pos = pList->GetHeadPosition();
	while (pos != NULL )
	{
		CObject* pOb = pList->GetNext(pos);
		if ( pOb->IsKindOf(RUNTIME_CLASS(CFoo) ) )
			(*pfnCFooFunction)( (CFoo*)pOb );
		if ( pOb->IsKindOf(RUNTIME_CLASS(CBar) ) )
			(*pfnCBarFunction)( (CBar*)pOb );
	}
}

void CMainWindow::OnIterate(void)
{
	CObList aList;
	aList.AddHead( new CFoo() );
	aList.AddHead( new CBar() );
	aList.AddHead( new CFoo() );
	aList.AddHead( new CFoo() );
	aList.AddHead( new CBar() );

	DoForFooOrBar( &aList, CFooCounter, CBarCounter );
}

//////////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNAMIC( CValidOb, CObject )
IMPLEMENT_DYNAMIC( CDerivedValidOb, CValidOb )
IMPLEMENT_DYNAMIC( CNotValidOb, CObject )

void Helper(CObject* pObject)
{
	// ASSERT( pObject->IsKindOf(RUNTIME_CLASS(CFoo)) );
	((CValidOb*)pObject)->Print();
}


void CMainWindow::OnBadCast(void)
{
	CObject* p1 = new CValidOb();
	CObject* p2 = new CDerivedValidOb();
	CObject* p3 = new CNotValidOb();

	Helper(p1);
	Helper(p2);
	Helper(p3);
}

	
/////////////////////////////////////////////////////////////////////////////
// CTheApp

BOOL CTheApp::InitInstance()
{
	m_pMainWnd = new CMainWindow();
	m_pMainWnd->ShowWindow( m_nCmdShow );
	m_pMainWnd->UpdateWindow();

	m_FirstMemCheck.Checkpoint();

	return TRUE;
}

BOOL CTheApp::ExitInstance()
{
#ifdef _DEBUG
	CMemoryState MemState2, DiffState;
	
	MemState2.Checkpoint();
	
	if ( !DiffState.Difference(m_FirstMemCheck, MemState2))
	{
		DiffState.DumpStatistics();
		m_FirstMemCheck.DumpAllObjectsSince();
	}
#endif
	return TRUE;
}
