//////////////////
// Sample program to produce Borland warning:
//
// Warning hide.cpp 15: 'MainWin::Paint(const void * *)' 
// hides virtual function 'Win::Paint()'
//
// To compile, type
//
// bcc hide.cpp      (Borland)
// cl  hide.cpp      (VC++)
// sc  hide.cpp      (Symantec)

///////////////////
// For this example only, so 
// I don't have to #include WINDOWS.H
//
typedef const void _near* HANDLE;
typedef HANDLE HDC;

class Win {
public:
   // Base class paint function
   virtual void Paint();
};

class MainWin : public Win {
public:
   // Overloaded derived class function
   // "hides" base class function
   virtual void Paint(HDC* hdc);
};


int main(int, char**)
{
   Win win;
   MainWin mainwin;

   // If you remove the following call, Borland still gives the
   // warning, but Microsoft and Symantec do not
   //
   mainwin.Paint();

   return 0;
}

