/*************************************************************
Module name: ProcMem.CPP
Notices: Copyright (c) 1994 Jeffrey Richter
*************************************************************/


#include <Windows.H>

#include "ProcMem.h"


//////////////////////////////////////////////////////////////


#if defined(_X86_)
#define STACKPTR(Context)  (Context.Esp)
#endif

#if defined(_MIPS_)
#define STACKPTR(Context)  (Context.IntSp)
#endif

#if defined(_ALPHA_)
#define STACKPTR(Context)  (Context.IntSp)
#endif

#if !defined(STACKPTR)
#error Module contains CPU-specific code; modify and re-compile.
#endif


//////////////////////////////////////////////////////////////


#define ORD_ExitThread		((LPCSTR) MAKEINTRESOURCE(0x55))


//////////////////////////////////////////////////////////////


PVOID AllocProcessMemory (HANDLE hProcess, DWORD dwNumBytes) {
	CONTEXT Context;
	DWORD dwThreadId, dwNumBytesXferred, dwError;
	HANDLE hThread;
	HINSTANCE hinstKrnl = GetModuleHandle(__TEXT("Kernel32"));
	PVOID pvMem;
	MEMORY_BASIC_INFORMATION mbi;
	BOOL fOk = FALSE;	// Assume failure

	__try {
		hThread = CreateRemoteThread(
			hProcess, 
			NULL,				// default security
			dwNumBytes + sizeof(HANDLE),// Initial commited stack size.
								// For us, this is also maximum stack size
								// because the code for ThreadFunc will be
								// copied to the bottom of this stack.  If
								// the stack builds down far enough, it 
								// will overwrite the code and the thread 
								// will crash.
			(LPTHREAD_START_ROUTINE) // Address of function where thread should
				GetProcAddress(hinstKrnl, ORD_ExitThread), 
								// begin execution.  We pass NULL because
								// we will be changing the instruction
								// pointer to point to our copied function.
			0,					// Parameter passed to thread function.
								// Because we will not allow the thread to
								// start running from the system's 
								// thread-start routine, this value will 
								// not be passed to our ThreadFunc.  We
								// can pass any value here.
			CREATE_SUSPENDED,	// Flags. We must create the thread
									// suspended so that we can change
									// CPU registers and copy data to the 
									// stack before the thread attempts to 
									// execute the thread.
			&dwThreadId);	// the Id of the new thread.

		if (hThread == NULL) {	
			dwError = GetLastError();
			__leave;
		}

		Context.ContextFlags = CONTEXT_CONTROL;
		if (!GetThreadContext(hThread, &Context))
			__leave;

		// Determine the bottom address of the committed memory.
		if (sizeof(mbi) != VirtualQueryEx(hProcess,
			(PDWORD) STACKPTR(Context) - 1, &mbi, sizeof(mbi)))
			__leave;

		// Store the remote thread's handle in the bottom-most
		// bytes of the allocated memory.
		pvMem = (PVOID) mbi.BaseAddress;

		fOk = WriteProcessMemory(hProcess, pvMem, &hThread, 
			sizeof(hThread), &dwNumBytesXferred);

		if (!fOk) 
			__leave;

    	// Point past the thread's handle.
		pvMem = (PVOID) ((PHANDLE) pvMem + 1);
	}
	__finally {
		if (!fOk) {
			if (hThread) {
				ResumeThread(hThread);
			}
			pvMem = NULL;
		}
	}		
    
    return(pvMem);
}


//////////////////////////////////////////////////////////////


BOOL FreeProcessMemory (HANDLE hProcess, PVOID pvMem) {
	BOOL fOk;
	HANDLE hThread;
	DWORD dwNumBytesXferred;


	// Get the handle of the remote thread from the block of 
	// memory.
	pvMem = (PVOID) ((PHANDLE) pvMem - 1);

	fOk = ReadProcessMemory(hProcess, pvMem, &hThread, 
		sizeof(hThread), &dwNumBytesXferred);

	if (fOk) {
		if (ResumeThread(hThread) == 0xffffffff) {
			// Resume failed.  Probably because the handle is
			// bad because the app overwrote the memory contents.  
			fOk = FALSE;
		}
		CloseHandle(hThread);
	}

	return(fOk);
}


//////////////////////// End Of File /////////////////////////
