/************************************************************
Module name: ImgScan.C
Notices: Copyright (c) 1993 Jeffrey Richter
************************************************************/


#include <windows.h>
#include <stdio.h>
#include <tchar.h>


/////////////////////////////////////////////////////////////


#define ARRAY_LEN(Array)	(sizeof(Array) / sizeof(Array[0]))


/////////////////////////////////////////////////////////////


BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, 
	LPVOID lpvReserved) {

	TCHAR szBuf[1024 * 10];

	if (fdwReason == DLL_PROCESS_ATTACH) {
		LPBYTE lp = NULL;
		MEMORY_BASIC_INFORMATION mbi;
		szBuf[0] = 0;
		szBuf[1] = 0;
		while (VirtualQuery(lp, &mbi, sizeof(mbi)) == sizeof(mbi)) {
			if (mbi.State == MEM_FREE) mbi.AllocationBase = mbi.BaseAddress;
			if (((HINSTANCE) lp != hinstDLL) && (lp == mbi.AllocationBase) && (mbi.Type == MEM_IMAGE)) {
				_stprintf(_tcschr(szBuf, 0), __TEXT("\n%08X-"), mbi.AllocationBase);
				GetModuleFileName((HINSTANCE) mbi.AllocationBase, _tcschr(szBuf, 0), 
					ARRAY_LEN(szBuf) - (_tcschr(szBuf, 0) - szBuf));
			}
			lp += mbi.RegionSize;
		}

		MessageBox(NULL, &szBuf[1], NULL, MB_OK);
	}
	return(TRUE);
}


//////////////////////// End Of File ////////////////////////
