/*************************************************************
Module name: TInjLib.CPP
Notices: Copyright (c) 1994 Jeffrey Richter
*************************************************************/


#include <Windows.H>
#include <stdio.h>
#include <tchar.h>

#include "InjLib.h"


//////////////////////////////////////////////////////////////


int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hInstPrev, 
	LPSTR lpszCmdLine, int nCmdShow) {

	DWORD dwProcessId = 0;
	HANDLE hProcess;

	if ((lpszCmdLine == NULL) || (*lpszCmdLine == 0)) {
		MessageBox(NULL, 
			__TEXT("Usage: InjLib [ProcessID (in hex)]"), 
			__TEXT("InjLib"), MB_ICONINFORMATION | MB_OK);
			return(0);
	} else {
		sscanf(lpszCmdLine, "%x", &dwProcessId);
	}

	if (dwProcessId == 0) {
		// A command-line argument of 0 causes everything to take place
		// in the local process,  This makes things easier for debugging.
		dwProcessId = GetCurrentProcessId();
	}

	hProcess = OpenProcess(PROCESS_ALL_ACCESS, FALSE, dwProcessId);
	if (hProcess == NULL) {
		MessageBox(NULL, (GetLastError() == 5) ? 
			__TEXT("Insufficient access to process") : __TEXT("Invalid process Id"), 
			__TEXT("Inject Library Tester"), MB_OK);
	} else {
		TCHAR szLibFile[MAX_PATH];
		GetModuleFileName(hInstance, szLibFile, sizeof(szLibFile));
		_tcscpy(_tcsrchr(szLibFile, __TEXT('\\')) + 1, __TEXT("ImgWalk.DLL"));
		MessageBox(NULL, InjectLib(hProcess, szLibFile) ? 
			__TEXT("Remote DLL Loaded") : __TEXT("Remote DLL failed load"),
			__TEXT("Inject Library Tester"), MB_OK);
		CloseHandle(hProcess);
	}

	return(0);
}


//////////////////////// End Of File /////////////////////////
