/************************************************************
Module name: ImgWalk.C
Notices: Written 1994 Jeffrey Richter
************************************************************/


#include <windows.h>
#include <stdio.h>
#include <tchar.h>


/////////////////////////////////////////////////////////////


#define ARRAY_LEN(Array)	(sizeof(Array) / sizeof(Array[0]))


/////////////////////////////////////////////////////////////


BOOL WINAPI DllMain (HINSTANCE hinstDLL, DWORD fdwReason, 
	LPVOID lpvReserved) {

	TCHAR szBuf[1024 * 10];

	if (fdwReason == DLL_PROCESS_ATTACH) {
		LPBYTE lp = NULL;
		MEMORY_BASIC_INFORMATION mbi;
		szBuf[0] = 0;
		szBuf[1] = 0;
		while (VirtualQuery(lp, &mbi, sizeof(mbi)) == sizeof(mbi)) {
			if (mbi.State == MEM_FREE)
				mbi.AllocationBase = mbi.BaseAddress;

			if ((mbi.Type == MEM_IMAGE) &&
				 (mbi.BaseAddress == mbi.AllocationBase) &&
				 ((HINSTANCE) mbi.AllocationBase != hinstDLL)) {
				_stprintf(_tcschr(szBuf, 0), __TEXT("\n%08X-"), mbi.AllocationBase);
				GetModuleFileName((HINSTANCE) mbi.AllocationBase, _tcschr(szBuf, 0), 
					ARRAY_LEN(szBuf) - (_tcschr(szBuf, 0) - szBuf));
			}
			lp += mbi.RegionSize;
		}

		MessageBox(NULL, &szBuf[1], 
			__TEXT("Image Walk"), MB_OK);
	}
	return(TRUE);
}


//////////////////////// End Of File ////////////////////////
