////////////////////////////////////////////////////////////////
// Program demonstrating __DATE__ and __TIME__ macros
//
// To compile:
//
// cl  /GA stamp.c stamp.def     (Microsoft)
// bcc /W  stamp.c               (Borland)
// sc  /W  stamp.c               (Symantec)
//

#include <windows.h>
#include <stdio.h>
#include <dos.h>
#include <fcntl.h>

char DateStamp[] = __DATE__;
char TimeStamp[] = __TIME__;

int PASCAL WinMain(HINSTANCE hinst, HINSTANCE pinst, LPSTR cmd, int show)
{
   char buf [80];
   int fh,day,month,year,min,hour;

   /* Method 1:
    * Use static variables assigned from __DATE__ and __TIME__ 
    */
   wsprintf(buf, "Compiled at %s on %s\n", 
      (LPCSTR)TimeStamp, (LPCSTR)DateStamp);
   MessageBox(NULL, buf, "STAMP", MB_OK);

   /* Method 2:
    * Read DOS time stamp from .EXE file 
    *  Note: probably better to use 
    *  GetModuleFileName to get the file name, instead
    *  of hard-wired "STAMP.EXE"
    */
   if (_dos_open("STAMP.EXE", _O_RDONLY, &fh)==0) {
      unsigned date, time;

      _dos_getftime(fh, &date, &time);
      _dos_close(fh);

      /* decrypt the m/d/y bits */
      day   = date & 0x001F;
      month = (date & 0x01E0) >> 5;
      year  = 1980 + ((date & 0xFE00) >> 9 );

      /* decrypt the hours and minutes care about double-seconds */
      min   = (time & 0x07E0) >> 5;
      hour  = (time & 0xF800) >> 11;
         
      wsprintf(buf, "STAMP.EXE last modified at %d:%d on %d-%d-%d",
         hour, min, month, day, year);
      
      MessageBox(NULL, buf, "STAMP", MB_OK);
   }
}
