/*  MOUSHAND.CPP:
    Example of how to implement a user-defined mouse handler in
    realmode, and Power Pack ver. 1.0 DPMI16 and DPMI32 modes.
    For DPMI32, the assembler is required.

    11-04-94 EDJ
*/

#include <stdio.h>
#include <conio.h>
#include <dos.h>


//  These global variables are modified by the mouse handler
//
short event,
      buttonState,
      x,
      y,
      vticks,
      hticks;


#ifdef  __DPMI32__
/*  In DPMI32, since data and code share the same space it's
    possible to keep track of the main process' DS in a variable
    that can be pulled out of the CS when in the handler.  This
    variable is used to store the data segment of the main
    program.
*/
unsigned short  DataSegment;

#else ifdef __DPMI32__
/*  In 16-bit modes, data and code are offsets from different
    segments so we need a trick that allows us to get to the
    original data segment in order to modify the main program's
    global variables.  The trick used here is to declare a
    function that reserves enough space to store two bytes (the
    value of DS).  We never call this function, we use it as a
    placeholder for data in the code segment.  The #pragma option
    turns off standard stack frame so the the first location at
    storeDS is the two bytes reserved by the __emit__ statements.
*/
#pragma option -k-
void  storeDS( void )
{
  // Reserve two bytes for DS.  NEVER CALL THIS FUNCTION!
  //
  __emit__(0x00);
  __emit__(0x00);
}

#endif  def __DPMI32__ else


extern "C" void mouseHandler( void )
{
  asm push ds

#ifdef  __DPMI32__
  /*  In 32-bits, data and code share the same selector, so we can
      access global variables through the cs register.
  */
  asm mov ds, _DataSegment

#else ifdef __DPMI32__
  /*  In 16-bit modes, we grab the data segment from the space
      reserved by the __emit__ statements in the storeDS function.
  */
  asm mov ds, cs:[storeDS]

#endif  def __DPMI32__ else

  asm
  {
    mov  event, ax
    mov  buttonState, bx
    mov  x, cx
    mov  y, dx
    mov  vticks, si
    mov  hticks, di
    pop ds
  }
}


void installMouseHandler( void )
{
  asm push es

#ifdef  __DPMI32__
  asm
  {
    mov  ax, cs
    mov  es, ax
    mov  edx, OFFSET mouseHandler
  }

#else ifdef __DPMI32__
  asm
  {
    mov  ax, SEG mouseHandler
    mov  es, ax
    mov  dx, OFFSET mouseHandler
  }

#endif

  asm
  {
    mov  ax, 0Ch
    mov  cx, 07Fh
    int  33h
    pop  es
  }
}


void removeMouseHandler( void )
{
  asm
  {
    mov ax, 0Ch
    mov cx, 0
    int 33h
  }
}
