//Message handling example.  
//
//This example is not error free and will require modifications to 
//produce fully correct results. 
//
//
//It is intended to example message passing between a TListBox and a 
//TView, so that the TView can display the current selection in the TListBox.
//
//This code is not supported by Borland International. 
//
//Borland Technical Support does not support this code.
//
//The use of this code is left strictly to the users discretion.
//
//This code is for example only, any other use is at the users own risk.
//
//Borland International does not accept any responsibility for the 
//use of this code or anything that may happen due to the use of this code.
//
//Copyright Borland International.
//
//Feb. 2, 1992
//written by: Greg Myers
//


const unsigned cmTechInfo = 101;
const unsigned cmNewData  = 102;

#define Uses_TApplication
#define Uses_TButton
#define Uses_TCheckBoxes
#define Uses_TCollection
#define Uses_TDialog
#define Uses_TDeskTop
#define Uses_TDrawBuffer
#define Uses_TEvent
#define Uses_THistory
#define Uses_TInputLine
#define Uses_TKeys
#define Uses_TLabel
#define Uses_TListBox
#define Uses_TMenuBar
#define Uses_TMenu
#define Uses_TMenuItem
#define Uses_TRadioButtons
#define Uses_TRect
#define Uses_TScrollBar
#define Uses_TSItem
#define Uses_TStaticText
#define Uses_TStatusLine
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TView
#define Uses_TWindow
#define Uses_TStringCollection
#define Uses_MsgBox

#include <tv.h>
#pragma hdrstop

TMenuItem& operator+( TMenuItem& one, TMenuItem& two)
			  {
			  TMenuItem *p = &one;

			  while (p->next != NULL) p = p->next;
			  p->next = &two;
			  return (one);
			  }


//CLASS DEFINITIONS

class MyTCollection : public TStringCollection
		{
		public :

		MyTCollection() : TStringCollection (10,5) {};
		void *readItem( ipstream& is) { return this; };
		void writeItem( void *item, opstream& os) {};
		};

//DATA and Pointer for Collection
char data[10][10] = {"one", "two", "three", "four", "five",
								 "six", "seven", "eight", "nine", "ten" };
MyTCollection *tc;

class TMyApplication : public TApplication
		{
		public:

		TMyApplication(void);
		static TMenuBar *initMenuBar(TRect);
		static TStatusLine *initStatusLine(TRect);
		void TechInfo(void);
		void handleEvent( TEvent& );
		};

class TechInfoList : public TListBox
		{
		public:


		TechInfoList( TRect&, ushort, TScrollBar* );
      void handleEvent( TEvent & );
		};

class TechInfoDialog : public TDialog
	{
	public :

	TechInfoDialog(TRect& r ) :
					TWindowInit(&TechInfoDialog::initFrame),
					TDialog (r, "Data ListBox")
		{
		TRect *t = new TRect();
		*t = getExtent();
		t->a.x ++;
      t->a.y ++;
		t->b.x --;
		t->b.y -= 2;
      TScrollBar *sb = new TScrollBar
                 ( TRect(t->b.x - 2, t->a.y + 1, t->b.x - 1, t->b.y - 2) );

      insert( sb );
		insert( new TechInfoList( *t, 1, sb ) );
      insert( new TButton(TRect(10, t->b.y - 1, 20, t->b.y + 1),
                          "~O~k", cmClose, bfDefault) );
		}
	};

class TechInfoView : public TView
		{
		char *curdata;

		public:

		TechInfoView(TRect r) : TView (r)
                         {
                         eventMask |= evBroadcast;
                         curdata = "Press Up or Down Arrow";
                         };
		void draw();
		void handleEvent(TEvent&);
		};

//Member function definitions

void TechInfoView::handleEvent(TEvent &event)
	{
	TView::handleEvent( event );

	if (event.what == evBroadcast)
		if (event.message.command == cmNewData)
			{
			curdata = (char *)event.message.infoPtr;
			drawView();
			}
	}

void TechInfoList::handleEvent(TEvent &event)
	{
	if (event.what == evKeyDown)
		switch (event.keyDown.keyCode)
		 {
		 case kbUp :
           message( TProgram::deskTop, evBroadcast,
                    cmNewData, tc->at(focused > 0 ? focused - 1 : focused));
           break;
		 case kbDown :
           message( TProgram::deskTop, evBroadcast,
                    cmNewData, tc->at(focused  + 1));
           break;
		 default :
   		  break;
				 }
	TListBox::handleEvent( event );
	}


void TechInfoView::draw()
	{
	TDrawBuffer  *tb = new TDrawBuffer;

	TView::draw();
	tb->moveBuf(0, curdata, getColor(1), 10);
	writeBuf(0,0,10,1, *tb );
	}


TechInfoList::TechInfoList(TRect& r, ushort numcols, TScrollBar *sb) :
 TListBox ( TRect(r.a.x + 2, r.a.y + 1, r.b.x - 3, r.b.y - 2 ), numcols, sb )
	{
	tc = new MyTCollection ();
	for (int c = 0; c < 10; c++)
		{
		tc->insert( (void *)data[c] );
		}
	newList( tc );
	}


TStatusLine *TMyApplication::initStatusLine(TRect r)
				{
				r.a.y = r.b.y - 1;

            return new TStatusLine( r,
						*new TStatusDef(0, 0xFFFF) +
							  *new TStatusItem("~Alt-X~ Exit", kbAltX, cmQuit) +
							  *new TStatusItem("~Alt-F3~ Close", kbAltF3, cmClose)
						);
				}


TMenuBar *TMyApplication::initMenuBar(TRect r)
		 {
		 r.b.y = r.a.y + 1;

		 return new TMenuBar (r,
			new TMenu(
				 *new TMenuItem("I~n~fo", kbAltN,
						new TMenu(
		 *new TMenuItem("~I~nfo", cmTechInfo, kbAltI, hcNoContext, "Alt-I") +
		 *new TMenuItem("E~x~it", cmQuit, kbAltX, hcNoContext, "Alt-X")
							 )
						)
				 )
			);
		}

TMyApplication::TMyApplication() :
      TProgInit (&initStatusLine,
                 &initMenuBar,
                 &initDeskTop)

      {
		}

void TMyApplication::handleEvent (TEvent& event)
	  {
	  TApplication::handleEvent(event);
	  if (event.what == evCommand)
		  {
		  switch (event.message.command)
					{
					case cmTechInfo :
						  TechInfo();
						  break;

					default : return;
					}
		  clearEvent (event);
		  }
	  }

void TMyApplication::TechInfo()
	  {
	  TRect tr;

	  tr.a.x = 10;
	  tr.a.y = 17;
	  tr.b.x = tr.a.x + 30;
	  tr.b.y = tr.a.y + 3;
	  TechInfoView *tv = new TechInfoView(TRect(1,1,10,3));
	  TWindow *twv =  new TWindow(
                     TRect( tr.a.x - 1, tr.a.y - 1, tr.b.x + 1, tr.b.y + 1 ),
											 "Individual View", 2 );
	  twv->insert( tv );
	  deskTop->insert( twv );

	  tr.a.x = 10;
	  tr.a.y = 1;
	  tr.b.x = tr.a.x + 30;
	  tr.b.y = tr.a.y + 10;
	  TechInfoDialog *ti = new TechInfoDialog( tr );
	  deskTop->execView( ti );
	  }

int main()
	{
	TMyApplication tmyapp;

	tmyapp.run();

	return 0;
	}
