//************************************************************************
// 	MSELM.H
//************************************************************************
//
//  Purpose:	Multiple Selection Moving Box
//
//  Project:
//
//  Author:	ABRI Datenverarbeitung GesmbH
//		Andreas Vogel
//		Miltnerweg 17/14/19
//		A-1110 Vienna, Austria
//		phone/fax/modem: 0043 1 76 23 35
//		handy:		 0043 0663 802 538
//		CIS:		 100343,2704
//
//  History:
//
//	94-10-25  V1.0	created
//
//	--------------------------------------------------------
//
//  Brief description:
//
//	This listbox implementation provides single or multiple selections
//	and moving of the choosen items similary to the Borlands project
//	window. I do not use the ItemData, so if you need to act on the new
//	order of the items (e.g. new data to show) simply use the ItemData
//	for your own purpose.
//
//	Some code sequences look very strong, but the handling with the MS
//	messages and focus rectangles is not as easy as I thought.
//
//	I lent two cursor bitmaps from one of the Borland IDE DLLs.
//

//-------------------------------------------------------- defines -------

#if __TURBOC__ >= 0x410
#define TResID TResId
#endif

#define WM_NEWORDER (WM_USER+3)		// yes I know, blue monday ...

#define TIMER_ID 5

//-------------------------------------------------------- globals -------
//------------------------------------------------------ externals -------
//--------------------------------------------- external functions -------
//------------------------------------------------ local functions -------
//-------------------------------------------------------- statics -------


//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

class cMSelMBox : public TListBox

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
{
  int		mMode;                  //-1 .. invalid starting position
					// 0 .. no 2nd item mode
					// 1 .. 2nd mode but erased
					// 2 .. 2nd mode and focused
  int		mItemHeight;
  int		mCurrSel;		// 1st focus item
  int		mScndSel;		// 2nd focus item
  TRect 	mCurrRect;		// current 2nd rectangle
  int		mTimer;			// timer state
  int		mItemsInWin;		// max # of items in listbox window
  int		mScndFocus;		// 2nd focus item
  HCURSOR	mMoveCur, mNMoveCur;	// cursor handles

  int		*mCurrSelArr;		// current selection
  int		mCurrSelCnt;            // # of items of current selection

  BOOL		mLButtonProc;		// LButton() has processed

public:
	cMSelMBox(TWindow *p, int id, TModule *m=NULL);

protected:
  BOOL	Create();

  void	EvDrawItem(UINT, DRAWITEMSTRUCT far & );

  void	EvLButtonDown(UINT modkeys, TPoint &p);
  void	EvLButtonUp(UINT modkeys, TPoint &p);
  void	EvMouseMove(UINT modkeys, TPoint &p);

  void  EvTimer(UINT);

  int	GetLine(TPoint &p) {
		return (p.y / mItemHeight) + GetTopIndex(); }

  DECLARE_RESPONSE_TABLE(cMSelMBox);
};

