//************************************************************************
// 	MSELM.CPP
//************************************************************************
//
//  Purpose:	Multiple Selection Moving Box
//
//  Project:
//
//  Author:	ABRI Datenverarbeitung GesmbH
//		Andreas Vogel
//		Miltnerweg 17/14/19
//		A-1110 Vienna, Austria
//		phone/fax/modem: 0043 1 76 23 35
//		handy:		 0043 0663 802 538
//		CIS:		 100343,2704
//
//  History:
//
//	94-10-30  V1.2	EvMouseMove() modified
//	94-10-29  V1.1	EvDrawItem() modified
//	94-10-25  V1.0	created
//
//	--------------------------------------------------------
//
//  Brief description:
//
//	This listbox implementation provides single or multiple selections
//	and moving of the choosen items similary to the Borlands project
//	window. I do not use the ItemData, so if you need to act on the new
//	order of the items (e.g. new data to show) simply use the ItemData
//	for your own purpose.
//
//	Some code sequences look very strong, but the handling with the MS
//	messages and focus rectangles is not as easy as I thought.
//
//	I lent two cursor bitmaps from one of the Borland IDE DLLs.
//

#include <owl\owlpch.h>
#include <owl\listbox.h>
#include <ctl3d.h>

#include "mselm.h"

#include "test.rc"

//-------------------------------------------------------- defines -------

#define REP_TIME 60	// time in [ms] for scrolling

//-------------------------------------------------------- globals -------
//------------------------------------------------------ externals -------
//--------------------------------------------- external functions -------
//------------------------------------------------ local functions -------
//-------------------------------------------------------- statics -------

DEFINE_RESPONSE_TABLE1(cMSelMBox, TListBox)
  EV_WM_TIMER,
  EV_WM_DRAWITEM,
  EV_WM_MOUSEMOVE,
  EV_WM_LBUTTONDOWN,
  EV_WM_LBUTTONUP,
END_RESPONSE_TABLE;

//------------------------------------------------------------------------
	cMSelMBox::cMSelMBox(TWindow *p, int id, TModule *m) :
		TListBox(p,id,m)
//------------------------------------------------------------------------
{
  mLButtonProc = mTimer = 0;
  mMode = mCurrSel = mScndSel = -1;

  mCurrSelArr = NULL;
  mCurrSelCnt = 0;

  // calculate char height & item height
  // take the font from the dialog:
  TEXTMETRIC   TextMetrics;
  TWindowDC    hdc(*this);

  hdc.GetTextMetrics(TextMetrics);

  mItemHeight = TextMetrics.tmHeight - 1;
}

//------------------------------------------------------------------------
void  	cMSelMBox::EvTimer(UINT)
//------------------------------------------------------------------------
{
  int ti = GetTopIndex();

  if (mTimer==1)
  {
    // Scroll down
    if (ti+mItemsInWin < GetCount())
      PostMessage(WM_VSCROLL, SB_LINEDOWN);
  }
  else
    if (mTimer==2)
    {
      // Scroll up
      if (ti > 0)
	PostMessage(WM_VSCROLL, SB_LINEUP);
    }
}

//------------------------------------------------------------------------
BOOL	cMSelMBox::Create()
//------------------------------------------------------------------------
{
  BOOL ret = TWindow::Create();

  mMoveCur  = GetApplication()->LoadCursor(IDC_MOVECURSOR);
  mNMoveCur = GetApplication()->LoadCursor(IDC_NMOVECURSOR);

  SetItemHeight(0, mItemHeight);

  TRect WRect;			// listbox window size
  GetWindowRect(WRect);

  // max # of items in listboxwindow
  mItemsInWin = WRect.Height() / mItemHeight;

  return ret;
}

//------------------------------------------------------------------------
void	cMSelMBox::EvDrawItem(UINT 		     /*ctrlId*/,
			     DRAWITEMSTRUCT far & draw)
//------------------------------------------------------------------------
{
  WORD       	wTopText;
  TRect      	rcTemp;
  char		str[80];
  int		idx;

  if ( draw.itemID == (UINT)-1 )
     return ;

  rcTemp = draw.rcItem;

  wTopText = rcTemp.top;

  if (draw.itemAction == ODA_FOCUS && mMode<=0)
  {
    ::DrawFocusRect(draw.hDC, &rcTemp);
    return;
  }

  // temp DC for easier handling
  TDC DrawDC(draw.hDC);

  if (mMode>0)
  {
    DrawDC.SetBkColor(GetSysColor(COLOR_WINDOW));
    DrawDC.SetTextColor(GetSysColor(COLOR_WINDOWTEXT));

    for (idx=0; idx<mCurrSelCnt; idx++)
      if (draw.itemID==mCurrSelArr[idx])
      {
	DrawDC.SetBkColor(GetSysColor(COLOR_HIGHLIGHT));
	DrawDC.SetTextColor(GetSysColor(COLOR_HIGHLIGHTTEXT));

	DrawDC.FillRect(rcTemp, TBrush(GetSysColor(COLOR_HIGHLIGHT)) );

	break;
      }
  }
  else
    if (draw.itemState & ODS_SELECTED && mMode<=0)
    {
      DrawDC.SetBkColor(GetSysColor(COLOR_HIGHLIGHT));
      DrawDC.SetTextColor(GetSysColor(COLOR_HIGHLIGHTTEXT));

      DrawDC.FillRect(rcTemp, TBrush(GetSysColor(COLOR_HIGHLIGHT)) );
    }
    else
    {
      DrawDC.SetBkColor(GetSysColor(COLOR_WINDOW));
      DrawDC.SetTextColor(GetSysColor(COLOR_WINDOWTEXT));
    }

  GetString(str, draw.itemID);   	// get the item text

  DrawDC.ExtTextOut(rcTemp.left + 1, wTopText,
		    ETO_CLIPPED | ETO_OPAQUE,
		    &rcTemp,
		    str, lstrlen(str));

  if (mMode>0)
  {
    if (draw.itemID==mCurrSel)
    {
      // paint the focus for the first selected item
      ::DrawFocusRect(draw.hDC, &rcTemp);
    }
    else
      if (draw.itemID == mScndFocus)
      {
	// paint the focus for the 2nd item
	::DrawFocusRect(draw.hDC, &rcTemp);
      }
  }
}

//------------------------------------------------------------------------
void	cMSelMBox::EvLButtonDown(UINT modkeys, TPoint &p)
//------------------------------------------------------------------------
{
  int	  Line;

  mCurrSelCnt = GetSelCount();

  mCurrSel = GetCaretIndex();

  if (mCurrSelArr)
    delete mCurrSelArr;

  mCurrSelArr = new int[mCurrSelCnt];

  GetSelIndexes(mCurrSelArr, mCurrSelCnt);

  // item on which the 2nd focus should be painted
  Line = GetLine(p);

  if (GetSel(Line))
    mMode = 0;

  if (mMode >= 0)
  {
    // remove all pending messages ...
    MSG  loopMsg;

    loopMsg.message = 0;
    SetCapture();

    while (loopMsg.message != WM_LBUTTONUP &&
	  (loopMsg.message != WM_MOUSEMOVE || (loopMsg.wParam&MK_LBUTTON)))
    {
      if (::PeekMessage(&loopMsg, 0, 0, 0, PM_REMOVE))
      {
	::TranslateMessage(&loopMsg);
	::DispatchMessage(&loopMsg);
      }
    }
    ReleaseCapture();
  }
  else
  {
    TListBox::EvLButtonDown(modkeys, p);		// new selection
    mLButtonProc = 1;

    // Special handling when only one item is selected and moved
    // immediately after selection.

    if (/*Line == GetCaretIndex() && */GetSelCount()==1 && !(modkeys & MK_CONTROL))
    {
      if (mCurrSelArr)
	delete mCurrSelArr;

      mCurrSelArr = new int[2];
      mCurrSelCnt = 1;
      mCurrSel = mCurrSelArr[0] = GetCaretIndex();

      mMode = 0;
    }

  }
}

//------------------------------------------------------------------------
void	cMSelMBox::EvLButtonUp(UINT modkeys, TPoint &p)
//------------------------------------------------------------------------
{
  if (mTimer)
  {
    KillTimer(TIMER_ID);
    mTimer = 0;
  }

  if (mLButtonProc)
  {
    TListBox::EvLButtonUp(modkeys, p);
    mLButtonProc = 0;
  }
  else
  {
    MSG  loopMsg;

    loopMsg.message = 0;
    SetCapture();

    while (::PeekMessage(&loopMsg, 0, 0, 0, PM_REMOVE))
    {
      ::TranslateMessage(&loopMsg);
      ::DispatchMessage(&loopMsg);
    }

    ReleaseCapture();
  }

  if (mMode <= 0)
  {
    int Line = GetLine(p);

    // Handle the case of a new selection. I must use the selections before
    // the LButtonDown() has processed!
    for (int i=0; i<mCurrSelCnt; i++)
      if (mCurrSelArr[i] == Line)
      {
	if (modkeys & MK_CONTROL)
	  SetSel(Line, 0);		// unselect single item
	else
	{
	  // unselect ALL previous selections and select new single item
	  SetSelIndexes(mCurrSelArr, mCurrSelCnt, 0);
	  SetSel(Line, 1);
	}
	break;
      }
  }

  if (mMode>0)
  {
    SendMessage(WM_SETREDRAW, FALSE);   	// Disable redrawing

    for (int i=0; i<GetCount(); i++)
      SetSel(i, 0);

    SetCaretIndex(mCurrSel, 0);

    if (::GetCursor() == mMoveCur)	// act only on valid position
    {
      char **hstr;

      hstr = new char*[mCurrSelCnt];

      for (i=0; i<mCurrSelCnt; i++)
      {
	// get all contents
	hstr[i] = new char[GetStringLen(mCurrSelArr[i])+1];
	GetString(hstr[i], mCurrSelArr[i]);
      }

      int offs = 0;

      for (i=0; i<mCurrSelCnt; i++)
      {
	// remove all fst selected items
	DeleteString(mCurrSelArr[i] - offs);

	// consider that item may be moved
	if (mScndSel > (mCurrSelArr[i]-offs))
	  mScndSel--;

	offs++;
      }

      mScndSel++;	// POST insertion

      for (i=0; i<mCurrSelCnt; i++)
      {
	InsertString(hstr[i], mScndSel++);

	delete hstr[i];
      }

      delete hstr;

      SetSelItemRange(TRUE, mScndSel-i, mScndSel-1);
      SetCaretIndex(mScndSel-i, 1);

      Parent->PostMessage(WM_NEWORDER);
    }
    else
    {
      // reset to old selections
      SetSelIndexes(mCurrSelArr, mCurrSelCnt, 1);
      SetCaretIndex(mCurrSel, 1);
    }

    SendMessage(WM_SETREDRAW, TRUE);   	// Enable redrawing

    Invalidate();
  }

  if (mCurrSelArr)
  {
    delete mCurrSelArr;
    mCurrSelArr = NULL;
    mCurrSelCnt = 0;
  }

  mMode = -1;
  mScndSel = -1;
  
  ::SetCursor(LoadCursor(0, IDC_ARROW));
}

//------------------------------------------------------------------------
void	cMSelMBox::EvMouseMove(UINT modkeys, TPoint &p)
//------------------------------------------------------------------------
{
  if (modkeys & MK_LBUTTON)
  {
    TRect 	WRect;			// listbox window size

    if (mMode < 0)
      return;

    GetWindowRect(WRect);

    // item on which the 2nd focus should be painted
    int	  Line = GetLine(p);

    if (Line < 0)
      Line = 0;
    else
      if (Line > GetCount())
	Line = GetCount();

    if (mMode>0)
    {

      if (p.y >= WRect.Height())
      {
	// mouse moves out below the window
	if (!mTimer)
	{
	  if (mMode==2)
	  {
	    mScndFocus = -1;

	    // erase old rectangle
	    InvalidateRect(mCurrRect);
	    mMode = 1;
	  }

	  SetTimer(TIMER_ID, REP_TIME);
	}
	mTimer = 1;
	::SetCursor(mNMoveCur);
	return;
      }
      else
	if (p.y < 0)
	{
	  // mouse moves out above the window
	  if (!mTimer)
	  {
	    if (mMode==2)
	    {
	      mScndFocus = -1;

	      // erase old rectangle
	      InvalidateRect(mCurrRect);
	      mMode = 1;
	    }

	    SetTimer(TIMER_ID, REP_TIME);
	  }
	  mTimer = 2;
	  ::SetCursor(mNMoveCur);
	  return;
	}
	else
	  if (mTimer)
	  {
	    KillTimer(TIMER_ID);
	    mTimer = 0;
	    mScndSel = -1;
	  }
    }

/* I dont know why I need this ? removed for V1.2

    // evaluate the startup state
    if (!mMode && !mTimer)
    {
      // cursor must be inside the window
      if (p.y < WRect.Height() && p.y > 0)
      {
	// start position must be on a selected item
	if (GetSel(Line))
	{
	  mMode = 1;
	  ::SetCursor(mNMoveCur);
	}
      }
      return;
    }
*/

    if (mScndSel != Line && !mTimer) 	// && Line<GetCount())
    {
      if (mMode==2)
      {
	mScndFocus = -1;

	// erase old rectangle
	InvalidateRect(mCurrRect);

	mMode = 1;
      }

      if (!GetSel(Line))	// draw only when 2nd item is not the first one
      {
	TRect	ItemRect;

	GetItemRect(0, ItemRect);

	ItemRect += TSize(0, mItemHeight * Line);

	mScndFocus = Line;

	InvalidateRect(mCurrRect = ItemRect);

	mMode = 2;

	::SetCursor(mMoveCur);
      }
      else
	::SetCursor(mNMoveCur);

      mScndSel = Line;
    }

  }
}

