//************************************************************************
// 	TEST.CPP
//************************************************************************
//
//  Purpose:	Test prog for MSELMB (Multiple Selection Moving Box)
//
//  Project:	MSELM-Test
//
//  Author:	ABRI Datenverarbeitung GesmbH
//		Andreas Vogel
//		Miltnerweg 17/14/19
//		A-1110 Vienna, Austria
//		phone/fax/modem: 0043 1 76 23 35
//		handy:		 0043 0663 802 538
//		CIS:		 100343,2704
//
//  History:
//
//	94-10-25  V1.0	created
//
//	--------------------------------------------------------
//
//  Brief description:
//

#include <owl\owlpch.h>
#include <owl\statusba.h>
#include <owl\applicat.h>
#include <owl\decframe.h>
#include <owl\dialog.h>
#include <owl\checkbox.h>
#include <owl\listbox.h>

#include <stdio.h>

#include "mselm.h"

#include "test.rc"

//-------------------------------------------------------- defines -------

#if __TURBOC__ >= 0x410
#ifndef TResID
#define TResID TResId
#endif
#endif

//-------------------------------------------------------- globals -------
//------------------------------------------------------ externals -------
//--------------------------------------------- external functions -------
//------------------------------------------------ local functions -------
//-------------------------------------------------------- statics -------


#define WINDOWTITLE "MSELM Test"

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

class TestDialog : public TDialog

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
{
  TListBox	*ListBox;

public:
	TestDialog(TWindow *, TResID);

  // overloaded
  void	SetupWindow();

  // user message
  void		CmListBox();
  LRESULT	CmSelChangeBox(WPARAM, LPARAM);

DECLARE_RESPONSE_TABLE(TestDialog);
};

DEFINE_RESPONSE_TABLE1(TestDialog, TDialog)
  EV_MESSAGE		(WM_NEWORDER,	CmSelChangeBox),
  EV_LBN_DBLCLK		(ID_LISTBOX,	CmListBox),
END_RESPONSE_TABLE;

//------------------------------------------------------------------------
void 	TestDialog::CmListBox()
//------------------------------------------------------------------------
{
}

//------------------------------------------------------------------------
LRESULT	TestDialog::CmSelChangeBox(WPARAM, LPARAM)
//------------------------------------------------------------------------
{
  return 0;
}

//------------------------------------------------------------------------
	TestDialog::TestDialog(TWindow *Parent, TResID Id) :
		TDialog(Parent, Id)
//------------------------------------------------------------------------
{
  ListBox = new cMSelMBox(this, ID_LISTBOX);
}

//------------------------------------------------------------------------
void	TestDialog::SetupWindow()
//------------------------------------------------------------------------
{
  TDialog::SetupWindow();

  for (int i=0; i<20; i++)
  {
    char hstr[40];

    sprintf(hstr,"This is item # %d", 20-i);

    ListBox->AddString(hstr);
  }

  ListBox->SetTopIndex(0);
}

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

class TMyApp : public TApplication

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
{
  public:
    TMyApp() : TApplication() {}
    ~TMyApp();

  protected:
    TMDIClient *Client;

    // Override methods of TApplication
    void InitInstance();
    void InitMainWindow();

    // user defined menus
    void CmDialogTest();

  DECLARE_RESPONSE_TABLE(TMyApp);
};

DEFINE_RESPONSE_TABLE1(TMyApp, TApplication)
  EV_COMMAND(CM_DIALOGTEST, CmDialogTest),
END_RESPONSE_TABLE;

//------------------------------------------------------------------------
void 	TMyApp::InitMainWindow()
//------------------------------------------------------------------------
{
  // Construct the decorated frame window

  TDecoratedMDIFrame* frame =
	new TDecoratedMDIFrame(WINDOWTITLE,
			       0,
			       *(Client = new TMDIClient),
			       TRUE);	// statusbar menu-tracking

  // Construct a status bar
  TStatusBar* sb = new TStatusBar(frame, TGadget::Recessed);

  // Insert the status bar and control bar into the frame
  frame->Insert(*sb, TDecoratedFrame::Bottom);

  EnableCtl3d();	// ctl3d.dll

  // Set the main window and its menu
  SetMainWindow(frame);
  GetMainWindow()->SetMenuDescr(TMenuDescr("COMMANDS",1,0,1,0,0,0));
}

//------------------------------------------------------------------------
void	TMyApp::InitInstance()
//------------------------------------------------------------------------
{
  TApplication::InitInstance();

//  GetMainWindow()->DragAcceptFiles(TRUE);
}

//------------------------------------------------------------------------
void 	TMyApp::CmDialogTest()
//------------------------------------------------------------------------
{
  TestDialog( GetMainWindow(), "MSELM_DIALOG").Execute();
}

//------------------------------------------------------------------------
	TMyApp::~TMyApp()
//------------------------------------------------------------------------
{
}

//************************************************************************
int 	OwlMain(int /*argc*/, char* /*argv*/ [])
//************************************************************************
{
  return TMyApp().Run();
}

