/*

	TEST MIDI.C Midi Read functionality.


*/

#include <stdio.h>
#include <stdlib.h>
#include "std.h"
#include "midi.h"
#include <conio.h>


#define PROGNAME "READTEST"

#define printf cprintf
#define CR "\r\n"

void midiError(int midi_error_code) {
	printf(PROGNAME ": %s\n",MidiErrorString(midi_error_code));
	exit(9);
}

void PrintMidiMessage(MidiMessageT *msg) {
	UCHAR midi_msg[3];

	GetMidiMessageData(msg,&midi_msg[0],&midi_msg[1],&midi_msg[2]);
	printf("%s" CR,MidiName(midi_msg));
}
#pragma argsused
int main(int argc, char**argv) {
	int result;
	MidiChannelT *channel;
	MidiMessageT *msg;

	directvideo = 1;
	fprintf(stderr,"MIDIDBG v1.1 - Trace all MIDI commands on the screen" CR
					   "Copyright (c) 1990, Robin Davies" CR
					   CR
	);
	channel = CreateMidiChannel(
				0, 		// base_address
				0,		// int #
				32760,  // buffer size
				STOP_MODE,   // Operating mode
				MPU_INTERNAL_CLOCK, // internal clock
				60,			// Beats per minute
				MPU_TIMEBASE_192, // Timebase
				0,				 // Metronome beats per measure
				MPU_RX_ALL | MPU_DEFAULT_THRU, // rx/thru messages
				-1,			// midi_channel_mask (rx all midi channels)
				1,		    // Record tracks
				&result
			);

	if (channel == NULL) {
		midiError(result);
	}

	SetMidiOperatingMode(channel,RECORD_MODE);
	while (YES) {
		msg = ReceiveMidiMessage(channel);
		if ((result = MidiStatus(channel)) != 0) {
			midiError(result);
		}
		if (msg != NULL) {
			PrintMidiMessage(msg);
			FreeMidiMessage(msg);
		} else {
			if (kbhit())
				break;
		}
	}
	DestroyMidiChannel(channel);
	getch();
	return 0;
}
