/*--------------------------------------------------------------
 *  File:           MPMENU.H
 *  Description:    
 *
 *  Developed for the MPLUS Graphic Interface Library
 *  Copyright (c) 1989, 1990 by Michael Yam
 *-------------------------------------------------------------*/

#if !defined(_MPTYPES)
typedef short word;
#define _MPTYPES                /* include only once */
#endif

/*  Bit masks for menubar attributes.  See MENU_ITEM structure.
 *  Reminder: Intel hardware, most significant bit on the left.
 */
#define MB_SUBMENU      0x80
#define MB_GREYOUT      0x40
#define MB_CHECKMARK    0x02

typedef struct _menubar MENUBAR;

struct RECTANGLE
{
    word x1, y1, x2, y2;
};

struct MENU_INFO
{
    int exitkey;
    int (*exitfun)();
    word fg0, bg0, keycolor0, greyout0;     /* attr for menu bar */
    word border;
    word fg, bg, keycolor, greyout;         /* attr for pull-down menus */
};

struct MENU_ITEM
{
    char *title;
    int (*function)();
    struct MENU_ITEM *menu_item;
    int hotkey;                             /* new with v1.4 */
    unsigned submenu:   1;
    unsigned greyout:   1;
    unsigned checkmark: 1;                  /* new with v1.4 */

    /* Remaining 5 bits reserved for future use. */
};

struct _menubar
{
    word r1, c1, c2;
    word x1, y1, x2, y2;
    char *image;
};

/*--------------------------------------------------------------
 *  Function Prototypes
 *--------------------------------------------------------------*/
extern  int mb_open(word r1,word c1,word c2,struct MENU_INFO *menu_info,struct MENU_ITEM *menu_item);
extern  int mb_close(void);
extern  void mb_hide(void);
extern  void mb_show(void);
extern  int (cdecl *mb_run(void))();
extern  int mb_setbits(struct MENU_ITEM *menu_item,unsigned int mask,unsigned int status);

extern  int (cdecl *mb_kbinput(struct _menubar *mbptr,int index,struct MENU_INFO *menu_info,struct MENU_ITEM *menu_item))();
extern  int (cdecl *mb_msinput(struct _menubar *mbptr,int index,struct MENU_INFO *menu_info,struct MENU_ITEM *menu_item))();
extern  int mb_altkey(struct MENU_ITEM *menu_item,int ch);
extern  int (cdecl *mb_hotkey(struct MENU_ITEM *menu_item,int ch))();
extern  int mb_intitle(struct _menubar *mbptr,struct MENU_ITEM *menu_item,word x0,word y0);
extern  word mb_highlite(struct _menubar *mbptr,struct MENU_ITEM *menu_item,int index);
extern  void mb_stdcolors(struct MENU_INFO *menu_info);

extern  struct _gwdw *mw_open(word r1,word c1,struct MENU_INFO *menu_info,struct MENU_ITEM *menu_item);
extern  int mw_close(struct _gwdw *gwptr);
extern  word mw_getcols(struct MENU_ITEM *menu_item);
extern  word mw_getrows(struct MENU_ITEM *menu_item);
extern  void mw_showtitles(struct MENU_INFO *menu_info,struct MENU_ITEM *menu_item);
extern  void mw_highlite(struct MENU_ITEM *menu_item,word index);
extern  word mw_intitle(struct MENU_ITEM *menu_item,word x0,word y0);
extern  int mw_nexttitle(struct MENU_ITEM *menu_item,int activetitle);
extern  int mw_prevtitle(struct MENU_ITEM *menu_item,int activetitle);
extern  int (cdecl *mw_kbinput(struct MENU_INFO *menu_info,struct MENU_ITEM *menu_item))();
extern  int (cdecl *mw_msinput(struct _menubar *mbptr,struct MENU_INFO *menu_info,struct MENU_ITEM *menu_item))();
extern  struct _gwdw *mw_opensubmenu(struct MENU_INFO *menu_info,struct MENU_ITEM *menu_item,int activetitle);

/*--------------------------------------------------------------*
 *                      End of MPMENU.H                         *
 *--------------------------------------------------------------*/
