/*--------------------------------------------------------------
 *  File:           MOUSER.H
 *  Description:    Defines and function definitions for MPLUS
 *                  mouse routines.
 *
 *  Developed for the MPLUS Graphic Interface Library
 *  Copyright (c) 1989 by Michael Yam
 *-------------------------------------------------------------*/

#if !defined(_MPTYPES)
typedef short word;
#define _MPTYPES                /* include only once */
#endif

/*      Bit mask values for mouse function 12.
 */
#define _CSRMOVED    0x01
#define _LBPRESSED   0x02
#define _LBRELEASED  0x04
#define _RBPRESSED   0x08
#define _RBRELEASED  0x10
#define _MSALLINT    0x1F

/*      Left and right mouse buttons defined
 */
#define MSLBTN          0
#define MSRBTN          1

/*      Return values for dev_ready()
 */
#define _KB         1
#define _MS         2

/*      Mouse structure
 */
struct ms_status
{
    unsigned int condmask;
    int lbtn;
    int lbpress;
    int lbrelease;
    int rbtn;
    int rbpress;
    int rbrelease;
    word x, y;
};

/*      Don't reference these directly unless you have source code.
 *      Use ms_cursor() and ms_reset().
 */
extern char _ms_cursor;                 /* cursor on or off */
extern char _ms_present;                /* any mouse? */

/*--------------------------------------------------------------
 *  Function Prototypes
 *-------------------------------------------------------------*/
extern  int mouser(int *m1,int *m2,int *m3,int *m4);
extern  int ms_reset(void);
extern  void ms_showcursor(void);
extern  void ms_hidecursor(void);
extern  int ms_cursor(void);
extern  void ms_getposition(word *x,word *y,int *left,int *right);
extern  void ms_setposition(word x,word y);
extern  int ms_getpress(int button,int *bstatus,int *bpress,word *x,word *y);
extern  int ms_getrelease(int button,int *bstatus,int *brelease,word *x,word *y);
extern  void ms_window(word x1,word y1,word x2,word y2);
extern  void ms_setint(unsigned int mask,unsigned int segment,unsigned int offset);
extern  int ms_poll(struct ms_status *ms_status);
extern  unsigned int ms_ready(void);
extern  void ms_setevent(char flag);
extern  int dev_ready(int *ch,struct ms_status *ms_stat);

/*-------------------------------------------------------------*
 *                  End of MOUSER.H                            *
 *-------------------------------------------------------------*/

