/*--------------------------------------------------------------
 *  File:           PUSHDEMO.C
 *  Description:    This program illustrates how to create a
 *                  3-D push button for use with a mouse.
 *
 *  This demo developed for the MPLUS Graphic Interface Library.
 *-------------------------------------------------------------*/

#include <stdio.h>
#include <graph.h>

#include "gplus.h"
#include "gscreen.h"
#include "mouser.h"

main()
{
    int quit, ch, device;
    struct ms_status ms_status;
    GWDW *groot;
    GWDW *gwpush;
    GWDW *gwquit;

    mpsetvideomode( _ERESCOLOR );

    if( ms_reset() == 0 )
    {
        printf("\nMouse driver not loaded.\n");
        mpsetvideomode( _DEFAULTMODE );
        exit(1);
    }
    ms_setevent(1);             /* enable mouse interrupt trapping */
    ms_showcursor();

    /*      Open our background window as a "root" window to conserve
     *      memory.
     */
    groot = groottopen( 10, 20, 16, 50, _GFILLINTERIOR, BRIGHTWHITE, GREY );
    _settextposition( 5, 1 );
    outtext( "Click left mouse button", BRIGHTWHITE, -1 );

    /*      This is our "push" button.
     */
    gwpush = gwdwtopen( 11, 25, 13, 32, _GRAISE, BLACK, WHITE );
    outtext( " PUSH", BLACK, -1 );

    /*      Here's another push button used to quit this demo.
     */
    gwquit = gwdwtopen( 11, 40, 13, 47, _GRAISE, BLACK, WHITE );
    outtext( " QUIT", BLACK, -1 );

    quit = 0;
    while( !quit )
    {
        device = dev_ready( &ch, &ms_status );
        if( device == _MS )
        {
            /*      Got some mouse input...
             */
            if( (ms_status.condmask & _LBPRESSED) ||
                (ms_status.condmask & _LBRELEASED) )
            {
                /*      according to mask, left button was pushed
                 *      or released.  Use ginwindow() to determine
                 *      which button the mouse was pointing to.
                 */
                if( ginwindow( gwpush, ms_status.x, ms_status.y ) )
                    physhighlite( gwpush->x1, gwpush->y1, gwpush->x2, gwpush->y2);
                else if( ginwindow( gwquit, ms_status.x, ms_status.y ) )
                {
                    /*      mouse was on "quit" button.  Use physhighlite()
                     *      to "press" button down.
                     */
                    physhighlite( gwquit->x1, gwquit->y1, gwquit->x2, gwquit->y2 );
                    quit = 1;
                }
            }
        } /* end if( device == _MS ) */
    } /* end while( !quit ) */

    /*      Clean up.
     */
    ms_reset();
    gwdwclose( gwpush );
    gwdwclose( gwquit );
    grootclose( groot );
    mpsetvideomode( _DEFAULTMODE );
}



