/*--------------------------------------------------------------
 *  File:           GDDEMO.C
 *  Description:    Program to demonstrate MPLUS dialog boxes.
 *
 *  This demo developed for the MPLUS Graphic Interface Library.
 *-------------------------------------------------------------*/

#include <graph.h>
#include "gscreen.h"
#include "gplus.h"

/*--------------------------------------------------------------
 *  Function:       main
 *  Description:    open the three standard dialog boxes.
 *  Return value:   0
 *--------------------------------------------------------------*/
main()
{
    int option;

    /* if( setvideomode( _HRESBW ) == 0 ) */    /* for you CGA people out there */
    if( setvideomode( _ERESCOLOR ) == 0 )
    {
        printf("\nProgram requires EGA mode.\n");
        exit(1);
    }
    /* setvideomode( _MRES4COLOR ); */
    ms_reset();                         /* reset mouse */
    ms_setevent(1);
    ms_showcursor();                    /* show it */

    /*      Show info box
     */
    gdialog( GDINFORM, GDOKCAN );
    gdwrite( "Information box with two options.\n" );
    gdwrite( "Colors are a calm blue on white.\n" );
    gdwrite( "There are 4 lines of text available.\n");
    gdwrite( "This is line 4." );
    option = gdprompt();
    gdclose();

    gdialog( GDINFORM, GDOKAY );
    if( option == 0 )
        gdwrite( "You selected \"OKAY\"" );
    else
        gdwrite( "You selected \"CANCEL\"" );
    option = gdprompt();
    gdclose();


    /*      Show warning box.
     */
    gdialog( GDWARN, GDYESNO );
    gdwrite( "This is the Warning box.\n" );
    gdwrite( "Good for \"Are you sure?\" conditions\n" );
    gdwrite( "Only 3 lines available." );
    option = gdprompt();
    gdclose();

    gdialog( GDINFORM, GDOKAY );
    if( option == 0 )
        gdwrite( "You selected \"YES\"" );
    else
        gdwrite( "You selected \"NO\"" );
    option = gdprompt();
    gdclose();

    /*      Show error box.
     */
    gdialog( GDERROR, GDOKAY );
    gdwrite( "Error box.  Maybe you'd like to add an\n");
    gdwrite( "alarm.  Only three lines of text\n" );
    gdwrite( "available." );
    option = gdprompt();
    gdclose();

    gdialog( GDINFORM, GDOKAY );
    gdwrite( "You could only select \"OKAY\"" );
    gdprompt();
    gdclose();

    setvideomode( _DEFAULTMODE );
    ms_reset();

    exit(0);
}
/*-------------------------------------------------------------*
 *                      End of GDDEMO.C                        *
 *-------------------------------------------------------------*/
