/*--------------------------------------------------------------
 *  File:           MPORIGIN.C
 *  Description:    To give MSC 6.0 compatibility without
 *                  having to rebuild the MPLUS system.  Primarily
 *                  for non-registered users who do not have access
 *                  to source code.
 *
 *  Developed for the MPLUS Graphic Interface Library
 *  Copyright 1989, 1990 by Michael Yam.
 *  All rights reserved.
 *-------------------------------------------------------------*/

#include <graph.h>
#undef _setlogorg           /* defined in graph.h */
#undef _getlogcoord

/*--------------------------------------------------------------
 *  Function:       _setlogorg
 *  Description:    MSC 6.0 renamed this function to _setvieworg,
 *                  producing an unresolved external when linking 
 *                  with MPLUS (which calls _setlogorg).  This
 *                  is just a "wrapper" to make MPLUS aware of
 *                  of _setvieworg.
 *
 *                  If you have source code, you don't need this.
 *                  Just "remake" the system using MSC 6.0.
 *  Return value:   struct xycoord
 *--------------------------------------------------------------*/
struct xycoord _far _cdecl _setlogorg(x,y)
short x,y;
{
    return _setvieworg (x,y);
}

/*--------------------------------------------------------------
 *  Function:       _getlogcoord
 *  Description:    MSC 6.0 renamed this function to _getvieworg,
 *                  producing an unresolved external when linking 
 *                  with MPLUS (which calls _getlogcoord).
 *
 *                  If you have source code, you don't need this.
 *                  Just "remake" the system using MSC 6.0.
 *  Return value:   struct xycoord
 *--------------------------------------------------------------*/
struct xycoord _far _cdecl _getlogcoord (x,y)
short x,y;
{
    return _getviewcoord(x,y);
}
/*--------------------------------------------------------------*
 *                      End of MPORIGIN.C                       *
 *--------------------------------------------------------------*/




