/*--------------------------------------------------------------
 *  File:           GPLUS.H
 *  Description:    Function definitions for MPLUS graphics functions.
 *
 *  Developed for the MPLUS Graphic Interface Library
 *  Copyright (c) 1989 by Michael Yam
 *-------------------------------------------------------------*/

#if !defined(_MPTYPES)
typedef short word;
#define _MPTYPES                /* include only once */
#endif

/*      Window border defines.  MSC already defines
 *      _GBORDER and _GFILLINTERIOR in graph.h.
 *      MPLUS adds two new ones for windows with depth.
 */
#define _GRAISE     0x10
#define _GSINK      0x11

/*      Dialog box constants
 */
#define GDINFORM    0
#define GDWARN      1
#define GDERROR     2

#define GDOKAY      0
#define GDOKCAN     1
#define GDYESNO     2

/*      The graphic window structure
 */
#define GSAVEBUFS   5                   /* max save buffers for GWDW */

/*      This structure defines the graphic window type.  Referencing
 *      the structure elements directly is convenient but
 *      there are no guarantees that the structure won't change
 *      in future versions.
 */
typedef struct _gwdw
{
    char *savebuf[GSAVEBUFS];       /* save region may be broken up */
    word x1, y1, x2, y2;            /* gwindow coords */
    char border;                    /* 1 of 4 types of borders */
    word fg;                        /* foreground color & border color */
    word bg;                        /* background color */
    struct xycoord gpos;            /* graphic cursor position */
    struct rccoord tpos;            /* text cursor position */
    struct xycoord origin;          /* graphic origin */
}GWDW;

/*      Prefix MPLUS function names which resemble MSC's names with
 *      an "mp".  This change introduced with MPLUS 1.3.
 */
#define outtext(text,fg,bg)             mpouttext(text,fg,bg)
#define setvideomode(mode)              mpsetvideomode(mode)
#define getimage(x1,y1,x2,y2,buffer)    mpgetimage(x1,y1,x2,y2,buffer)
#define putimage(x1,y1,buffer,action)   mpputimage(x1,y1,buffer,action)

/*-------------------------------------------------------------*
 *  MPLUS Internals.  Only of interest if you are playing
 *  with the source code.
 *-------------------------------------------------------------*/
#define GDTYPE_MAX  2
#define GDPROMPTS_MAX  4

#define BiosScrollUp    6               /* scoll up and down */
#define BiosScrollDn    7

struct _vport
{
    word x1, y1;
    word x2, y2;
    char border;
    word fg;
    word bg;
};

struct _twdw
{
    word r1, c1;
    word r2, c2;
    char border;
    word fg;
    word bg;
};

struct vportdata
{
    word x1, y1, x2, y2, gfg, gbg;
    word r1, c1, r2, c2, tfg, tbg;
    char gborder, tborder;
};

struct gdialogue
{
    char count;
    char *prompt[GDPROMPTS_MAX];
    word xo1, yo1, xo2, yo2;
    word fg, bg, hsfg, hsbg, highlite;
    word x1[ GDTYPE_MAX ], y1[ GDTYPE_MAX ], x2[ GDTYPE_MAX ], y2[ GDTYPE_MAX ];
    word c1[ GDTYPE_MAX ], c2[ GDTYPE_MAX ]; 
    word hotrow;
};

extern struct _twdw _twdw;
extern struct _vport _vport;
extern struct videoconfig _videoconfig;

extern GWDW *_currgwdw;

/*-------------------------------------------------------------*
 *  Function Prototypes arranged by source module.
 *  See also MPMENU.H and MOUSER.H.
 *
 *  Note: some functions are for MPLUS' internal use.
 *-------------------------------------------------------------*/

/* MPLUS0.C */
extern  int mpsetvideomode(word mode);
extern  void resetviewport(void);
extern  void resettextwindow(void);
extern  int ginrectangle(int x0,int y0,int x1,int y1,int x2,int y2);

/* MPLUS1.C */
extern  int mpwordwrap(char flag);
extern  void inc_tcursor(struct rccoord *tcursor);
extern  void mpoutchar (int ch, word fg, word bg);
extern  void mpouttext(char *msg,word fg,word bg);
extern  void _mpoutword(char *msgword,int wordlen,word fg,word bg);
extern  void _xorchar(char ch,word fg,word bg);
extern  int getvisualpage(void);
extern  word charwidth(void);
extern  word charheight(void);
extern  void tscroll(word r1,word c1,word r2,word c2,int lines,int direction,word bg);

/* MPLUS2.C */
extern  void mpsetviewport(word x1,word y1,word x2,word y2,char border,word fg,word bg);
extern  void mpsettextwindow(word r1,word c1,word r2,word c2,char border,word fg,word bg);
extern  void getgrafcoord(word row,word col,word *y,word *x);
extern  void gettextcoord(word x,word y,word *col,word *row);
extern  void vport_to_wdw(word x1,word y1,word x2,word y2,word *r1,word *c1,word *r2,word *c2);
extern  void wdw_to_vport(word r1,word c1,word r2,word c2,word *x1,word *y1,word *x2,word *y2);
extern  struct vportdata *vportsave(void);
extern  int vportrestore(struct vportdata *vport);

/* MPLUS3.C */
extern void mpoutgtext (char *text, word fg, word bg);

/* MPGWDW0.C */
extern  void gwdwclr(struct _gwdw *gwptr);
extern  int gwdwsetactv(struct _gwdw *gwptr);
extern  struct _gwdw *gwdwgetactv(void);
extern  void gwdwnoactv(void);
extern  int ginwindow(struct _gwdw *gwptr,word x,word y);
extern  struct _gwdw *gwdwtopen(word r1,word c1,word r2,word c2,char border,word fg,word bg);
extern  int gwdwclose(struct _gwdw *gwptr);
extern  struct _gwdw *gwdwopen(word x1,word y1,word x2,word y2,char border,word fg,word bg);
extern  void gwdwgetorg(struct _gwdw *gwptr,word *x,word *y);
extern  void gwdwsetorg(struct _gwdw *gwptr,word x,word y);
extern  int gwdwbreak(struct _gwdw *gwptr);

/* MPGWDW1.C */
extern  int grootclose(struct _gwdw *gwptr);
extern  struct _gwdw *grootopen(word x1,word y1,word x2,word y2,char border,word fg,word bg);
extern  struct _gwdw *groottopen(word r1,word c1,word r2,word c2,char border,word fg,word bg);

/* MPIMAGE.C */
extern  char *gpickup(int x1,int y1,int x2,int y2);
extern  int  gputdown(int x1,int y1,char *object,int action);
extern  void mpgetimage(word x1,word y1,word x2,word y2,char *buffer);
extern  void mpputimage(word x1,word y1,char *buffer,word action);
extern  int  physhighlite(word x1,word y1,word x2,word y2);
extern  int  loghighlite(word x1,word y1,word x2,word y2);

/*  MPINPUT.C */
int mpinput (char *buffer, int maxlen, unsigned char ctype, word fg, word bg);

/* MPDIAL.C */
extern  int gdinit(char * *gd_prompt,int count,word fg,word bg,word hsfg,word hsbg,word highlite);
extern  struct _gwdw *gdopen(void);
extern  void gdclose(void);
extern  int gdwrite(char *text);
extern  int gdprompt(void);
extern  int gdboxprompt(word r1,word c1,int index);
extern  int gdhighlite(word x1,word y1,word x2,word y2);
extern  int gdialog(char dialtype,char prompt);
extern  void gdesckey(unsigned char ch);
extern  void gdenterkey(unsigned char ch);

/* MPXORL.C */
extern  void xorline(word x1,word y1,word x2,word y2,word fg,word bg);
extern  void xorpt(word x,word y,word fg,word bg);
/*-------------------------------------------------------------*
 *                  End of GPLUS.H                             *
 *-------------------------------------------------------------*/

