//************************************************************************
// MOUSE.H class header file
// Stephen A. Edwards Januray 1994

#ifndef __MOUSE
#define __MOUSE

// Mouse events

#define Move			1	// Move
#define LeftPress		2	// Left   button pressed
#define LeftRelease		4	// Left   button released
#define RightPress		8	// Right  button pressed
#define RightRelease		16	// Right  button released
#define CentrePress		32	// Centre button pressed
#define CentreRelease		64	// Centre button released
#define AllEvents		127	// all mouse events

// Return status's

#define Success			1
#define	FailedDriverInit	-1
#define NoEvents		-2

class MOUSE
{
public :

// number of buttons on mouse
short int		GetNoOfButtons(){ return( NoOfButtons ); };

long int		HideMouse( void );
long int		ShowMouse( void );

short int		GetCol( void );
short int		GetRow( void ) ;

long int		EventWait(
			  short int WaitEvent,
			  unsigned short int * e,
			  unsigned short int * x,
			  unsigned short int * y,
			  time_t * t);

long int		GetNewEvent(
			  unsigned short int * e,
			  unsigned short int * x,
			  unsigned short int * y,
			  time_t * t);

			MOUSE( void );		// constructor
			~MOUSE ( void );	// destructor

private :
static short int	NoOfButtons;	// number of buttons on mouse

};

#endif