//***************************************************************************
// Stephen A.Edwards August 1994
// EXAMPLE.CPP - Mouse Class Example

#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <conio.h>

#include "mouse.h";

#define	S_OUT(index,val) {outportb(0x3C4,index);outportb(0x3C5,val);}
#define	G_OUT(index,val) {outportb(0x3CE,index);outportb(0x3CF,val);}

union REGS r;
long int	ScreenWidth;
long int	ScreenHeight;
long int	CharWidth;
long int	CharHeight;

//***************************************************************************
// Get screen resolution in given standard vga 16 color graphic mode

void GetResolution( long int Mode, long int * Width, long int * Height )
{
switch( Mode )
  {
  case 0x0D :
    *Width     = 320;
    *Height    = 200;
    CharWidth  = 8;
    CharHeight = 8;
    break;

  case 0x0E :
    *Width     = 640;
    *Height    = 200;
    CharWidth  = 8;
    CharHeight = 8;
    break;

  case 0x10 :
    *Width     = 640;
    *Height    = 350;
    CharWidth  = 8;
    CharHeight = 14;
    break;

  case 0x12 :
    *Width     = 640;
    *Height    = 480;
    CharWidth  = 8;
    CharHeight = 16;
    break;

  default :
    *Width  = 0;
    *Height = 0;
    break;
  }
}

// inqmode - get current video mode
long int InqMode()
{
r.h.ah = 0x0F;
int86(0x10, &r, &r);
return (r.h.al);
}

// InqPage - get current display page
long int  InqPage()
{
r.h.ah = 0x0F;
int86(0x10, &r, &r);
return(r.h.bh);
}

// setmode - set graphics mode
long int SetMode(long int Mode)
{
GetResolution( Mode, &ScreenWidth, &ScreenHeight );

// return 0 if this is not a supported mode
if( ScreenWidth == 0 || ScreenHeight == 0 ) return( 0 );

r.h.ah = 0;
r.h.al = Mode;
int86(0x10, &r, &r);

// return with success
return ( 1 );
};

// set cursor position on this page using ROM BIOS
void SetCursor( short int X, short int Y, short int page)
{
r.h.ah = 2;
r.h.bh = page;
r.h.dh = Y;
r.h.dl = X;
int86(0x10, &r, &r);
}

// inqvideoadapter - find which graphics adapter is present
char InqVideoAdapter()
{
_AX = 0x1A00;
geninterrupt(0x10);
if(_AL == 0x1A) return('V');  // VGA adapter

_AH = 0x12; _BL = 0x10;
geninterrupt(0x10);
if(_BL != 0x10) return('E');  // EGA adapter

return('\0');
}

// Set given Palette to this Color
void SetPalette( short int Palette, unsigned char Color )

{
r.h.ah = 0x10;
r.h.al = 0x00;
r.h.bl = Palette;
r.h.bh = Color;
int86(0x10, &r, &r);
}

// write char at X, Y on page with Background and foreground colors
void PutChar( short int X, short int Y,
	   unsigned char Chr,
	   unsigned char ForeGround,
	   unsigned char BackGround)
{
SetCursor( X, Y, 0);

// if not using current background - set background
if( BackGround > 0 )
  {
  r.h.ah = 0xA;
  r.h.bh = 0;
  r.h.al = 219;
  r.h.bl = BackGround;
  r.x.cx = 1;
  int86(0x10, &r, &r);

  // set bit 7 so our char is xor'ed with our background
  ForeGround |= (0x1 << 7);
  }

// clear character
r.h.ah = 0xA;
r.h.bh = 0;
r.h.al = Chr;
r.h.bl = (BackGround |= (0x1 << 7) );
r.x.cx = 1;
int86(0x10, &r, &r);

// draw character
r.h.ah = 0xA;
r.h.bh = 0;
r.h.al = Chr;
r.h.bl = ForeGround;
r.x.cx = 1;
int86(0x10, &r, &r);
}


// DrawXY - turn on pixel at x,y assuming we are using page 0
void DrawXY(long int X, long int Y, long int color)

{
static long int		Row = ScreenWidth / 8;
unsigned long int	Offset;
char			Mask;
char far *		Address;
unsigned char 		Dummy;

Offset  = (long)Y * Row + ((long)X / 8L);
Address	= (char far *) 0xA0000000L + Offset;

// set bit in mask
Mask = 0x80 >> (X % 8);

// set output mask for write to mask
G_OUT(8, Mask);

// enable write to all planes
S_OUT(2, 0x0F);

Dummy = *Address;
Dummy = 0;
// clear all of the planes
*Address = Dummy;

// enable write to planes for current color
S_OUT(2, color);

// set bit in mask for planes of current color
*Address = 0xFF;

// enable write to all planes
S_OUT(2, 0x0F);

G_OUT(3, 0);

// mask all bits for output
G_OUT(8, 0xFF);
}

//***************************************************************************
// Main

main( int argc, char * argv[] )
{
MOUSE		*Mouse;		// instance of mouse class.

long int	Status;
long int	Index = 0;
long int	OldMode;
long int	NewMode = 18;
long int	BackGround = 0;
long int	ForeGround = 4;
char		Buffer[80];

unsigned char		Trace = 0;
unsigned short int	Row;
unsigned short int	Col;
unsigned short int	XPixel;
unsigned short int	YPixel;
unsigned short int	EvType;
time_t			EvTime;

char	*	Intro[] = {
"                Example Program for use with MOUSE class.               ",
"                -----------------------------------------               ",
"This is a doodle program to demonstrate how the mouse works with the    ",
"C++ MOUSE class.  To begin drawing move the mouse pointer somewhere on  ",
"the screen and click the left mouse button. Now as you move the mouse   ",
"on the screen a pattern of dots will follow it. To change the background",
"the left mouse button in the top left corner where indicated. To change ",
"the foreground also click in the top left corner where indicated.       ",
"  The program will work in the standard VGA modes 13, 14, 16 and 18,    ",
"you can specify one of these modes on the command line when running the ",
"program. ",
"  Have fun, you can produce some interesting patterns.",
" ",
"Press any key to continue " };


for( Index = 0; Index < (sizeof(Intro)/sizeof(char *) ); Index++)
  printf("%s\n",Intro[Index] );

while( !kbhit() );

// clear keyboard buffer - don't echo
getch();

// make sure VGA adapter is available
if( InqVideoAdapter() != 'V' )
  {
  printf(" VGA Adapter not found \n");
  exit(0);
  }

// if a video mode was specified on command line - get it
if( argc > 1 && argv[1] )
  NewMode = atoi( argv[1] );

// determine resolution of specified vga standard graphic mode
GetResolution( NewMode, &ScreenWidth, &ScreenHeight );

// exit if this is not a supported mode
if( ScreenWidth == 0 || ScreenHeight == 0 )
  {
  printf(" Not a valid standard vga graphic mode \n");
  printf(" Use modes 13, 14, 16 or 18 \n");
  exit(0);
  }

// save current mode
OldMode = InqMode();

// set graphic mode
if( SetMode( NewMode ) )
  {
  // create pointer to mouse class
  Mouse = new MOUSE();

  // make the mouse visible
  Status = Mouse->ShowMouse();

  // if mouse driver is available
  if( Status == Success )
    {
    sprintf( Buffer, " Click Here To Exit              ");

    for(Index = 0; Index < strlen( Buffer ); Index++ )
      PutChar(Index, 2, Buffer[Index], 0, 2);

    sprintf( Buffer, " Click To Change Background      ");

    for(Index = 0; Index < strlen( Buffer ); Index++ )
      PutChar(Index, 3, Buffer[Index], 0, 3);

    sprintf( Buffer, " Click Here To Change Foreground ");

    for(Index = 0; Index < strlen( Buffer ); Index++ )
      PutChar(Index, 4, Buffer[Index], 0, 4);

    // while No error
    while ( Status && EvType != RightPress)
      {
      // get next mouse event
      Status = Mouse->GetNewEvent( &EvType, &XPixel, &YPixel, &EvTime );

      if( Status == Success )
	{
	// convert from pixels to character row and column
	if( NewMode == 13 )
	  Col = XPixel / (CharWidth * 2);
	else
	  Col = XPixel / CharWidth;

	Row = YPixel / CharHeight;

	// toggle trace flag when left button pressed
	if( EvType == LeftPress )
	  {
	  // if click on "click to exit"
	  if( Row == 2 && Col <= 32 )
	    Status = 0;
	  // if click on "click to change background"
	  else if( Row == 3 && Col <= 32 )
	    SetPalette( 0, ++BackGround );
	  else if( Row == 4 && Col <= 32 )
	    ForeGround++;
	  else
	    Trace = ( Trace == 1 ? 0 : 1 );
	  }

	if( Trace == 1 && !(Row < 5 && Col < 33) )
	  {
	  if( NewMode == 13 )
	    DrawXY( XPixel/2, YPixel, ForeGround );
	  else
	    DrawXY( XPixel, YPixel, ForeGround );
	  }

	sprintf( Buffer, "Row %d Col %d Type %d   ", Row, Col, EvType );

	for(Index = 0; Index < strlen( Buffer ); Index++ )
	  PutChar(Index, 0, Buffer[Index], 1, 2);

	}
      } // end while no error
    }
  Status = Mouse->HideMouse();
  delete Mouse;

  // restore old mode
  r.h.ah = 0;
  r.h.al = OldMode;
  int86(0x10, &r, &r);

  } // endif set new mode okay
}



