/*
 * Module : gsx.c
 * Purpose: PC Simulation of GSX - SIMPLE Graphics Support for X.
 * Written by ranco on March 92, using same functions as on the X11.
 */

#include <stdio.h>
#include <graphics.h>
#include "gsx.h"
#include "mouselib.h"

unsigned int oMaxX, oMaxY, Color;

static FuncV g_function[] = {
GNULLFUNCTION,
GNULLFUNCTION,
GNULLFUNCTION,
GNULLFUNCTION,
GNULLFUNCTION,
GNULLFUNCTION,
GNULLFUNCTION,
GNULLFUNCTION,
GNULLFUNCTION,
GNULLFUNCTION,
GNULLFUNCTION,
GNULLFUNCTION,
GNULLFUNCTION
};


/*------------------------------------------------------------------------*/
void GSetForeground(int c)
{
   switch (c) {
	case INVERTED:
		setcolor(0);
		break;
	case NORMAL:
		setcolor(Color);
		break;
	}
}

/*------------------------------------------------------------------------*/
void GFuncSet(FuncV func, GEventT type)
{
	g_function[type] = func;
}

/*------------------------------------------------------------------------*/
void GWindow(int x, int y, int width, int height, char *name)
{
   int frame[10] = {0,0,0,0,0,0,0,0,0,0};

   int gdriver = DETECT, gmode;
/*   initgraph(&gdriver, &gmode, ""); */
   oMaxX = getmaxx();
   oMaxY = getmaxy();
   Color = getmaxcolor();
   frame[2] = frame[4] = oMaxX;
   frame[5] = frame[7] = oMaxY;
   drawpoly(5, frame);
   setviewport (1, 1, oMaxX-1, oMaxY-1, 1);

   setMouseGraph();  /* !!!!!!!!!! Only for Hercules cards !!!!!!!!!!!! */

   if (doMouse() == ERR) {
      closegraph();
      printf("Mouse not present!\n");
      exit(0);
      }

   setDefaultHandler(MOUSE_MASK);

}

/*------------------------------------------------------------------------*/
void GMainLoop(void)
{

   GEvent g_event;
   unsigned x, y;
   enum buttonState *left_button, *right_button, *middle_button;
   int kp = 0;

   while (1) {
      while (eventHappened == FALSE && !(kp = kbhit()));    /* WAIT......... */

      getLastEvent(&x, &y, left_button, right_button, middle_button);
      g_event.x = x;
      g_event.y = y;

      if (kp) {   /* Key pressed */
	  g_event.key = (unsigned int) getchar();
	  (*g_function[GKey])(g_event);
	  }
      else if (Drag) {
	      (*g_function[GDrag])(g_event);
	   }
      else if (*left_button == buttonDown) {
	      (*g_function[GButton1Press])(g_event);
	   }
      else if (*left_button == buttonUp && (LastEventButtons & LEFTBUTTON)) {
	      (*g_function[GButton1Release])(g_event);
	   }
      else if (*middle_button == buttonDown && !(LastEventButtons & MIDDLEBUTTON)) {
	      (*g_function[GButton2Press])(g_event);
	   }
      else if (*middle_button == buttonUp && (LastEventButtons & MIDDLEBUTTON)) {
	      (*g_function[GButton2Release])(g_event);
	   }
      else if (*right_button == buttonDown && !(LastEventButtons & RIGHTBUTTON)) {
	      (*g_function[GButton3Press])(g_event);
	   }
      else if (*right_button == buttonUp && (LastEventButtons & RIGHTBUTTON)) {
	      (*g_function[GButton3Release])(g_event);
	   }
      else {
	      (*g_function[GMotion])(g_event);
	 }
   }
}

/*------------------------------------------------------------------------*/
void GRectangle(int x, int y, int w, int h)
{
   int frame[10] = {0,0,0,0,0,0,0,0,0,0};

   frame[0] = frame[6] = frame[8] = x;
   frame[1] = frame[3] = frame[9] = y;
   frame[2] = frame[4] = x+w;
   frame[5] = frame[7] = y+h;
   hideMouseCursor ();
   drawpoly(5, frame);
   showMouseCursor ();

}

/*------------------------------------------------------------------------*/
int GGetPixel(int x, int y)
{
   return (getpixel(x,y));
}


/*------------------------------------------------------------------------*/
void GRectangleFill(int x, int y, int w, int h)

{
   int frame[10] = {0,0,0,0,0,0,0,0,0,0};

   frame[0] = frame[6] = frame[8] = x;
   frame[1] = frame[3] = frame[9] = y;
   frame[2] = frame[4] = x+w;
   frame[5] = frame[7] = y+h;

   hideMouseCursor ();
   fillpoly(5, frame);
   showMouseCursor ();

}

/*------------------------------------------------------------------------*/
void GLine(int x1, int y1, int x2, int y2)
{
   hideMouseCursor ();
   line (x1,y1,x2,y2);
   showMouseCursor ();

}


/*------------------------------------------------------------------------*/
void GText(int x, int y, char *text)
{
   hideMouseCursor ();
   outtextxy(x, y, text);
   showMouseCursor ();

}

/*------------------------------------------------------------------------*/
void GCircleFill(int x, int y, int r)
{
   hideMouseCursor ();
   fillellipse(x, y, r>>1, r>>1);
   showMouseCursor ();
}

/*------------------------------------------------------------------------*/
void GCircle(int x, int y, int r)
{
   hideMouseCursor ();
   circle(x, y, r);
   showMouseCursor ();
}

/*------------------------------------------------------------------------*/
void GLinewidth(unsigned int w)
{
   setlinestyle(0,0,w);
}


/*---------------------------------------------------------------------*/
void GClear(void)
{

   hideMouseCursor ();
   clearviewport();
   showMouseCursor ();

}

/*------------------------------------------------------------------------*/
void GDrawMode(int mode)
{
	switch (mode) {
	    case NORMAL  :
		 setcolor(Color);
		 break;
	    case INVERTED:
		 setcolor(0);
		 break;
	}
}

/*------------------------------------------------------------------------*/
void GNullEvent(GEvent g_event)
{
   return;        /* Do nothing */
}


/*------------------------------------------------------------------------*/
void GcloseWindow (void)
{
   closeMouse();
   closegraph();
}

