#include <math.h>
#include <stdlib.h>
#include <stdio.h>

#define Epsilon   0.0005    /* Quiet randomly chosen to prevent 
			       zero-devision in Vec2fNormal   */

typedef struct Vec2f_S {
   float x;
   float y;
   } Vec2f;

typedef struct Vec3f_S {
   float x;
   float y;
   float z;
   } Vec3f;


#define list float *

typedef struct Matrix {
  int rows, cols;
  list elems;
} Matrix;


/* Vec2f op. prototypes */

#define Vec2fGetX(v)       (v->x)
#define Vec2fGetY(v)       (v->y)

Vec2f *Vec2fNew()                                           ;
Vec2f *Vec2fCreate (float X, float Y)                       ;
void Vec2fCopy (Vec2f *v1, Vec2f *v2)                       ;
Vec2f *Vec2fSetX(Vec2f *v, float val)                       ;
Vec2f *Vec2fSetY(Vec2f *v, float val)                       ; 
Vec2f *Vec2fAdd(Vec2f *v1, Vec2f *v2, Vec2f *result)        ;
Vec2f *Vec2fSub(Vec2f *v1, Vec2f *v2, Vec2f *result)        ;
float Vec2fLen(Vec2f *v)                                    ;
Vec2f *Vec2fNeg(Vec2f *v, Vec2f *Result)                    ;
Vec2f *Vec2fNormal (Vec2f *v, Vec2f *result)                ;
Vec2f *Vec2fMulScalar(float s, Vec2f *v, Vec2f *result)     ;
float Vec2fMul(Vec2f *v1, Vec2f *v2)                        ;


/* Vec3f op. prototypes */

#define Vec3fGetX(v)       (v->x)
#define Vec3fGetY(v)       (v->y)
#define Vec3fGetZ(v)       (v->z)


Vec3f *Vec3fNew()                                           ;
Vec3f *Vec3fCreate (float X, float Y, float Z)              ;
void Vec3fCopy (Vec3f *v1, Vec3f *v2)                       ;
Vec3f *Vec3fSetX(Vec3f *v, float val)                       ;
Vec3f *Vec3fSetY(Vec3f *v, float val)                       ; 
Vec3f *Vec3fAdd(Vec3f *v1, Vec3f *v2, Vec3f *result)        ;
Vec3f *Vec3fSub(Vec3f *v1, Vec3f *v2, Vec3f *result)        ;
float Vec3fLen(Vec3f *v)                                    ;
Vec3f *Vec3fNeg(Vec3f *v, Vec3f *Result)                    ;
Vec3f *Vec3fNormal (Vec3f *v, Vec3f *result)                ;
Vec3f *Vec3fMulScalar(float s, Vec3f *v, Vec3f *result)     ;
float Vec3fMul(Vec3f *v1, Vec3f *v2)                        ;


/* Matrix op. prototypes */
Matrix *MatNew(int rows, int cols)                          ;
Matrix *MatCreate (int rows, int cols, list elements)       ;
Matrix *MatMul (Matrix *Mat1, Matrix *Mat2, Matrix *MatRet) ;
Matrix *MatScalarMul(float s, Matrix *Mat, Matrix *MatRet)  ;
void MatPrint (Matrix *Mat)                                 ;
int MatNull(Matrix *Mat)                                    ;
float MatDet(Matrix *Mat)                                   ;
float Minor(Matrix *Mat, int i, int j)                      ;
Matrix *MatInv(Matrix *Mat, Matrix *MatRet)                 ;
void MatFree (Matrix *Mat)                                  ;
void MatCopy (Matrix *Mat1, Matrix *Mat2)                   ;


#define MatRows(Mat)          (Mat->rows)
#define MatCols(Mat)          (Mat->cols)
#define MatElems(Mat)         (Mat->elems)
#define MatGet(Mat, r, c)     Mat->elems[MatCols(Mat)*(r) + (c)]
#define MatSet(Mat, r, c, e)  Mat->elems[MatCols(Mat)*(r) + (c)] = (e)
