//
// Money.c
// 
// To see what 's going on, you need to use your symbolic debugger to
// examine each of the declared variables

/*
   For BC++, I use the following watches;
  
	m_money		d, fl8
	m, r		i
	mm, r		l
	elapsed		s, fl8

	Change the compile time macro to see how money's change their behaviour

*/

// #define TEST

// #ifdef TEST

#if 0
	#define MONEY_ROUNDING 	/* Force rounding of doubles */
#endif

#define MONEY_DECIMALS 	2	/* 2 decimals for money data */

extern "C++" {
    #include "money.h"
    #ifdef __TURBOC__
    #include <iostream.h>
    #else
    #include <stream.h>
    #endif
}

inline ostream& operator << (ostream &out, money& m)
{
   return out << (double) m;
}

extern "C" {
   #include <stdlib.h>
   #include <time.h>
   #include <stdio.h>
}

// #define 	RANGER
// #undef 		RANGER	/* takes forever to run */

void ranger();

main()
{

	// To the right is the assigned value

	money m(25.8499);

	money mm;

	int i = 5;		// 5
	long l = 6;		// 7
	double d = m;		// 25.8399999999999999999

	i = m;			// 25
	m = d;			// $ 25.84
	m = 7.009999;		// $ 7.00
	m += 1;			// $ 8.00
	m += 1.254000;		// $ 9.24
	m += 1L;		// $ 10.24
	m += 'a';		// $ 'a' + 10.24

	m = -d;			// $ -25.84
	m = -7.0000009;		// $ -7.00
	m -= 1;			// $ -8.00
	m -= 1.254000;		// $ -9.24
	m -= 1L;		// $ -10.24
	m -= 'a';		// $ -'a' - 10.24


	mm = 10;		// $ 10.00
	m = mm + 4;		// $ 14.00
	m = mm + 4.014999;	// $ 14.01
	m = 4.99 + mm;		// $ 14.99
	m = 4 + mm;		// $ 14.00
	m = m + mm;		// $ 24.00
	m += m;			// $ 48.00

	d = mm + 4;		// $ 14.00

}
