NAME
   mkproto - make prototypes for functions


SYNOPSIS
   mkproto [-n] [-s] [-p] [ file ] ...


DESCRIPTION
   Mkproto takes as input one or more C source code files, and
produces as output (on the standard output stream) a list of function
prototypes (a la ANSI) for the external functions defined in the
given source files. This output, redirected to a file, is suitable
for #include'ing in a C source file.
   The function definitions in the original source
may be either "old-style" (in which case appropriate prototypes are
generated for the functions) or "new-style" (in which the definition
includes a prototype already).
   A -n option causes the line number where each function was defined
to be prepended to the prototype declaration as a comment.
   A -s option causes prototypes to be generated for functions declard
"static" as well as extern functions.
   A -p option causes the prototypes emitted to be only readable by ANSI
compilers. Normally, the prototypes are "macro-ized" so that compilers
with __STDC__ not defined don't see them. 
   If files are specified on the command line, then a comment specifying
the file of origin is emitted before the prototypes constructed from
that file. If no files are given, then no comments are emitted and
the C source code is taken from the standard input stream.

BUGS
   Mkproto is easily confused by complicated declarations, such as
         int ((*signal)())() { ...
or
         struct foo { int x, y; } foofunc() { ...

   Float types are not properly promoted in old style definitions,
i.e.
         int test(f) float f; { ...
should (because of the default type conversion rules) have prototype
         int test(double f);
rather than the incorrect
         int test(float f);
generated by mkproto.

   Some programs may need to be run through the preprocessor before
being run through mkproto. The -n option is unlikely to work as desired
on the output of a preprocessor.

   Typedef'd types aren't correctly promoted, e.g. for
        typedef schar char; int foo(x) schar x;...
mkproto incorrectly generates the prototype int foo(schar x) rather than
the (correct) int foo(int x).

   Functions named "inline" with no explicit type qualifiers are not
recognized.

SEE ALSO
   cc(1), lint(1)

AUTHOR
   Eric R. Smith.

NOTE
   There is no warranty for this program (as noted above, it's guaranteed
to break sometimes anyways!). Mkproto is in the public domain.

README
Here is mkproto, a program for generating prototype declarations for all
functions appearing in a C source file. The input C code may be either
K&R or ANSI C (i.e. it's OK if the functions are defined using prototypes).
Unlike some of the sed-based scripts floating around, it correctly
handles prototype promotion (e.g. the prototype for 'int foo() char x;...'
is 'int foo(int x)'). Also, it should work OK on just about any computer,
not just Unix-based ones (it's been tested under minix, Unix, and TOS).

Use: typically, you would type 'mkproto *.c >proto.h' and then add a
'#include "proto.h"' line to all the C source files. An ANSI conformant
compiler will then be able to do type checking on function calls across
module boundaries. As a bonus, proto.h will tell you which source files
functions were defined in, and (if you gave the -n function to mkproto)
their line numbers. The resulting include file may also be used by
non-ANSI compilers; you can disable this feature (for cleaner, strictly
ANSI-conforming output) with the -p flag.

Please read the description of bugs in mkproto.man; definitely mkproto
will not handle all programs correctly, but it does work on the majority of
them. A sample of its output is provided in the file "mkproto.h"; this
is the result of 'mkproto mkproto.c >mkproto.h'.

There is ABSOLUTELY NO WARRANTY for the program; as I said, it doesn't work
on all programs (complicated function definitions can make it produce bogus
output). It does what I need, though, and it can certainly make porting stuff
to ANSI compilers easier.

Mkproto is in the public domain. If you find any bugs (other than the ones
documented) please let me know.
--
Eric R. Smith                     email:
Dept. of Mathematics            ersmith@uwovax.uwo.ca
University of Western Ontario   ersmith@uwovax.bitnet
London, Ont. Canada N6A 5B7
ph: (519) 661-3638

