// Figure 1 from "A Little CAD with C++"
// Copyright 1988 Bruce Eckel
// Permission required to distribute source

// file: microcad.cpp
/* The main driver program for the CAD system.
   This includes all the other types I've defined,
   declares some instances, and makes them dance
   around. */
#include        <stdio.h>
#include	<stdlib.h>
#include	<conio.h>
#include	<msmouse.h>
// flash graphics declarations:
#include        <fg.h>      
// (All items starting with "fg" are from
// the flash graphics library)
#include        <string.h>
#include        "msmenu.hpp"   // Figure 2
#include        "circle.hpp"   // Figure 5
#include        "square.hpp"   // Figure 7
#include        "line.hpp"     // Figure 9
#include        "shapelst.hpp" // Figure 11

// associate unique integers with the following:
enum { CIRCLE, SQUARE, LINE, MOVE, DELETE, EXIT};

struct menu_s my_menu[] = {
  " circle",    CIRCLE,
  " square",    SQUARE,
  " line",      LINE,
  " move",      MOVE,
  " delete",    DELETE,
  " exit",      EXIT,
  "", -1             /* end marker */
};


main() { 
unsigned x, y;
int quit = 0;  // flag
int result;
shapelist list;
if (fg_init_all () == FG_NULL) {
  fputs ("Unable to open graphics device.\n", 
          stderr);
  exit (1);
  }

// create an msmenu and attach our menu:
msmenu mouse(my_menu);

while (!quit) {  
    // look for right button press:
    if (msm_getstatus(&x,&y) & 2) { 
        // get a menu selection:
        result = mouse.get_selection(x,y);
        // change from mouse to fg coords:
        mouse.translate_coords(&x,&y);
        switch(result) {
            case CIRCLE:
                // create an object on the free
                // store via "new" and add it
                // to the list:
                list.insert(new circle(x,y));
                break;
            case SQUARE:
                list.insert(new square(x,y));
                break;
            case LINE:
                list.insert(new line(x,y));
                break;
            case MOVE:
                mouse.cross_cursor();
                mouse.wait_left_pressed(&x,&y);
                // you can declare a variable at 
                // the point of use:
                cadshape * mv = list.nearest(x,y);
                // (I think nearest() needs work).
                // object pointers use arrows 
                // for de-referencing members:
                mv->erase(); // pick it up
                mouse.wait_left_released(&x,&y);
                mouse.translate_coords(&x,&y);
                mv->move(x,y); // put it down
                mouse.default_cursor();
                break;
            case DELETE:
                mouse.cross_cursor();
                mouse.wait_left_pressed(&x,&y);
                mouse.translate_coords(&x,&y);
                cadshape * rm = list.nearest(x,y);
                rm->erase();
                list.remove(rm);
                // free the memory created w/ new:
                delete rm;
                mouse.default_cursor();
                break;
            case EXIT: 
                quit++;
                break;
            default:
                break;
        }
    } 
}
    fg_term(); // back to text mode
}
