// Figure 4 for "A Little CAD with C++"
// Copyright 1988 Bruce Eckel
// Permission required to distribute source

// file: cadshape.hpp
/* A polymorphic base class for all shapes.
   Almost all functions are virtual, so they
   can be redefined in derived classes.  Then
   we can make a list of shapes and draw()
   each shape in the list without knowing
   exactly what it is. */
#ifndef CADSHAPE_HPP
#define CADSHAPE_HPP
class cadshape {  
    unsigned x_center, y_center;
  public:
    // virtual functions must have SOME
    // definition in the base class, even
    // if it's just empty:
    virtual ~cadshape() {}
    virtual void draw() {}
    virtual void erase() {}
    void 
    move(unsigned new_x, unsigned new_y ) {
        x_center = new_x;
        y_center = new_y;
        draw(); // call proper virtual function
    }
    unsigned long 
    range( unsigned xr, unsigned yr ) {
        // a measure of distance between a 
        // selected point and this object's center
        unsigned long xx = 
          xr > x_center ? 
            xr - x_center : x_center - xr;
            // (ternary if-then-else)
        unsigned long yy = 
          yr > y_center ? 
            yr - y_center : y_center - yr;
        xx *= xx;
        yy *= yy;
        // delta x squared + delta y squared:
        return xx + yy; 
    }
};
#endif CADSHAPE_HPP
