// Figure 12 for "A Little CAD with C++"
// Copyright 1988 Bruce Eckel
// Permission required to distribute source

// file: shapelst.cpp
#include "shapelst.hpp"

cadshape * shapelist::next() {
    cadshape * r = current->shp;
    if ( r != (cadshape *)0 )
        current = current->next;
    return r;
}

void shapelist::remove(cadshape * s) {
    shapelist_element * pp = head, * qq;
    if ( pp->shp == s) {  // check head
        head = pp->next;
        delete pp;
    } else 
    while ( pp->next->shp != 0 ) { 
        // (the next element isn't the last)
        if ( pp->next->shp == s) {
            // unlink the matching element:
            qq = pp->next;
            pp->next = pp->next->next;
            delete qq;
            return;
        }
        pp++;
    }
}

// Find the nearest shape to co-ordinates (x,y) :
cadshape * 
shapelist::nearest(unsigned x, unsigned y) { 
  cadshape * kk;
  cadshape * cshape;
  unsigned long distance;

  reset();  // start at beginning of list
  cshape = next(); // test the first element
  distance = cshape->range(x,y);
  while ((kk = next()) != 0) {
    if ( kk->range(x,y) < distance ) {
       cshape = kk;
       distance = cshape->range(x,y);
    }
  }
  return cshape;
}
