// Figure 13 for "A Little CAD with C++"
// Copyright 1988 Bruce Eckel
// Permission required to distribute source

// file: mscursor.cpp
/* Given a bitmap of ASCII ones and zeros,
   mscursor < bitmap > outfile.cur
   generates a structure for a new mouse
   cursor, with the bitmap as a comment
   block.  This shows how useful streams
   can be. */
#include <stream.hpp>

main() {
char binary[20]; // holds the source pattern
unsigned int positive[16];
unsigned int j; int x = 0;
cout << "int NAME[] = {\n";
while(cin.good()) {
    cin >> binary;
    j = 0; 
    // note the '<<' operator has a different
    // meaning depending on what context it is
    // being used in:
    for (int i = 0, k = 15; i < 16; i++, k-- )
        j |= (binary[i] == '1') ? (1 << k) : 0;
    // streams allow easy writing of hex:
    cout << "0x" << hex(~j) << 
       ",\t\t/* " << binary << " */\n";
    positive[x++] = j; 
    if (x > 15) break;
}
for (int i = 0; i < 16; i++) {
    cout << "0x" << hex(positive[i]) << ", ";
    if ( i == 8) cout << "\n";
}
cout << "\n};\n\n";
}
